/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;

public class LambdaInliner
implements CallInliner {
    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        Object[] parameters;
        PsiMethod method;
        if (builder == null) {
            LambdaInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            LambdaInliner.$$$reportNull$$$0(1);
        }
        if ((method = call.resolveMethod()) == null || method != LambdaUtil.getFunctionalInterfaceMethod(method.getContainingClass())) {
            return false;
        }
        PsiTypeCastExpression typeCastExpression = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(call.getMethodExpression().getQualifierExpression()), PsiTypeCastExpression.class);
        if (typeCastExpression == null) {
            return false;
        }
        PsiLambdaExpression lambda2 = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(typeCastExpression.getOperand()), PsiLambdaExpression.class);
        if (lambda2 == null || lambda2.getBody() == null) {
            return false;
        }
        if (method.isVarArgs()) {
            return false;
        }
        Object[] args = call.getArgumentList().getExpressions();
        if (args.length != (parameters = lambda2.getParameterList().getParameters()).length) {
            return false;
        }
        EntryStream.zip((Object[])args, (Object[])parameters).forKeyValue((arg, parameter) -> {
            if (builder == null) {
                LambdaInliner.$$$reportNull$$$0(2);
            }
            builder.pushVariable((PsiVariable)parameter).pushExpression((PsiExpression)arg).boxUnbox((PsiExpression)arg, parameter.getType()).assign().pop();
        });
        builder.inlineLambda(lambda2, Nullness.UNKNOWN);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inliner/LambdaInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$tryInlineCall$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

