/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.embedding;

import com.intellij.embedding.MasqueradingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndentEatingLexer
extends MasqueradingLexer.SmartDelegate {
    private final int myIndent;
    @NotNull
    private CharSequence myBuffer;
    @NotNull
    private List<DeletedIndentInfo> myDeletions;
    private int myCurrentDelta;
    private int myTotalDelta;
    private int myCurrentDelIndex;

    public IndentEatingLexer(@NotNull Lexer delegate, int baseIndent) {
        if (delegate == null) {
            IndentEatingLexer.$$$reportNull$$$0(0);
        }
        super(delegate);
        this.myIndent = baseIndent;
        this.myBuffer = "";
        this.myDeletions = Collections.emptyList();
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            IndentEatingLexer.$$$reportNull$$$0(1);
        }
        this.myBuffer = buffer;
        this.myDeletions = this.findAllDeletions(buffer, startOffset, endOffset);
        this.myCurrentDelta = 0;
        this.myTotalDelta = 0;
        if (this.myDeletions.isEmpty()) {
            super.start(buffer, startOffset, endOffset, initialState);
            return;
        }
        CharSequence newSequence = this.deleteIndents(buffer, startOffset, endOffset);
        super.start(newSequence, 0, newSequence.length(), initialState);
        this.myTotalDelta = startOffset;
        this.myCurrentDelIndex = 0;
        this.updateDeltas();
    }

    private void updateDeltas() {
        DeletedIndentInfo info;
        this.myTotalDelta += this.myCurrentDelta;
        this.myCurrentDelta = 0;
        while (this.myCurrentDelIndex < this.myDeletions.size() && (info = this.myDeletions.get(this.myCurrentDelIndex)).getShrunkPos() >= super.getTokenStart() && info.getShrunkPos() <= super.getTokenEnd()) {
            this.myCurrentDelta += info.getLength();
            ++this.myCurrentDelIndex;
        }
    }

    @Override
    public void advance() {
        super.advance();
        this.updateDeltas();
    }

    @Override
    public int getTokenStart() {
        return super.getTokenStart() + this.myTotalDelta;
    }

    @Override
    public int getTokenEnd() {
        return super.getTokenEnd() + this.myTotalDelta + this.myCurrentDelta;
    }

    @Override
    @NotNull
    public String getTokenText() {
        String string = this.myBuffer.subSequence(this.getTokenStart(), this.getTokenEnd()).toString();
        if (string == null) {
            IndentEatingLexer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private List<DeletedIndentInfo> findAllDeletions(@NotNull CharSequence buffer, int startOffset, int endOffset) {
        int newline;
        if (buffer == null) {
            IndentEatingLexer.$$$reportNull$$$0(3);
        }
        ArrayList<DeletedIndentInfo> result2 = new ArrayList<DeletedIndentInfo>();
        int offset = startOffset;
        while (offset < endOffset && (newline = StringUtil.indexOf(buffer, '\n', offset, endOffset)) >= 0) {
            char c;
            int charsToDelete;
            for (charsToDelete = 0; charsToDelete < this.myIndent && newline + charsToDelete + 1 < endOffset && (c = buffer.charAt(newline + charsToDelete + 1)) != '\n' && Character.isWhitespace(c); ++charsToDelete) {
            }
            if (charsToDelete > 0) {
                result2.add(new DeletedIndentInfo(newline + 1, charsToDelete));
            }
            offset = newline + charsToDelete + 1;
        }
        ArrayList<DeletedIndentInfo> arrayList = result2;
        if (arrayList == null) {
            IndentEatingLexer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private CharSequence deleteIndents(@NotNull CharSequence buffer, int startOffset, int endOffset) {
        if (buffer == null) {
            IndentEatingLexer.$$$reportNull$$$0(5);
        }
        StringBuilder result2 = new StringBuilder();
        int offset = startOffset;
        for (DeletedIndentInfo deletion : this.myDeletions) {
            result2.append(buffer.subSequence(offset, deletion.getRealPos()));
            deletion.setShrunkPos(result2.length());
            offset = deletion.getRealPos() + deletion.getLength();
        }
        result2.append(buffer.subSequence(offset, endOffset));
        String string = result2.toString();
        if (string == null) {
            IndentEatingLexer.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/embedding/IndentEatingLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/embedding/IndentEatingLexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllDeletions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteIndents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAllDeletions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteIndents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeletedIndentInfo {
        private final int realPos;
        private final int length;
        private int shrunkPos;

        public DeletedIndentInfo(int realPos, int length) {
            this.realPos = realPos;
            this.length = length;
            this.shrunkPos = -1;
        }

        public void setShrunkPos(int shrunkPos) {
            this.shrunkPos = shrunkPos;
        }

        public int getRealPos() {
            return this.realPos;
        }

        public int getLength() {
            return this.length;
        }

        public int getShrunkPos() {
            return this.shrunkPos;
        }
    }
}

