/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class Extensions {
    public static final ExtensionPointName<AreaListener> AREA_LISTENER_EXTENSION_POINT = new ExtensionPointName("com.intellij.arealistener");
    private static LogProvider ourLogger = new SimpleLogProvider();
    private static final Map<AreaInstance, ExtensionsAreaImpl> ourAreaInstance2area = ContainerUtil.newConcurrentMap();
    private static final Map<String, AreaClassConfiguration> ourAreaClass2Configuration = ContainerUtil.newConcurrentMap();
    @NotNull
    private static ExtensionsAreaImpl ourRootArea = Extensions.createRootArea();

    private Extensions() {
    }

    @NotNull
    private static ExtensionsAreaImpl createRootArea() {
        ExtensionsAreaImpl rootArea = new ExtensionsAreaImpl(null, null, null, ourLogger);
        rootArea.registerExtensionPoint(AREA_LISTENER_EXTENSION_POINT.getName(), AreaListener.class.getName());
        ExtensionsAreaImpl extensionsAreaImpl = rootArea;
        if (extensionsAreaImpl == null) {
            Extensions.$$$reportNull$$$0(0);
        }
        return extensionsAreaImpl;
    }

    @NotNull
    public static ExtensionsArea getRootArea() {
        ExtensionsAreaImpl extensionsAreaImpl = ourRootArea;
        if (extensionsAreaImpl == null) {
            Extensions.$$$reportNull$$$0(1);
        }
        return extensionsAreaImpl;
    }

    @NotNull
    public static ExtensionsArea getArea(@Nullable(value="null means root") AreaInstance areaInstance) {
        if (areaInstance == null) {
            ExtensionsAreaImpl extensionsAreaImpl = ourRootArea;
            if (extensionsAreaImpl == null) {
                Extensions.$$$reportNull$$$0(2);
            }
            return extensionsAreaImpl;
        }
        ExtensionsAreaImpl area = ourAreaInstance2area.get(areaInstance);
        if (area == null) {
            throw new IllegalArgumentException("No area instantiated for: " + areaInstance);
        }
        ExtensionsAreaImpl extensionsAreaImpl = area;
        if (extensionsAreaImpl == null) {
            Extensions.$$$reportNull$$$0(3);
        }
        return extensionsAreaImpl;
    }

    public static void cleanRootArea(@NotNull Disposable parentDisposable) {
        ExtensionsAreaImpl newArea;
        if (parentDisposable == null) {
            Extensions.$$$reportNull$$$0(4);
        }
        ExtensionsAreaImpl oldRootArea = (ExtensionsAreaImpl)Extensions.getRootArea();
        ourRootArea = newArea = Extensions.createRootArea();
        oldRootArea.notifyAreaReplaced(newArea);
        Disposer.register(parentDisposable, () -> {
            ourRootArea = oldRootArea;
            newArea.notifyAreaReplaced(oldRootArea);
        });
    }

    @NotNull
    public static Object[] getExtensions(@NonNls String extensionPointName) {
        Object[] objectArray = Extensions.getExtensions(extensionPointName, null);
        if (objectArray == null) {
            Extensions.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    @NotNull
    public static <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(6);
        }
        T[] TArray = Extensions.getExtensions(extensionPointName, null);
        if (TArray == null) {
            Extensions.$$$reportNull$$$0(7);
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName, @Nullable AreaInstance areaInstance) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(8);
        }
        T[] TArray = Extensions.getExtensions(extensionPointName.getName(), areaInstance);
        if (TArray == null) {
            Extensions.$$$reportNull$$$0(9);
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] getExtensions(String extensionPointName, @Nullable(value="null means root") AreaInstance areaInstance) {
        ExtensionsArea area = Extensions.getArea(areaInstance);
        ExtensionPoint extensionPoint = area.getExtensionPoint(extensionPointName);
        T[] TArray = extensionPoint.getExtensions();
        if (TArray == null) {
            Extensions.$$$reportNull$$$0(10);
        }
        return TArray;
    }

    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<U> extClass) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(11);
        }
        if (extClass == null) {
            Extensions.$$$reportNull$$$0(12);
        }
        for (T t : Extensions.getExtensions(extensionPointName)) {
            if (!extClass.isInstance(t)) continue;
            T t2 = t;
            if (t2 == null) {
                Extensions.$$$reportNull$$$0(13);
            }
            return (U)t2;
        }
        throw new IllegalArgumentException("could not find extension implementation " + extClass);
    }

    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, AreaInstance areaInstance, @NotNull Class<U> extClass) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(14);
        }
        if (extClass == null) {
            Extensions.$$$reportNull$$$0(15);
        }
        for (T t : Extensions.getExtensions(extensionPointName, areaInstance)) {
            if (!extClass.isInstance(t)) continue;
            T t2 = t;
            if (t2 == null) {
                Extensions.$$$reportNull$$$0(16);
            }
            return (U)t2;
        }
        throw new IllegalArgumentException("could not find extension implementation " + extClass);
    }

    public static void instantiateArea(@NonNls @NotNull String areaClass, @NotNull AreaInstance areaInstance, @Nullable(value="null means root") AreaInstance parentAreaInstance) {
        AreaClassConfiguration configuration;
        if (areaClass == null) {
            Extensions.$$$reportNull$$$0(17);
        }
        if (areaInstance == null) {
            Extensions.$$$reportNull$$$0(18);
        }
        if ((configuration = ourAreaClass2Configuration.get(areaClass)) == null) {
            throw new IllegalArgumentException("Area class is not registered: " + areaClass);
        }
        ExtensionsArea parentArea = Extensions.getArea(parentAreaInstance);
        if (!Extensions.equals(parentArea.getAreaClass(), configuration.getParentClassName())) {
            throw new IllegalArgumentException("Wrong parent area. Expected class: " + configuration.getParentClassName() + " actual class: " + parentArea.getAreaClass());
        }
        ExtensionsAreaImpl area = new ExtensionsAreaImpl(areaClass, areaInstance, (PicoContainer)parentArea.getPicoContainer(), ourLogger);
        if (ourAreaInstance2area.put(areaInstance, area) != null) {
            throw new IllegalArgumentException("Area already instantiated for: " + areaInstance);
        }
        for (AreaListener listener : Extensions.getAreaListeners()) {
            listener.areaCreated(areaClass, areaInstance);
        }
    }

    @NotNull
    private static AreaListener[] getAreaListeners() {
        AreaListener[] areaListenerArray = Extensions.getRootArea().getExtensionPoint(AREA_LISTENER_EXTENSION_POINT).getExtensions();
        if (areaListenerArray == null) {
            Extensions.$$$reportNull$$$0(19);
        }
        return areaListenerArray;
    }

    public static void registerAreaClass(@NonNls @NotNull String areaClass, @Nullable @NonNls String parentAreaClass) {
        if (areaClass == null) {
            Extensions.$$$reportNull$$$0(20);
        }
        if (ourAreaClass2Configuration.containsKey(areaClass)) {
            AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
            if (!Extensions.equals(configuration.getParentClassName(), parentAreaClass)) {
                throw new RuntimeException("Area class already registered: " + areaClass + ", " + configuration);
            }
            return;
        }
        AreaClassConfiguration configuration = new AreaClassConfiguration(areaClass, parentAreaClass);
        ourAreaClass2Configuration.put(areaClass, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeArea(@NotNull AreaInstance areaInstance) {
        if (areaInstance == null) {
            Extensions.$$$reportNull$$$0(21);
        }
        assert (ourAreaInstance2area.containsKey(areaInstance));
        String areaClass = ourAreaInstance2area.get(areaInstance).getAreaClass();
        if (areaClass == null) {
            throw new IllegalArgumentException("Area class is null (area never instantiated?). Instance: " + areaInstance);
        }
        try {
            for (AreaListener listener : Extensions.getAreaListeners()) {
                listener.areaDisposing(areaClass, areaInstance);
            }
        }
        finally {
            ourAreaInstance2area.remove(areaInstance);
        }
    }

    private static boolean equals(@Nullable Object object1, @Nullable Object object2) {
        return object1 == object2 || object1 != null && object1.equals(object2);
    }

    public static void setLogProvider(@NotNull LogProvider logProvider) {
        if (logProvider == null) {
            Extensions.$$$reportNull$$$0(22);
        }
        ourLogger = logProvider;
    }

    public static boolean isComponentSuitableForOs(@Nullable String os) {
        if (StringUtil.isEmpty(os)) {
            return true;
        }
        if (os.equals("mac")) {
            return SystemInfoRt.isMac;
        }
        if (os.equals("linux")) {
            return SystemInfoRt.isLinux;
        }
        if (os.equals("windows")) {
            return SystemInfoRt.isWindows;
        }
        if (os.equals("unix")) {
            return SystemInfoRt.isUnix;
        }
        if (os.equals("freebsd")) {
            return SystemInfoRt.isFreeBSD;
        }
        ourLogger.warn("Unknown OS " + os);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/Extensions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extClass";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "areaClass";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "areaInstance";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootArea";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootArea";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArea";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/Extensions";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtension";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAreaListeners";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cleanRootArea";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "instantiateArea";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerAreaClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "disposeArea";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setLogProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SimpleLogProvider
    implements LogProvider {
        @Override
        public void error(String message) {
            new Throwable(message).printStackTrace();
        }

        @Override
        public void error(String message, @NotNull Throwable t) {
            if (t == null) {
                SimpleLogProvider.$$$reportNull$$$0(0);
            }
            System.err.println(message);
            t.printStackTrace();
        }

        @Override
        public void error(@NotNull Throwable t) {
            if (t == null) {
                SimpleLogProvider.$$$reportNull$$$0(1);
            }
            t.printStackTrace();
        }

        @Override
        public void warn(String message) {
            System.err.println(message);
        }

        @Override
        public void warn(String message, @NotNull Throwable t) {
            if (t == null) {
                SimpleLogProvider.$$$reportNull$$$0(2);
            }
            System.err.println(message);
            t.printStackTrace();
        }

        @Override
        public void warn(@NotNull Throwable t) {
            if (t == null) {
                SimpleLogProvider.$$$reportNull$$$0(3);
            }
            t.printStackTrace();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "t";
            objectArray2[1] = "com/intellij/openapi/extensions/Extensions$SimpleLogProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AreaClassConfiguration {
        private final String myClassName;
        private final String myParentClassName;

        private AreaClassConfiguration(@NotNull String className, String parentClassName) {
            if (className == null) {
                AreaClassConfiguration.$$$reportNull$$$0(0);
            }
            this.myClassName = className;
            this.myParentClassName = parentClassName;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassName;
            if (string == null) {
                AreaClassConfiguration.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String getParentClassName() {
            return this.myParentClassName;
        }

        public String toString() {
            return "AreaClassConfiguration{myClassName='" + this.myClassName + '\'' + ", myParentClassName='" + this.myParentClassName + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/extensions/Extensions$AreaClassConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/extensions/Extensions$AreaClassConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

