/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Task
implements TaskInfo,
Progressive {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.progress.Task");
    protected final Project myProject;
    protected String myTitle;
    private final boolean myCanBeCancelled;
    private String myCancelText;
    private String myCancelTooltipText;

    public Task(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            Task.$$$reportNull$$$0(0);
        }
        this.myCancelText = CommonBundle.getCancelButtonText();
        this.myCancelTooltipText = CommonBundle.getCancelButtonText();
        this.myProject = project;
        this.myTitle = title;
        this.myCanBeCancelled = canBeCancelled;
    }

    public void onCancel() {
    }

    public void onSuccess() {
    }

    @Deprecated
    public void onError(@NotNull Exception error) {
        if (error == null) {
            Task.$$$reportNull$$$0(1);
        }
        LOG.error(error);
    }

    public void onThrowable(@NotNull Throwable error) {
        if (error == null) {
            Task.$$$reportNull$$$0(2);
        }
        if (error instanceof Exception) {
            this.onError((Exception)error);
        } else {
            LOG.error(error);
        }
    }

    public void onFinished() {
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final void queue() {
        ProgressManager.getInstance().run(this);
    }

    @Override
    @NotNull
    public final String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            Task.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public final Task setTitle(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String title) {
        if (title == null) {
            Task.$$$reportNull$$$0(4);
        }
        this.myTitle = title;
        Task task = this;
        if (task == null) {
            Task.$$$reportNull$$$0(5);
        }
        return task;
    }

    @Override
    public final String getCancelText() {
        return this.myCancelText;
    }

    @NotNull
    public final Task setCancelText(String cancelText) {
        this.myCancelText = cancelText;
        Task task = this;
        if (task == null) {
            Task.$$$reportNull$$$0(6);
        }
        return task;
    }

    @Nullable
    public NotificationInfo getNotificationInfo() {
        return null;
    }

    @Nullable
    public NotificationInfo notifyFinished() {
        return this.getNotificationInfo();
    }

    public boolean isHeadless() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    @NotNull
    public final Task setCancelTooltipText(String cancelTooltipText) {
        this.myCancelTooltipText = cancelTooltipText;
        Task task = this;
        if (task == null) {
            Task.$$$reportNull$$$0(7);
        }
        return task;
    }

    @Override
    public final String getCancelTooltipText() {
        return this.myCancelTooltipText;
    }

    @Override
    public final boolean isCancellable() {
        return this.myCanBeCancelled;
    }

    public abstract boolean isModal();

    @NotNull
    public final Modal asModal() {
        if (this.isModal()) {
            Modal modal = (Modal)this;
            if (modal == null) {
                Task.$$$reportNull$$$0(8);
            }
            return modal;
        }
        throw new IllegalStateException("Not a modal task");
    }

    @NotNull
    public final Backgroundable asBackgroundable() {
        if (!this.isModal()) {
            Backgroundable backgroundable = (Backgroundable)this;
            if (backgroundable == null) {
                Task.$$$reportNull$$$0(9);
            }
            return backgroundable;
        }
        throw new IllegalStateException("Not a backgroundable task");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/Task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/Task";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setCancelText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setCancelTooltipText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "asModal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "asBackgroundable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onError";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onThrowable";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class WithResult<T, E extends Exception>
    extends Modal {
        private final Ref<T> myResult;
        private final Ref<Throwable> myError;

        public WithResult(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                WithResult.$$$reportNull$$$0(0);
            }
            super(project, title, canBeCancelled);
            this.myResult = Ref.create();
            this.myError = Ref.create();
        }

        @Override
        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                WithResult.$$$reportNull$$$0(1);
            }
            try {
                this.myResult.set(this.compute(indicator));
            }
            catch (Throwable t) {
                this.myError.set(t);
            }
        }

        protected abstract T compute(@NotNull ProgressIndicator var1) throws E;

        public T getResult() throws E {
            Throwable t = this.myError.get();
            ExceptionUtil.rethrowUnchecked(t);
            if (t != null) {
                throw (Exception)t;
            }
            return this.myResult.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/progress/Task$WithResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NotificationInfo {
        private final String myNotificationName;
        private final String myNotificationTitle;
        private final String myNotificationText;
        private final boolean myShowWhenFocused;

        public NotificationInfo(@NotNull String notificationName, @NotNull String notificationTitle, @NotNull String notificationText) {
            if (notificationName == null) {
                NotificationInfo.$$$reportNull$$$0(0);
            }
            if (notificationTitle == null) {
                NotificationInfo.$$$reportNull$$$0(1);
            }
            if (notificationText == null) {
                NotificationInfo.$$$reportNull$$$0(2);
            }
            this(notificationName, notificationTitle, notificationText, false);
        }

        public NotificationInfo(@NotNull String notificationName, @NotNull String notificationTitle, @NotNull String notificationText, boolean showWhenFocused) {
            if (notificationName == null) {
                NotificationInfo.$$$reportNull$$$0(3);
            }
            if (notificationTitle == null) {
                NotificationInfo.$$$reportNull$$$0(4);
            }
            if (notificationText == null) {
                NotificationInfo.$$$reportNull$$$0(5);
            }
            this.myNotificationName = notificationName;
            this.myNotificationTitle = notificationTitle;
            this.myNotificationText = notificationText;
            this.myShowWhenFocused = showWhenFocused;
        }

        @NotNull
        public String getNotificationName() {
            String string = this.myNotificationName;
            if (string == null) {
                NotificationInfo.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getNotificationTitle() {
            String string = this.myNotificationTitle;
            if (string == null) {
                NotificationInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public String getNotificationText() {
            String string = this.myNotificationText;
            if (string == null) {
                NotificationInfo.$$$reportNull$$$0(8);
            }
            return string;
        }

        public boolean isShowWhenFocused() {
            return this.myShowWhenFocused;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notificationName";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notificationTitle";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notificationText";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/progress/Task$NotificationInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/progress/Task$NotificationInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationTitle";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class ConditionalModal
    extends Backgroundable {
        public ConditionalModal(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled, @NotNull PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                ConditionalModal.$$$reportNull$$$0(0);
            }
            if (backgroundOption == null) {
                ConditionalModal.$$$reportNull$$$0(1);
            }
            super(project, title, canBeCancelled, backgroundOption);
        }

        @Override
        public final boolean isConditionalModal() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "backgroundOption";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/progress/Task$ConditionalModal";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Modal
    extends Task {
        public Modal(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                Modal.$$$reportNull$$$0(0);
            }
            super(project, title, canBeCancelled);
        }

        @Override
        public final boolean isModal() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task$Modal", "<init>"));
        }
    }

    public static abstract class Backgroundable
    extends Task
    implements PerformInBackgroundOption {
        protected final PerformInBackgroundOption myBackgroundOption;

        public Backgroundable(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title) {
            if (title == null) {
                Backgroundable.$$$reportNull$$$0(0);
            }
            this(project, title, true);
        }

        public Backgroundable(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                Backgroundable.$$$reportNull$$$0(1);
            }
            this(project, title, canBeCancelled, null);
        }

        public Backgroundable(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                Backgroundable.$$$reportNull$$$0(2);
            }
            super(project, title, canBeCancelled);
            this.myBackgroundOption = backgroundOption;
            if (StringUtil.isEmptyOrSpaces(title)) {
                LOG.warn("Empty title for backgroundable task.", new Throwable());
            }
        }

        @Override
        public boolean shouldStartInBackground() {
            return this.myBackgroundOption == null || this.myBackgroundOption.shouldStartInBackground();
        }

        @Override
        public void processSentToBackground() {
            if (this.myBackgroundOption != null) {
                this.myBackgroundOption.processSentToBackground();
            }
        }

        @Override
        public final boolean isModal() {
            return false;
        }

        public boolean isConditionalModal() {
            return false;
        }

        @Deprecated
        public DumbModeAction getDumbModeAction() {
            return DumbModeAction.NOTHING;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/Task$Backgroundable", "<init>"));
        }
    }
}

