/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNullMethodArgumentIndex
extends ScalarIndexExtension<MethodCallData>
implements PsiDependentIndex {
    private static final Logger LOG = Logger.getInstance(JavaNullMethodArgumentIndex.class);
    public static final ID<MethodCallData, Void> INDEX_ID = ID.create("java.null.method.argument");
    private static final TokenSet CALL_TYPES = TokenSet.create(JavaElementType.METHOD_CALL_EXPRESSION, JavaElementType.NEW_EXPRESSION, JavaElementType.ANONYMOUS_CLASS);
    private final boolean myOfflineMode = ApplicationManager.getApplication().isCommandLine() && !ApplicationManager.getApplication().isUnitTestMode();

    @Override
    @NotNull
    public ID<MethodCallData, Void> getName() {
        ID<MethodCallData, Void> iD = INDEX_ID;
        if (iD == null) {
            JavaNullMethodArgumentIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<MethodCallData, Void, FileContent> getIndexer() {
        DataIndexer<MethodCallData, Void, FileContent> dataIndexer = inputData -> {
            if (this.myOfflineMode) {
                return Collections.emptyMap();
            }
            int[] nullOffsets = new StringSearcher("null", true, true).findAllOccurrences(inputData.getContentAsText());
            if (nullOffsets.length == 0) {
                return Collections.emptyMap();
            }
            LighterAST lighterAst = ((FileContentImpl)inputData).getLighterASTForPsiDependentIndex();
            Set<LighterASTNode> calls = JavaNullMethodArgumentIndex.findCallsWithNulls(lighterAst, nullOffsets);
            if (calls.isEmpty()) {
                return Collections.emptyMap();
            }
            THashMap result2 = new THashMap();
            for (LighterASTNode element : calls) {
                String name;
                IntArrayList indices = JavaNullMethodArgumentIndex.getNullParameterIndices(lighterAst, element);
                if (indices == null || (name = JavaNullMethodArgumentIndex.getMethodName(lighterAst, element, element.getTokenType())) == null) continue;
                for (int i = 0; i < indices.size(); ++i) {
                    result2.put(new MethodCallData(name, indices.get(i)), null);
                }
            }
            return result2;
        };
        if (dataIndexer == null) {
            JavaNullMethodArgumentIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    private static Set<LighterASTNode> findCallsWithNulls(LighterAST lighterAst, int[] nullOffsets) {
        HashSet<LighterASTNode> calls = new HashSet<LighterASTNode>();
        for (int offset : nullOffsets) {
            LighterASTNode exprList;
            LighterASTNode literal;
            LighterASTNode leaf = LightTreeUtil.findLeafElementAt(lighterAst, offset);
            LighterASTNode lighterASTNode = literal = leaf == null ? null : lighterAst.getParent(leaf);
            if (!JavaNullMethodArgumentIndex.isNullLiteral(lighterAst, literal) || (exprList = lighterAst.getParent(literal)) == null || exprList.getTokenType() != JavaElementType.EXPRESSION_LIST) continue;
            ContainerUtil.addIfNotNull(calls, LightTreeUtil.getParentOfType(lighterAst, exprList, CALL_TYPES, ElementType.MEMBER_BIT_SET));
        }
        HashSet<LighterASTNode> hashSet = calls;
        if (hashSet == null) {
            JavaNullMethodArgumentIndex.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @Nullable
    private static IntArrayList getNullParameterIndices(LighterAST lighterAst, @NotNull LighterASTNode methodCall) {
        LighterASTNode node;
        if (methodCall == null) {
            JavaNullMethodArgumentIndex.$$$reportNull$$$0(3);
        }
        if ((node = LightTreeUtil.firstChildOfType(lighterAst, methodCall, JavaElementType.EXPRESSION_LIST)) == null) {
            return null;
        }
        List<LighterASTNode> parameters = JavaLightTreeUtil.getExpressionChildren(lighterAst, node);
        IntArrayList indices = new IntArrayList(1);
        for (int idx = 0; idx < parameters.size(); ++idx) {
            if (!JavaNullMethodArgumentIndex.isNullLiteral(lighterAst, parameters.get(idx))) continue;
            indices.add(idx);
        }
        return indices;
    }

    private static boolean isNullLiteral(LighterAST lighterAst, @Nullable LighterASTNode expr) {
        return expr != null && expr.getTokenType() == JavaElementType.LITERAL_EXPRESSION && lighterAst.getChildren(expr).get(0).getTokenType() == JavaTokenType.NULL_KEYWORD;
    }

    @Nullable
    private static String getMethodName(LighterAST lighterAst, @NotNull LighterASTNode call, IElementType elementType) {
        if (call == null) {
            JavaNullMethodArgumentIndex.$$$reportNull$$$0(4);
        }
        if (elementType == JavaElementType.NEW_EXPRESSION || elementType == JavaElementType.ANONYMOUS_CLASS) {
            List<LighterASTNode> refs = LightTreeUtil.getChildrenOfType(lighterAst, call, JavaElementType.JAVA_CODE_REFERENCE);
            if (refs.isEmpty()) {
                return null;
            }
            LighterASTNode lastRef = refs.get(refs.size() - 1);
            return JavaLightTreeUtil.getNameIdentifierText(lighterAst, lastRef);
        }
        LOG.assertTrue(elementType == JavaElementType.METHOD_CALL_EXPRESSION);
        LighterASTNode methodReference = lighterAst.getChildren(call).get(0);
        if (methodReference.getTokenType() == JavaElementType.REFERENCE_EXPRESSION) {
            return JavaLightTreeUtil.getNameIdentifierText(lighterAst, methodReference);
        }
        return null;
    }

    @Override
    @NotNull
    public KeyDescriptor<MethodCallData> getKeyDescriptor() {
        KeyDescriptor<MethodCallData> keyDescriptor = new KeyDescriptor<MethodCallData>(){

            @Override
            public int getHashCode(MethodCallData value) {
                return value.hashCode();
            }

            @Override
            public boolean isEqual(MethodCallData val1, MethodCallData val2) {
                return val1.equals(val2);
            }

            @Override
            public void save(@NotNull DataOutput out, MethodCallData value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                EnumeratorStringDescriptor.INSTANCE.save(out, value.getMethodName());
                DataInputOutputUtil.writeINT(out, value.getNullParameterIndex());
            }

            @Override
            public MethodCallData read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new MethodCallData(EnumeratorStringDescriptor.INSTANCE.read(in), DataInputOutputUtil.readINT(in));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (keyDescriptor == null) {
            JavaNullMethodArgumentIndex.$$$reportNull$$$0(5);
        }
        return keyDescriptor;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            @Override
            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return JavaStubElementTypes.JAVA_FILE.shouldBuildStubFor(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$2", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            JavaNullMethodArgumentIndex.$$$reportNull$$$0(6);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findCallsWithNulls";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNullParameterIndices";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMethodName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MethodCallData {
        @NotNull
        private final String myMethodName;
        private final int myNullParameterIndex;

        public MethodCallData(@NotNull String name, int index) {
            if (name == null) {
                MethodCallData.$$$reportNull$$$0(0);
            }
            this.myMethodName = name;
            this.myNullParameterIndex = index;
        }

        @NotNull
        public String getMethodName() {
            String string = this.myMethodName;
            if (string == null) {
                MethodCallData.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getNullParameterIndex() {
            return this.myNullParameterIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodCallData data = (MethodCallData)o;
            if (this.myNullParameterIndex != data.myNullParameterIndex) {
                return false;
            }
            return this.myMethodName.equals(data.myMethodName);
        }

        public int hashCode() {
            int result2 = this.myMethodName.hashCode();
            result2 = 31 * result2 + this.myNullParameterIndex;
            return result2;
        }

        public String toString() {
            return "MethodCallData{myMethodName='" + this.myMethodName + '\'' + ", myNullParameterIndex=" + this.myNullParameterIndex + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$MethodCallData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$MethodCallData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

