/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.mac.foundation.MacUtil");
    public static final String MAC_NATIVE_WINDOW_SHOWING = "MAC_NATIVE_WINDOW_SHOWING";

    private MacUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ID findWindowForTitle(@Nullable String title) {
        ID focusedWindow;
        block5: {
            if (title == null || title.isEmpty()) {
                return null;
            }
            ID pool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
            focusedWindow = null;
            try {
                String titleString;
                ID window;
                ID windowTitle;
                ID sharedApplication = Foundation.invoke("NSApplication", "sharedApplication", new Object[0]);
                ID windows = Foundation.invoke(sharedApplication, "windows", new Object[0]);
                ID windowEnumerator = Foundation.invoke(windows, "objectEnumerator", new Object[0]);
                do {
                    if (0 != (window = Foundation.invoke(windowEnumerator, "nextObject", new Object[0])).intValue()) continue;
                    break block5;
                } while ((windowTitle = Foundation.invoke(window, "title", new Object[0])) == null || windowTitle.intValue() == 0 || !Comparing.equal(titleString = Foundation.toStringViaUTF8(windowTitle), title));
                focusedWindow = window;
            }
            finally {
                Foundation.invoke(pool, "release", new Object[0]);
            }
        }
        return focusedWindow;
    }

    public static synchronized void startModal(JComponent component, String key) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = component.getToolkit().getSystemEventQueue();
                while (component.getClientProperty(key) == Boolean.TRUE) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object source = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (source instanceof Component) {
                        ((Component)source).dispatchEvent(event);
                        continue;
                    }
                    if (source instanceof MenuComponent) {
                        ((MenuComponent)source).dispatchEvent(event);
                        continue;
                    }
                    LOG.debug("Unable to dispatch: " + event);
                }
            } else {
                assert (false) : "Should be called from Event-Dispatch Thread only!";
                while (component.getClientProperty(key) == Boolean.TRUE) {
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static synchronized void startModal(JComponent component) {
        MacUtil.startModal(component, MAC_NATIVE_WINDOW_SHOWING);
    }

    public static boolean isFullKeyboardAccessEnabled() {
        if (!SystemInfo.isMacOSSnowLeopard) {
            return false;
        }
        final AtomicBoolean result2 = new AtomicBoolean();
        Foundation.executeOnMainThread(true, true, new Runnable(){

            @Override
            public void run() {
                result2.set(Foundation.invoke(Foundation.invoke("NSApplication", "sharedApplication", new Object[0]), "isFullKeyboardAccessEnabled", new Object[0]).intValue() == 1);
            }
        });
        return result2.get();
    }

    public static void adjustFocusTraversal(@NotNull Disposable disposable) {
        if (disposable == null) {
            MacUtil.$$$reportNull$$$0(0);
        }
        if (!SystemInfo.isMacOSSnowLeopard) {
            return;
        }
        final AWTEventListener listener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof KeyEvent && ((KeyEvent)event).getKeyCode() == 9 && !(event.getSource() instanceof JTextComponent) && !(event.getSource() instanceof JList) && !MacUtil.isFullKeyboardAccessEnabled()) {
                    ((KeyEvent)event).consume();
                }
            }
        };
        Disposer.register(disposable, new Disposable(){

            @Override
            public void dispose() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 8L);
    }

    public static ID findWindowFromJavaWindow(Window w) {
        ID windowId = null;
        if (Registry.is("skip.untitled.windows.for.mac.messages")) {
            try {
                Class<?> cWindowPeerClass = w.getPeer().getClass();
                Method getPlatformWindowMethod = cWindowPeerClass.getDeclaredMethod("getPlatformWindow", new Class[0]);
                Object cPlatformWindow = getPlatformWindowMethod.invoke((Object)w.getPeer(), new Object[0]);
                Class<?> cPlatformWindowClass = cPlatformWindow.getClass();
                Method getNSWindowPtrMethod = cPlatformWindowClass.getDeclaredMethod("getNSWindowPtr", new Class[0]);
                windowId = new ID((Long)getNSWindowPtrMethod.invoke(cPlatformWindow, new Object[0]));
            }
            catch (NoSuchMethodException e) {
                LOG.debug(e);
            }
            catch (InvocationTargetException e) {
                LOG.debug(e);
            }
            catch (IllegalAccessException e) {
                LOG.debug(e);
            }
        } else {
            String foremostWindowTitle = MacUtil.getWindowTitle(w);
            windowId = MacUtil.findWindowForTitle(foremostWindowTitle);
        }
        return windowId;
    }

    @Nullable
    public static String getWindowTitle(Window documentRoot) {
        String windowTitle = null;
        if (documentRoot instanceof Frame) {
            windowTitle = ((Frame)documentRoot).getTitle();
        } else if (documentRoot instanceof Dialog) {
            windowTitle = ((Dialog)documentRoot).getTitle();
        }
        return windowTitle;
    }

    public static Object wakeUpNeo(String reason) {
        if (SystemInfo.isMacOSMavericks && Registry.is("idea.mac.prevent.app.nap")) {
            ID processInfo = Foundation.invoke("NSProcessInfo", "processInfo", new Object[0]);
            ID activity = Foundation.invoke(processInfo, "beginActivityWithOptions:reason:", new Object[]{0xFF00EFFFFFL, Foundation.nsString(reason)});
            Foundation.cfRetain(activity);
            return activity;
        }
        return null;
    }

    public static void matrixHasYou(Object activity) {
        if (activity != null) {
            ID processInfo = Foundation.invoke("NSProcessInfo", "processInfo", new Object[0]);
            Foundation.invoke(processInfo, "endActivity:", activity);
            Foundation.cfRelease((ID)((Object)activity));
        }
    }

    @NotNull
    public static Color colorFromNative(ID color) {
        ID colorSpace = Foundation.invoke("NSColorSpace", "genericRGBColorSpace", new Object[0]);
        ID colorInSpace = Foundation.invoke(color, "colorUsingColorSpace:", new Object[]{colorSpace});
        long red = Foundation.invoke(colorInSpace, "redComponent", new Object[0]).longValue();
        long green = Foundation.invoke(colorInSpace, "greenComponent", new Object[0]).longValue();
        long blue = Foundation.invoke(colorInSpace, "blueComponent", new Object[0]).longValue();
        long alpha = Foundation.invoke(colorInSpace, "alphaComponent", new Object[0]).longValue();
        double realAlpha = alpha != 0L && (int)(alpha >> 52 & 0x7FFL) == 0 ? 1.0 : Double.longBitsToDouble(alpha);
        Color color2 = new Color((float)Double.longBitsToDouble(red), (float)Double.longBitsToDouble(green), (float)Double.longBitsToDouble(blue), (float)realAlpha);
        if (color2 == null) {
            MacUtil.$$$reportNull$$$0(1);
        }
        return color2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/foundation/MacUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/foundation/MacUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "colorFromNative";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustFocusTraversal";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

