/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.RefValueHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class IntKeyWeakValueHashMap<V>
implements IntObjectMap<V> {
    private final TIntObjectHashMap<MyReference<V>> myMap = new TIntObjectHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();
    private static final Object GCED = new Object();

    IntKeyWeakValueHashMap() {
    }

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            int key = ref.key;
            this.myMap.remove(key);
        }
        return;
    }

    @Override
    public final V get(int key) {
        MyReference ref = (MyReference)this.myMap.get(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public final V put(int key, @NotNull V value) {
        if (value == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(0);
        }
        this.processQueue();
        MyReference ref = new MyReference(key, value, this.myQueue);
        ref.name = value.toString();
        MyReference oldRef = (MyReference)this.myMap.put(key, ref);
        return (V)SoftReference.dereference(oldRef);
    }

    @Override
    public final V remove(int key) {
        this.processQueue();
        MyReference ref = (MyReference)this.myMap.remove(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public final void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public final int size() {
        return this.myMap.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public final boolean containsKey(int key) {
        throw RefValueHashMap.pointlessContainsKey();
    }

    @Override
    @NotNull
    public final Collection<V> values() {
        Object[] refs;
        ArrayList result2 = new ArrayList();
        for (Object o : refs = this.myMap.getValues()) {
            Object value = ((MyReference)o).get();
            if (value == null) continue;
            result2.add(value);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public int[] keys() {
        throw new IncorrectOperationException("keys() makes no sense for weak/soft map because GC can clear the value any moment now");
    }

    @Override
    public boolean containsValue(@NotNull V value) {
        if (value == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(2);
        }
        return this.values().contains(value);
    }

    @Override
    @NotNull
    public Iterable<IntObjectMap.Entry<V>> entries() {
        Iterable iterable = new Iterable<IntObjectMap.Entry<V>>(){

            @Override
            @NotNull
            public Iterator<IntObjectMap.Entry<V>> iterator() {
                final TIntObjectIterator tIterator = IntKeyWeakValueHashMap.this.myMap.iterator();
                Iterator iterator = ContainerUtil.filterIterator(new Iterator<IntObjectMap.Entry<V>>(){

                    @Override
                    public boolean hasNext() {
                        return tIterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public IntObjectMap.Entry<V> next() {
                        tIterator.advance();
                        return new IntObjectMap.Entry<V>(){

                            @Override
                            public int getKey() {
                                return tIterator.key();
                            }

                            @Override
                            @NotNull
                            public V getValue() {
                                Object v = SoftReference.dereference((Reference)tIterator.value());
                                Object object = ObjectUtils.notNull(v, GCED);
                                if (object == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return object;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/IntKeyWeakValueHashMap$1$1$1", "getValue"));
                            }
                        };
                    }
                }, new Condition<IntObjectMap.Entry<V>>(){

                    @Override
                    public boolean value(IntObjectMap.Entry<V> o) {
                        return o.getValue() != GCED;
                    }
                });
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/IntKeyWeakValueHashMap$1", "iterator"));
            }
        };
        if (iterable == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/IntKeyWeakValueHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/IntKeyWeakValueHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "entries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReference<T>
    extends WeakReference<T> {
        private final int key;
        String name;

        private MyReference(int key, @NotNull T referent, ReferenceQueue<? super T> q) {
            if (referent == null) {
                MyReference.$$$reportNull$$$0(0);
            }
            super(referent, q);
            this.key = key;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/containers/IntKeyWeakValueHashMap$MyReference", "<init>"));
        }
    }
}

