/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLocalVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreImmediatelyReturnedVariables;
    @Deprecated
    public boolean m_ignoreAnnotatedVariables;
    public boolean m_ignoreAnnotatedVariablesNew = true;

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            UnnecessaryLocalVariableInspectionBase.$$$reportNull$$$0(0);
        }
        this.defaultWriteSettings(node, "m_ignoreAnnotatedVariablesNew");
        this.writeBooleanOption(node, "m_ignoreAnnotatedVariablesNew", true);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.local.variable.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryLocalVariableInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("redundant.local.variable.ignore.option", new Object[0]), "m_ignoreImmediatelyReturnedVariables");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("redundant.local.variable.annotation.option", new Object[0]), "m_ignoreAnnotatedVariablesNew");
        return optionsPanel;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.local.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryLocalVariableInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLocalVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UnnecessaryLocalVariableVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLocalVariableVisitor() {
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            PsiAnnotation annotation;
            int length;
            PsiModifierList list;
            if (variable == null) {
                UnnecessaryLocalVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitLocalVariable(variable);
            if (UnnecessaryLocalVariableInspectionBase.this.m_ignoreAnnotatedVariablesNew && (list = variable.getModifierList()) != null && (length = list.getAnnotations().length) > 0 && ((annotation = list.findAnnotation(SuppressWarnings.class.getName())) == null || !JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(list).contains(UnnecessaryLocalVariableInspectionBase.this.getSuppressId()))) {
                return;
            }
            if (this.isCopyVariable(variable)) {
                this.registerVariableError(variable, new Object[0]);
            } else if (!UnnecessaryLocalVariableInspectionBase.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyReturned(variable)) {
                this.registerVariableError(variable, new Object[0]);
            } else if (!UnnecessaryLocalVariableInspectionBase.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyThrown(variable)) {
                this.registerVariableError(variable, new Object[0]);
            } else if (this.isImmediatelyAssigned(variable)) {
                this.registerVariableError(variable, new Object[0]);
            } else if (this.isImmediatelyAssignedAsDeclaration(variable)) {
                this.registerVariableError(variable, new Object[0]);
            }
        }

        private boolean isCopyVariable(PsiVariable variable) {
            PsiExpression operand;
            PsiExpression initializer = ParenthesesUtils.stripParentheses(variable.getInitializer());
            if (initializer instanceof PsiTypeCastExpression && (operand = ((PsiTypeCastExpression)initializer).getOperand()) instanceof PsiReferenceExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)initializer)) {
                initializer = operand;
            }
            if (!(initializer instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)initializer;
            PsiVariable initialization = ObjectUtils.tryCast(reference.resolve(), PsiVariable.class);
            if (initialization == null) {
                return false;
            }
            if (!(initialization instanceof PsiResourceVariable) && variable instanceof PsiResourceVariable) {
                return false;
            }
            if (!(initialization instanceof PsiLocalVariable || initialization instanceof PsiParameter || this.isFinalChain(reference) && ReferencesSearch.search(variable).findAll().size() == 1)) {
                return false;
            }
            PsiCodeBlock containingScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (containingScope == null) {
                return false;
            }
            if (this.variableMayChange(containingScope, null, variable)) {
                return false;
            }
            if (this.variableMayChange(containingScope, PsiUtil.skipParenthesizedExprDown(reference.getQualifierExpression()), initialization)) {
                return false;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(containingScope.getProject()).getResolveHelper();
            String initializationName = initialization.getName();
            if (initializationName == null) {
                return false;
            }
            boolean finalVariableIntroduction = !initialization.hasModifierProperty("final") && variable.hasModifierProperty("final") || PsiUtil.isLanguageLevel8OrHigher(initialization) && !HighlightControlFlowUtil.isEffectivelyFinal(initialization, containingScope, null) && HighlightControlFlowUtil.isEffectivelyFinal(variable, containingScope, null);
            PsiType variableType = variable.getType();
            PsiType initializationType = initialization.getType();
            boolean sameType = Comparing.equal(variableType, initializationType);
            for (PsiReference ref : ReferencesSearch.search(variable, new LocalSearchScope(containingScope))) {
                PsiElement resolve;
                PsiElement parent;
                Object element;
                PsiElement refElement = ref.getElement();
                if (finalVariableIntroduction && (element = PsiTreeUtil.getParentOfType(refElement, PsiClass.class, PsiLambdaExpression.class)) != null && PsiTreeUtil.isAncestor(containingScope, element, true)) {
                    return false;
                }
                if (resolveHelper.resolveReferencedVariable(initializationName, refElement) != initialization) {
                    return false;
                }
                if (sameType || !((parent = refElement.getParent()) instanceof PsiReferenceExpression) || !((resolve = ((PsiReferenceExpression)parent).resolve()) instanceof PsiMember) || !((PsiMember)resolve).hasModifierProperty("private")) continue;
                return false;
            }
            return !TypeConversionUtil.boxingConversionApplicable(variableType, initializationType);
        }

        private boolean isFinalChain(PsiReferenceExpression reference) {
            PsiElement element;
            while ((element = reference.resolve()) instanceof PsiField) {
                if (!((PsiField)element).hasModifierProperty("final")) {
                    return false;
                }
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown(reference.getQualifierExpression());
                if (qualifier == null || qualifier instanceof PsiThisExpression) {
                    return true;
                }
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                reference = (PsiReferenceExpression)qualifier;
            }
            return true;
        }

        private boolean variableMayChange(PsiCodeBlock containingScope, PsiExpression qualifier, PsiVariable variable) {
            while (variable != null) {
                if (!variable.hasModifierProperty("final") && VariableAccessUtils.variableIsAssigned(variable, containingScope, false)) {
                    return true;
                }
                if (!(qualifier instanceof PsiReferenceExpression)) break;
                PsiReferenceExpression qualifierReference = (PsiReferenceExpression)qualifier;
                qualifier = PsiUtil.skipParenthesizedExprDown(qualifierReference.getQualifierExpression());
                variable = ObjectUtils.tryCast(qualifierReference.resolve(), PsiVariable.class);
            }
            return false;
        }

        private boolean isImmediatelyReturned(PsiVariable variable) {
            PsiCodeBlock containingScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, true, PsiClass.class);
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = PsiTreeUtil.getNextSiblingOfType(declarationStatement, PsiStatement.class);
            if (!(nextStatement instanceof PsiReturnStatement)) {
                return false;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)nextStatement;
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)returnValue;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            return !this.isVariableUsedInFollowingDeclarations(variable, declarationStatement);
        }

        private boolean isImmediatelyThrown(PsiVariable variable) {
            PsiCodeBlock containingScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, true, PsiClass.class);
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = PsiTreeUtil.getNextSiblingOfType(declarationStatement, PsiStatement.class);
            if (!(nextStatement instanceof PsiThrowStatement)) {
                return false;
            }
            PsiThrowStatement throwStatement = (PsiThrowStatement)nextStatement;
            PsiExpression returnValue = ParenthesesUtils.stripParentheses(throwStatement.getException());
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)((Object)returnValue)).resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            return !this.isVariableUsedInFollowingDeclarations(variable, declarationStatement);
        }

        private boolean isImmediatelyAssigned(PsiVariable variable) {
            PsiCodeBlock containingScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, true, PsiClass.class);
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = PsiTreeUtil.getNextSiblingOfType(declarationStatement, PsiStatement.class);
            if (!(nextStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)nextStatement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (tokenType != JavaTokenType.EQ) {
                return false;
            }
            PsiExpression rhs = ParenthesesUtils.stripParentheses(assignmentExpression.getRExpression());
            if (!(rhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)rhs;
            PsiElement referent = reference.resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (lhs instanceof PsiArrayAccessExpression) {
                return false;
            }
            if (this.isVariableUsedInFollowingDeclarations(variable, declarationStatement)) {
                return false;
            }
            nextStatement = PsiTreeUtil.getNextSiblingOfType(nextStatement, PsiStatement.class);
            while (nextStatement != null) {
                if (VariableAccessUtils.variableIsUsed(variable, nextStatement)) {
                    return false;
                }
                nextStatement = PsiTreeUtil.getNextSiblingOfType(nextStatement, PsiStatement.class);
            }
            return true;
        }

        private boolean isImmediatelyAssignedAsDeclaration(PsiVariable variable) {
            PsiCodeBlock containingScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, true, PsiClass.class);
            if (containingScope == null) {
                return false;
            }
            PsiElement parent = variable.getParent();
            if (!(parent instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)parent;
            PsiStatement nextStatement = PsiTreeUtil.getNextSiblingOfType(declarationStatement, PsiStatement.class);
            if (nextStatement instanceof PsiDeclarationStatement) {
                boolean referenceFound = false;
                PsiDeclarationStatement nextDeclarationStatement = (PsiDeclarationStatement)nextStatement;
                for (PsiElement declaration : nextDeclarationStatement.getDeclaredElements()) {
                    PsiReferenceExpression referenceExpression;
                    PsiElement referent;
                    if (!(declaration instanceof PsiVariable)) continue;
                    PsiVariable nextVariable = (PsiVariable)declaration;
                    PsiExpression initializer = ParenthesesUtils.stripParentheses(nextVariable.getInitializer());
                    if (!referenceFound && initializer instanceof PsiReferenceExpression && variable.equals(referent = (referenceExpression = (PsiReferenceExpression)initializer).resolve())) {
                        referenceFound = true;
                        continue;
                    }
                    if (!VariableAccessUtils.variableIsUsed(variable, initializer)) continue;
                    return false;
                }
                if (!referenceFound) {
                    return false;
                }
            } else if (nextStatement instanceof PsiTryStatement) {
                PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
                PsiResourceList resourceList = tryStatement.getResourceList();
                if (resourceList == null) {
                    return false;
                }
                boolean referenceFound = false;
                for (PsiResourceListElement resource : resourceList) {
                    PsiReferenceExpression referenceExpression;
                    PsiElement referent;
                    if (!(resource instanceof PsiResourceVariable)) continue;
                    PsiExpression initializer = ((PsiResourceVariable)resource).getInitializer();
                    if (!referenceFound && initializer instanceof PsiReferenceExpression && variable.equals(referent = (referenceExpression = (PsiReferenceExpression)initializer).resolve())) {
                        referenceFound = true;
                        continue;
                    }
                    if (!VariableAccessUtils.variableIsUsed(variable, initializer)) continue;
                    return false;
                }
                if (!referenceFound) {
                    return false;
                }
                if (VariableAccessUtils.variableIsUsed(variable, tryStatement.getTryBlock()) || VariableAccessUtils.variableIsUsed(variable, tryStatement.getFinallyBlock())) {
                    return false;
                }
                for (PsiCatchSection section : tryStatement.getCatchSections()) {
                    if (!VariableAccessUtils.variableIsUsed(variable, section)) continue;
                    return false;
                }
            } else {
                return false;
            }
            if (this.isVariableUsedInFollowingDeclarations(variable, declarationStatement)) {
                return false;
            }
            nextStatement = PsiTreeUtil.getNextSiblingOfType(nextStatement, PsiStatement.class);
            while (nextStatement != null) {
                if (VariableAccessUtils.variableIsUsed(variable, nextStatement)) {
                    return false;
                }
                nextStatement = PsiTreeUtil.getNextSiblingOfType(nextStatement, PsiStatement.class);
            }
            return true;
        }

        private boolean isVariableUsedInFollowingDeclarations(PsiVariable variable, PsiDeclarationStatement declarationStatement) {
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length == 1) {
                return false;
            }
            boolean check = false;
            for (PsiElement declaredElement : declaredElements) {
                if (!check && variable.equals(declaredElement)) {
                    check = true;
                    continue;
                }
                if (!VariableAccessUtils.variableIsUsed(variable, declaredElement)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspectionBase$UnnecessaryLocalVariableVisitor", "visitLocalVariable"));
        }
    }
}

