/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddThisQualifierFix
extends InspectionGadgetsFix {
    private AddThisQualifierFix() {
    }

    @Nullable
    public static AddThisQualifierFix buildFix(PsiExpression expressionToQualify, PsiMember memberAccessed) {
        if (!AddThisQualifierFix.isThisQualifierPossible(expressionToQualify, memberAccessed)) {
            return null;
        }
        return new AddThisQualifierFix();
    }

    private static boolean isThisQualifierPossible(PsiExpression memberAccessExpression, @NotNull PsiMember member) {
        PsiClass memberClass;
        if (member == null) {
            AddThisQualifierFix.$$$reportNull$$$0(0);
        }
        if ((memberClass = member.getContainingClass()) == null) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass(memberAccessExpression);
        if (InheritanceUtil.isInheritorOrSelf(containingClass, memberClass, true)) {
            return true;
        }
        while ((containingClass = ClassUtils.getContainingClass(containingClass)) != null && !InheritanceUtil.isInheritorOrSelf(containingClass, memberClass, true)) {
        }
        return containingClass != null && !PsiUtil.isLocalOrAnonymousClass(containingClass);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("add.this.qualifier.quickfix", new Object[0]);
        if (string == null) {
            AddThisQualifierFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiReferenceExpression expression = (PsiReferenceExpression)descriptor.getPsiElement();
        if (expression.getQualifierExpression() != null) {
            return;
        }
        PsiExpression thisQualifier = ExpressionUtils.getQualifierOrThis(expression);
        CommentTracker commentTracker = new CommentTracker();
        String newExpression = commentTracker.text(thisQualifier) + "." + commentTracker.text(expression);
        PsiReplacementUtil.replaceExpressionAndShorten(expression, newExpression, commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/AddThisQualifierFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/AddThisQualifierFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isThisQualifierPossible";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

