/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ExtendsConcreteCollectionInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("ClassExtendsConcreteCollection" == null) {
            ExtendsConcreteCollectionInspectionBase.$$$reportNull$$$0(0);
        }
        return "ClassExtendsConcreteCollection";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("extends.concrete.collection.display.name", new Object[0]);
        if (string == null) {
            ExtendsConcreteCollectionInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        PsiClass aClass = (PsiClass)infos[1];
        if (aClass instanceof PsiAnonymousClass) {
            String string = InspectionGadgetsBundle.message("anonymous.extends.concrete.collection.problem.descriptor", superClass.getQualifiedName());
            if (string == null) {
                ExtendsConcreteCollectionInspectionBase.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("extends.concrete.collection.problem.descriptor", superClass.getQualifiedName());
        if (string == null) {
            ExtendsConcreteCollectionInspectionBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsConcreteCollectionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ExtendsConcreteCollectionVisitor
    extends BaseInspectionVisitor {
        private ExtendsConcreteCollectionVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ExtendsConcreteCollectionVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (!CollectionUtils.isConcreteCollectionClass(superClass)) {
                return;
            }
            String qualifiedName = superClass.getQualifiedName();
            if ("java.util.LinkedHashMap".equals(qualifiedName)) {
                PsiMethod[] methods = aClass.findMethodsByName("removeEldestEntry", false);
                PsiClassType entryType = TypeUtils.getType("java.util.Map.Entry", aClass);
                for (PsiMethod method : methods) {
                    PsiParameter parameter;
                    PsiParameterList parameterList;
                    if (!PsiType.BOOLEAN.equals(method.getReturnType()) || (parameterList = method.getParameterList()).getParametersCount() != 1 || !entryType.isAssignableFrom((parameter = parameterList.getParameters()[0]).getType())) continue;
                    return;
                }
            }
            this.registerClassError(aClass, superClass, aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/inheritance/ExtendsConcreteCollectionInspectionBase$ExtendsConcreteCollectionVisitor", "visitClass"));
        }
    }
}

