/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExpectedExceptionNeverThrownInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("expected.exception.never.thrown.display.name", new Object[0]);
        if (string == null) {
            ExpectedExceptionNeverThrownInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String string = InspectionGadgetsBundle.message("expected.exception.never.thrown.problem.descriptor", method.getName());
        if (string == null) {
            ExpectedExceptionNeverThrownInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExpectedExceptionNeverThrownVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/ExpectedExceptionNeverThrownInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ExpectedExceptionNeverThrownVisitor
    extends BaseInspectionVisitor {
        private ExpectedExceptionNeverThrownVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, "org.junit.Test");
            if (annotation == null) {
                return;
            }
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            PsiNameValuePair[] attributes = parameterList.getAttributes();
            PsiAnnotationMemberValue value = null;
            for (PsiNameValuePair attribute : attributes) {
                if (!"expected".equals(attribute.getName())) continue;
                value = attribute.getValue();
                break;
            }
            if (!(value instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)value;
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            PsiType type = operand.getType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(type);
            if (InheritanceUtil.isInheritor(aClass, "java.lang.RuntimeException") || InheritanceUtil.isInheritor(aClass, "java.lang.Error")) {
                return;
            }
            List<PsiClassType> exceptionsThrown = ExceptionUtil.getThrownExceptions(body);
            for (PsiClassType psiClassType : exceptionsThrown) {
                if (!psiClassType.isAssignableFrom(type)) continue;
                return;
            }
            this.registerError((PsiElement)operand, method);
        }
    }
}

