/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SynchronizeOnLockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("SynchroniziationOnLockObject" == null) {
            SynchronizeOnLockInspection.$$$reportNull$$$0(0);
        }
        return "SynchroniziationOnLockObject";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronize.on.lock.display.name", new Object[0]);
        if (string == null) {
            SynchronizeOnLockInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        String string = InspectionGadgetsBundle.message("synchronize.on.lock.problem.descriptor", type);
        if (string == null) {
            SynchronizeOnLockInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnLockVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/SynchronizeOnLockInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SynchronizeOnLockVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnLockVisitor() {
        }

        @Override
        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                SynchronizeOnLockVisitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression = statement.getLockExpression();
            if (lockExpression == null) {
                return;
            }
            String type = TypeUtils.expressionHasTypeOrSubtype(lockExpression, "java.util.concurrent.locks.Lock", "java.util.concurrent.locks.ReadWriteLock");
            if (type == null) {
                return;
            }
            this.registerError((PsiElement)lockExpression, type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/SynchronizeOnLockInspection$SynchronizeOnLockVisitor", "visitSynchronizedStatement"));
        }
    }
}

