/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.util;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsPathUtil {
    public static boolean isUnder(Set<File> ancestors, File file) {
        if (ancestors.isEmpty()) {
            return false;
        }
        File current = file;
        while (current != null) {
            if (ancestors.contains(current)) {
                return true;
            }
            current = FileUtilRt.getParentFile((File)current);
        }
        return false;
    }

    public static File urlToFile(String url) {
        return new File(JpsPathUtil.urlToOsPath(url));
    }

    @NotNull
    public static String urlToOsPath(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/util/JpsPathUtil", "urlToOsPath"));
        }
        String string = FileUtilRt.toSystemDependentName((String)JpsPathUtil.urlToPath(url));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/util/JpsPathUtil", "urlToOsPath"));
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null")
    public static String urlToPath(@Nullable String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("file://")) {
            return url.substring("file://".length());
        }
        if (url.startsWith("jar://") && (url = url.substring("jar://".length())).endsWith("!/")) {
            url = url.substring(0, url.length() - "!/".length());
        }
        return url;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/util/JpsPathUtil", "fixURLforIDEA"));
        }
        int idx = url.indexOf(":/");
        if (idx >= 0 && idx + 2 < url.length() && url.charAt(idx + 2) != '/') {
            String prefix = url.substring(0, idx);
            String suffix = url.substring(idx + 2);
            url = SystemInfoRt.isWindows ? prefix + "://" + suffix : prefix + ":///" + suffix;
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/util/JpsPathUtil", "fixURLforIDEA"));
        }
        return string;
    }

    public static String pathToUrl(String path) {
        return "file://" + path;
    }

    public static String getLibraryRootUrl(File file) {
        String path = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
        if (file.isDirectory()) {
            return "file://" + path;
        }
        return "jar://" + path + "!/";
    }
}

