/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import gnu.trove.HashFunctions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

class ConcurrentLongObjectHashMap<V>
implements ConcurrentLongObjectMap<V> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int TREEIFY_THRESHOLD = 8;
    private static final int UNTREEIFY_THRESHOLD = 6;
    private static final int MIN_TREEIFY_CAPACITY = 64;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static final int MOVED = -1;
    private static final int TREEBIN = -2;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private volatile Node<V>[] table;
    private volatile Node<V>[] nextTable;
    private volatile long baseCount;
    private volatile int sizeCtl;
    private volatile int transferIndex;
    private volatile int transferOrigin;
    private volatile int cellsBusy;
    private volatile ConcurrentHashMap.CounterCell[] counterCells;
    private ValuesView<V> values;
    private EntrySetView<V> entrySet;
    private static final AtomicInteger counterHashCodeGenerator = new AtomicInteger();
    private static final int SEED_INCREMENT = 1640531527;
    private static final ThreadLocal<ConcurrentHashMap.CounterHashCode> threadCounterHashCode = new ThreadLocal();
    private static final Unsafe U;
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final long TRANSFERORIGIN;
    private static final long BASECOUNT;
    private static final long CELLSBUSY;
    private static final long CELLVALUE;
    private static final long ABASE;
    private static final int ASHIFT;

    private static int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private static <V> Node<V> tabAt(Node<V>[] tab, int i) {
        return (Node)U.getObjectVolatile(tab, ((long)i << ASHIFT) + ABASE);
    }

    private static <V> boolean casTabAt(Node<V>[] tab, int i, Node<V> c, Node<V> v) {
        return U.compareAndSwapObject(tab, ((long)i << ASHIFT) + ABASE, c, v);
    }

    private static <V> void setTabAt(Node<V>[] tab, int i, Node<V> v) {
        U.putObjectVolatile(tab, ((long)i << ASHIFT) + ABASE, v);
    }

    ConcurrentLongObjectHashMap() {
    }

    ConcurrentLongObjectHashMap(int initialCapacity) {
        int cap;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.sizeCtl = cap = initialCapacity >= 0x20000000 ? 0x40000000 : ConcurrentLongObjectHashMap.tableSizeFor(initialCapacity + (initialCapacity >>> 1) + 1);
    }

    ConcurrentLongObjectHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1);
    }

    ConcurrentLongObjectHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        long size;
        int cap;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < concurrencyLevel) {
            initialCapacity = concurrencyLevel;
        }
        this.sizeCtl = cap = (size = (long)(1.0 + (double)((float)initialCapacity / loadFactor))) >= 0x40000000L ? 0x40000000 : ConcurrentLongObjectHashMap.tableSizeFor((int)size);
    }

    @Override
    public int size() {
        long n = this.sumCount();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public V get(long key) {
        Node<V> e;
        int n;
        int h = ConcurrentLongObjectHashMap.hash(key);
        Node<V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = ConcurrentLongObjectHashMap.tabAt(tab, n - 1 & h)) != null) {
            int eh = e.hash;
            if (eh == h) {
                if (e.key == key) {
                    return e.val;
                }
            } else if (eh < 0) {
                Node<V> p = e.find(h, key);
                return p != null ? (V)p.val : null;
            }
            while ((e = e.next) != null) {
                if (e.hash != h || e.key != key) continue;
                return e.val;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(@NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "containsValue"));
        }
        Node[] t = this.table;
        if (this.table != null) {
            Node p;
            Traverser it = new Traverser(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                Object v = p.val;
                if (v != value && (v == null || !value.equals(v))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(long key, @NotNull V v) {
        void value;
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "put"));
        }
        return this.putVal(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private V putVal(long key, @NotNull V value, boolean bl) {
        int binCount;
        block19: {
            V oldVal;
            int i;
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "putVal"));
            }
            int hash = ConcurrentLongObjectHashMap.hash(key);
            binCount = 0;
            Node<V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & hash;
                Node<V> f = ConcurrentLongObjectHashMap.tabAt(tab, i);
                if (f == null) {
                    if (!ConcurrentLongObjectHashMap.casTabAt(tab, i, null, new Node(hash, key, value, null))) continue;
                    break block19;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                oldVal = null;
                Node<V> node = f;
                synchronized (node) {
                    block20: {
                        if (ConcurrentLongObjectHashMap.tabAt(tab, i) == f) {
                            void onlyIfAbsent;
                            if (fh >= 0) {
                                binCount = 1;
                                Node<V> e = f;
                                while (true) {
                                    if (e.hash == hash && e.key == key) {
                                        oldVal = e.val;
                                        if (onlyIfAbsent == false) {
                                            e.val = value;
                                        }
                                        break block20;
                                    }
                                    Node<V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        pred.next = new Node(hash, key, value, null);
                                        break block20;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeNode p = ((TreeBin)f).putTreeVal(hash, key, value);
                                if (p != null) {
                                    oldVal = p.val;
                                    if (onlyIfAbsent == false) {
                                        p.val = value;
                                    }
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
            if (oldVal != null) {
                return oldVal;
            }
        }
        this.addCount(1L, binCount);
        return null;
    }

    @Override
    public V remove(long key) {
        return this.replaceNode(key, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V replaceNode(long key, V value, Object cv) {
        int i;
        Node<V> f;
        int n;
        int hash = ConcurrentLongObjectHashMap.hash(key);
        Node<V>[] tab = this.table;
        while (tab != null && (n = tab.length) != 0 && (f = ConcurrentLongObjectHashMap.tabAt(tab, i = n - 1 & hash)) != null) {
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentLongObjectHashMap.tabAt(tab, i) == f) {
                    if (fh >= 0) {
                        validated = true;
                        Node<V> e = f;
                        Node<V> pred = null;
                        do {
                            if (e.hash == hash && e.key == key) {
                                Object ev = e.val;
                                if (cv == null || cv == ev || ev != null && cv.equals(ev)) {
                                    oldVal = ev;
                                    if (value != null) {
                                        e.val = value;
                                    } else if (pred != null) {
                                        pred.next = e.next;
                                    } else {
                                        ConcurrentLongObjectHashMap.setTabAt(tab, i, e.next);
                                    }
                                }
                                break;
                            }
                            pred = e;
                        } while ((e = e.next) != null);
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        validated = true;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(hash, key)) != null) {
                            Object pv = p.val;
                            if (cv == null || cv == pv || pv != null && cv.equals(pv)) {
                                oldVal = pv;
                                if (value != null) {
                                    p.val = value;
                                } else if (t.removeTreeNode(p)) {
                                    ConcurrentLongObjectHashMap.setTabAt(tab, i, ConcurrentLongObjectHashMap.untreeify(t.first));
                                }
                            }
                        }
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long delta = 0L;
        int i = 0;
        Node<V>[] tab = this.table;
        while (tab != null && i < tab.length) {
            TreeNode f = ConcurrentLongObjectHashMap.tabAt(tab, i);
            if (f == null) {
                ++i;
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                i = 0;
                continue;
            }
            TreeNode treeNode = f;
            synchronized (treeNode) {
                if (ConcurrentLongObjectHashMap.tabAt(tab, i) == f) {
                    Node p;
                    TreeNode treeNode2 = fh >= 0 ? f : (p = f instanceof TreeBin ? ((TreeBin)((Object)f)).first : null);
                    while (p != null) {
                        --delta;
                        p = p.next;
                    }
                    ConcurrentLongObjectHashMap.setTabAt(tab, i++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ValuesView<V> vs = this.values;
        ValuesView<V> valuesView = vs != null ? vs : (this.values = new ValuesView(this));
        if (valuesView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "values"));
        }
        return valuesView;
    }

    @NotNull
    public Set<ConcurrentLongObjectMap.LongEntry<V>> entrySet() {
        EntrySetView<V> es = this.entrySet;
        EntrySetView<V> entrySetView = es != null ? es : (this.entrySet = new EntrySetView(this));
        if (entrySetView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "entrySet"));
        }
        return entrySetView;
    }

    @Override
    @NotNull
    public Iterable<ConcurrentLongObjectMap.LongEntry<V>> entries() {
        Set<ConcurrentLongObjectMap.LongEntry<V>> set = this.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "entries"));
        }
        return set;
    }

    public int hashCode() {
        int h = 0;
        Node[] t = this.table;
        if (this.table != null) {
            Node p;
            Traverser it = new Traverser(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                h += ConcurrentLongObjectHashMap.hash(p.key) ^ p.val.hashCode();
            }
        }
        return h;
    }

    public String toString() {
        Node[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        Traverser it = new Traverser(t, f, 0, f);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node p = it.advance();
        if (p != null) {
            while (true) {
                long k = p.key;
                Object v = p.val;
                sb.append(k);
                sb.append('=');
                sb.append((Object)(v == this ? "(this Map)" : v));
                p = it.advance();
                if (p == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    public boolean equals(Object o) {
        if (o != this) {
            Node p;
            if (!(o instanceof ConcurrentLongObjectHashMap)) {
                return false;
            }
            ConcurrentLongObjectHashMap m = (ConcurrentLongObjectHashMap)o;
            Node[] t = this.table;
            int f = this.table == null ? 0 : t.length;
            Traverser it = new Traverser(t, f, 0, f);
            while ((p = it.advance()) != null) {
                Object val = p.val;
                V v = m.get(p.key);
                if (v != null && (v == val || v.equals(val))) continue;
                return false;
            }
            for (ConcurrentLongObjectMap.LongEntry<V> e : m.entrySet()) {
                V v;
                long mk = e.getKey();
                V mv = e.getValue();
                if (mv != null && (v = this.get(mk)) != null && (mv == v || mv.equals(v))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V putIfAbsent(long key, @NotNull V v) {
        void value;
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "putIfAbsent"));
        }
        return this.putVal(key, value, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(long key, @NotNull V v) {
        void value;
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "remove"));
        }
        return this.replaceNode(key, null, value) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean replace(long key, @NotNull V oldValue, @NotNull V v) {
        void newValue;
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "replace"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "replace"));
        }
        return this.replaceNode(key, newValue, oldValue) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V replace(long key, @NotNull V v) {
        void value;
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "replace"));
        }
        return this.replaceNode(key, value, null);
    }

    @Override
    @NotNull
    public long[] keys() {
        ConcurrentLongObjectMap.LongEntry[] entries = this.entrySet().toArray(new ConcurrentLongObjectMap.LongEntry[0]);
        long[] result = new long[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            ConcurrentLongObjectMap.LongEntry entry = entries[i];
            result[i] = entry.getKey();
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "keys"));
        }
        return result;
    }

    public long mappingCount() {
        long n = this.sumCount();
        return n < 0L ? 0L : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<V>[] initTable() {
        Node<V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (U.compareAndSwapInt(this, SIZECTL, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n];
                    tab = nt;
                    this.table = nt;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    private void addCount(long x, int check) {
        long s;
        long b;
        ConcurrentHashMap.CounterCell[] as = this.counterCells;
        if (this.counterCells != null || !U.compareAndSwapLong(this, BASECOUNT, b = this.baseCount, s = b + x)) {
            long v;
            ConcurrentHashMap.CounterCell a;
            int m;
            boolean uncontended = true;
            ConcurrentHashMap.CounterHashCode hc = threadCounterHashCode.get();
            if (hc == null || as == null || (m = as.length - 1) < 0 || (a = as[m & hc.code]) == null || !(uncontended = U.compareAndSwapLong(a, CELLVALUE, v = a.value, v + x))) {
                this.fullAddCount(x, hc, uncontended);
                return;
            }
            if (check <= 1) {
                return;
            }
            s = this.sumCount();
        }
        if (check >= 0) {
            int sc;
            while (s >= (long)(sc = this.sizeCtl)) {
                Node<V>[] tab = this.table;
                if (this.table == null || tab.length >= 0x40000000) break;
                if (sc < 0) {
                    if (sc == -1 || this.transferIndex <= this.transferOrigin) break;
                    Node<V>[] nt = this.nextTable;
                    if (this.nextTable == null) break;
                    if (U.compareAndSwapInt(this, SIZECTL, sc, sc - 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (U.compareAndSwapInt(this, SIZECTL, sc, -2)) {
                    this.transfer(tab, null);
                }
                s = this.sumCount();
            }
        }
    }

    private Node<V>[] helpTransfer(Node<V>[] tab, Node<V> f) {
        Node[] nextTab;
        if (f instanceof ForwardingNode && (nextTab = ((ForwardingNode)f).nextTable) != null) {
            int sc;
            if (nextTab == this.nextTable && tab == this.table && this.transferIndex > this.transferOrigin && (sc = this.sizeCtl) < -1 && U.compareAndSwapInt(this, SIZECTL, sc, sc - 1)) {
                this.transfer(tab, nextTab);
            }
            return nextTab;
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(Node<V>[] tab, Node<V>[] nextTab) {
        int n = tab.length;
        int stride = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferOrigin = n;
            this.transferIndex = n;
            ForwardingNode rev = new ForwardingNode(tab);
            int k = n;
            while (k > 0) {
                int nextk;
                int m;
                for (m = nextk = k > stride ? k - stride : 0; m < k; ++m) {
                    nextTab[m] = rev;
                }
                for (m = n + nextk; m < n + k; ++m) {
                    nextTab[m] = rev;
                }
                k = nextk;
                U.putOrderedInt(this, TRANSFERORIGIN, k);
            }
        }
        int nextn = nextTab.length;
        ForwardingNode fwd = new ForwardingNode(nextTab);
        boolean advance = true;
        boolean finishing = false;
        int i = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= this.transferOrigin) {
                    i = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!U.compareAndSwapInt(this, TRANSFERINDEX, nextIndex, nextBound)) continue;
                bound = nextBound;
                i = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i < 0 || i >= n || i + n >= nextn) {
                int sc;
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                    return;
                }
                do {
                    sc = this.sizeCtl;
                } while (!U.compareAndSwapInt(this, SIZECTL, sc, ++sc));
                if (sc != -1) {
                    return;
                }
                advance = true;
                finishing = true;
                i = n;
                continue;
            }
            TreeBin f = ConcurrentLongObjectHashMap.tabAt(tab, i);
            if (f == null) {
                if (!ConcurrentLongObjectHashMap.casTabAt(tab, i, null, fwd)) continue;
                ConcurrentLongObjectHashMap.setTabAt(nextTab, i, null);
                ConcurrentLongObjectHashMap.setTabAt(nextTab, i + n, null);
                advance = true;
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f;
            synchronized (treeBin) {
                if (ConcurrentLongObjectHashMap.tabAt(tab, i) == f) {
                    Node hn;
                    Node ln;
                    if (fh >= 0) {
                        int runBit = fh & n;
                        TreeBin lastRun = f;
                        Node p = f.next;
                        while (p != null) {
                            int b = p.hash & n;
                            if (b != runBit) {
                                runBit = b;
                                lastRun = p;
                            }
                            p = p.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p = f;
                        while (p != lastRun) {
                            int ph = p.hash;
                            long pk = p.key;
                            Object pv = p.val;
                            if ((ph & n) == 0) {
                                ln = new Node(ph, pk, pv, ln);
                            } else {
                                hn = new Node(ph, pk, pv, hn);
                            }
                            p = p.next;
                        }
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i, ln);
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i + n, hn);
                        ConcurrentLongObjectHashMap.setTabAt(tab, i, fwd);
                        advance = true;
                    } else if (f instanceof TreeBin) {
                        TreeBin t = f;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e = t.first;
                        while (e != null) {
                            int h = e.hash;
                            TreeNode p = new TreeNode(h, e.key, e.val, null, null);
                            if ((h & n) == 0) {
                                if ((p.prev = loTail) == null) {
                                    lo = p;
                                } else {
                                    loTail.next = p;
                                }
                                loTail = p;
                                ++lc;
                            } else {
                                if ((p.prev = hiTail) == null) {
                                    hi = p;
                                } else {
                                    hiTail.next = p;
                                }
                                hiTail = p;
                                ++hc;
                            }
                            e = e.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? ConcurrentLongObjectHashMap.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo) : t);
                        hn = hc <= 6 ? ConcurrentLongObjectHashMap.untreeify(hi) : (lc != 0 ? new TreeBin(hi) : t);
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i, ln);
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i + n, hn);
                        ConcurrentLongObjectHashMap.setTabAt(tab, i, fwd);
                        advance = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void treeifyBin(Node<V>[] tab, int index) {
        if (tab != null) {
            if (tab.length < 64) {
                int sc;
                if (tab == this.table && (sc = this.sizeCtl) >= 0 && U.compareAndSwapInt(this, SIZECTL, sc, -2)) {
                    this.transfer(tab, null);
                }
            } else {
                Node<V> b = ConcurrentLongObjectHashMap.tabAt(tab, index);
                if (b != null && b.hash >= 0) {
                    Node<V> node = b;
                    synchronized (node) {
                        if (ConcurrentLongObjectHashMap.tabAt(tab, index) == b) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node<V> e = b;
                            while (e != null) {
                                TreeNode p = new TreeNode(e.hash, e.key, e.val, null, null);
                                if ((p.prev = tl) == null) {
                                    hd = p;
                                } else {
                                    tl.next = p;
                                }
                                tl = p;
                                e = e.next;
                            }
                            ConcurrentLongObjectHashMap.setTabAt(tab, index, new TreeBin(hd));
                        }
                    }
                }
            }
        }
    }

    private static <V> Node<V> untreeify(Node<V> b) {
        Node hd = null;
        Node tl = null;
        Node<V> q = b;
        while (q != null) {
            Node p = new Node(q.hash, q.key, q.val, null);
            if (tl == null) {
                hd = p;
            } else {
                tl.next = p;
            }
            tl = p;
            q = q.next;
        }
        return hd;
    }

    private long sumCount() {
        ConcurrentHashMap.CounterCell[] as = this.counterCells;
        long sum = this.baseCount;
        if (as != null) {
            for (ConcurrentHashMap.CounterCell a : as) {
                if (a == null) continue;
                sum += a.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullAddCount(long x, ConcurrentHashMap.CounterHashCode hc, boolean wasUncontended) {
        int h;
        if (hc == null) {
            hc = new ConcurrentHashMap.CounterHashCode();
            int s = counterHashCodeGenerator.addAndGet(1640531527);
            hc.code = s == 0 ? 1 : s;
            h = hc.code;
            threadCounterHashCode.set(hc);
        } else {
            h = hc.code;
        }
        boolean collide = false;
        while (true) {
            ConcurrentHashMap.CounterCell[] rs;
            long v;
            int n;
            ConcurrentHashMap.CounterCell[] as = this.counterCells;
            if (this.counterCells != null && (n = as.length) > 0) {
                ConcurrentHashMap.CounterCell a = as[n - 1 & h];
                if (a == null) {
                    if (this.cellsBusy == 0) {
                        ConcurrentHashMap.CounterCell r = new ConcurrentHashMap.CounterCell(x);
                        if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                ConcurrentHashMap.CounterCell[] rs2 = this.counterCells;
                                if (this.counterCells != null && (m = rs2.length) > 0 && rs2[j = m - 1 & h] == null) {
                                    rs2[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            break;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = a.value;
                    if (U.compareAndSwapLong(a, CELLVALUE, v, v + x)) break;
                    if (this.counterCells != as || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == as) {
                                rs = new ConcurrentHashMap.CounterCell[n << 1];
                                for (int i = 0; i < n; ++i) {
                                    rs[i] = as[i];
                                }
                                this.counterCells = rs;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h ^= h << 13;
                h ^= h >>> 17;
                h ^= h << 5;
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == as && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == as) {
                        rs = new ConcurrentHashMap.CounterCell[2];
                        rs[h & 1] = new ConcurrentHashMap.CounterCell(x);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                break;
            }
            v = this.baseCount;
            if (U.compareAndSwapLong(this, BASECOUNT, v, v + x)) break;
        }
        hc.code = h;
    }

    private static Unsafe getUnsafe() {
        return AtomicFieldUpdater.getUnsafe();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V cacheOrGet(long key, @NotNull V v) {
        void defaultValue;
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "cacheOrGet"));
        }
        V v2 = this.get(key);
        if (v2 != null) {
            V v3 = v2;
            if (v3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "cacheOrGet"));
            }
            return v3;
        }
        void prev = this.putIfAbsent(key, defaultValue);
        void v1 = prev == null ? defaultValue : prev;
        if (v1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap", "cacheOrGet"));
        }
        return v1;
    }

    private static int hash(long key) {
        return HashFunctions.hash((long)key);
    }

    static {
        try {
            U = ConcurrentLongObjectHashMap.getUnsafe();
            Class<ConcurrentLongObjectHashMap> k = ConcurrentLongObjectHashMap.class;
            SIZECTL = U.objectFieldOffset(k.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = U.objectFieldOffset(k.getDeclaredField("transferIndex"));
            TRANSFERORIGIN = U.objectFieldOffset(k.getDeclaredField("transferOrigin"));
            BASECOUNT = U.objectFieldOffset(k.getDeclaredField("baseCount"));
            CELLSBUSY = U.objectFieldOffset(k.getDeclaredField("cellsBusy"));
            Class<ConcurrentHashMap.CounterCell> ck = ConcurrentHashMap.CounterCell.class;
            CELLVALUE = U.objectFieldOffset(ck.getDeclaredField("value"));
            Class<Node[]> ak = Node[].class;
            ABASE = U.arrayBaseOffset(ak);
            int scale = U.arrayIndexScale(ak);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static final class EntrySetView<V>
    extends CollectionView<V, ConcurrentLongObjectMap.LongEntry<V>>
    implements Set<ConcurrentLongObjectMap.LongEntry<V>> {
        private EntrySetView(ConcurrentLongObjectHashMap<V> map) {
            super(map);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof ConcurrentLongObjectMap.LongEntry)) {
                return false;
            }
            ConcurrentLongObjectMap.LongEntry e = (ConcurrentLongObjectMap.LongEntry)o;
            long k = e.getKey();
            Object v = e.getValue();
            Object r = this.map.get(k);
            return r != null && (v == r || v.equals(r));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof ConcurrentLongObjectMap.LongEntry)) {
                return false;
            }
            ConcurrentLongObjectMap.LongEntry e = (ConcurrentLongObjectMap.LongEntry)o;
            long k = e.getKey();
            Object v = e.getValue();
            Object r = this.map.get(k);
            return r != null && this.map.remove(k, v);
        }

        @Override
        @NotNull
        public Iterator<ConcurrentLongObjectMap.LongEntry<V>> iterator() {
            ConcurrentLongObjectHashMap m = this.map;
            Node[] t = m.table;
            int f = t == null ? 0 : t.length;
            EntryIterator entryIterator = new EntryIterator(t, f, 0, f, m);
            if (entryIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap$EntrySetView", "iterator"));
            }
            return entryIterator;
        }

        @Override
        public boolean add(ConcurrentLongObjectMap.LongEntry<V> e) {
            return this.map.putVal(e.getKey(), e.getValue(), false) == null;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends ConcurrentLongObjectMap.LongEntry<V>> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentLongObjectHashMap$EntrySetView", "addAll"));
            }
            boolean added = false;
            for (ConcurrentLongObjectMap.LongEntry<V> e : c) {
                if (!this.add(e)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public final int hashCode() {
            int h = 0;
            Node[] t = this.map.table;
            if (t != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    h += p.hashCode();
                }
            }
            return h;
        }

        @Override
        public final boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }
    }

    private static final class ValuesView<V>
    extends CollectionView<V, V>
    implements Collection<V> {
        private ValuesView(ConcurrentLongObjectHashMap<V> map) {
            super(map);
        }

        @Override
        public final boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public final boolean remove(Object o) {
            if (o != null) {
                Iterator<V> it = this.iterator();
                while (it.hasNext()) {
                    if (!o.equals(it.next())) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        @NotNull
        public final Iterator<V> iterator() {
            ConcurrentLongObjectHashMap m = this.map;
            Node[] t = m.table;
            int f = t == null ? 0 : t.length;
            ValueIterator valueIterator = new ValueIterator(t, f, 0, f, m);
            if (valueIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap$ValuesView", "iterator"));
            }
            return valueIterator;
        }

        @Override
        public final boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(@NotNull Collection<? extends V> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentLongObjectHashMap$ValuesView", "addAll"));
            }
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class CollectionView<V, E>
    implements Collection<E> {
        final ConcurrentLongObjectHashMap<V> map;
        private static final String oomeMsg = "Required array size too large";

        private CollectionView(@NotNull ConcurrentLongObjectHashMap<V> map) {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ConcurrentLongObjectHashMap$CollectionView", "<init>"));
            }
            this.map = map;
        }

        public ConcurrentLongObjectHashMap<V> getMap() {
            return this.map;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        @NotNull
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract boolean remove(Object var1);

        @Override
        @NotNull
        public final Object[] toArray() {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int n = (int)sz;
            Object[] r = new Object[n];
            int i = 0;
            for (E e : this) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = e;
            }
            Object[] objectArray = i == n ? r : Arrays.copyOf(r, i);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap$CollectionView", "toArray"));
            }
            return objectArray;
        }

        @Override
        @NotNull
        public final <T> T[] toArray(@NotNull T[] a) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/ConcurrentLongObjectHashMap$CollectionView", "toArray"));
            }
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int m = (int)sz;
            T[] r = a.length >= m ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), m);
            int n = r.length;
            int i = 0;
            for (E e : this) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = e;
            }
            if (a == r && i < n) {
                r[i] = null;
                if (r == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap$CollectionView", "toArray"));
                }
                return r;
            }
            T[] TArray = i == n ? r : Arrays.copyOf(r, i);
            if (TArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap$CollectionView", "toArray"));
            }
            return TArray;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<E> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    E e;
                    sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        @Override
        public final boolean containsAll(@NotNull Collection<?> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentLongObjectHashMap$CollectionView", "containsAll"));
            }
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public final boolean removeAll(@NotNull Collection<?> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentLongObjectHashMap$CollectionView", "removeAll"));
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public final boolean retainAll(@NotNull Collection<?> c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentLongObjectHashMap$CollectionView", "retainAll"));
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
    }

    private static final class MapEntry<V>
    implements ConcurrentLongObjectMap.LongEntry<V> {
        private final long key;
        @NotNull
        private final V val;
        private final ConcurrentLongObjectHashMap<V> map;

        /*
         * WARNING - void declaration
         */
        private MapEntry(long key, @NotNull V val, ConcurrentLongObjectHashMap<V> concurrentLongObjectHashMap) {
            void map;
            if (val == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentLongObjectHashMap$MapEntry", "<init>"));
            }
            this.key = key;
            this.val = val;
            this.map = map;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public V getValue() {
            V v = this.val;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentLongObjectHashMap$MapEntry", "getValue"));
            }
            return v;
        }

        public int hashCode() {
            return ConcurrentLongObjectHashMap.hash(this.key) ^ this.val.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConcurrentLongObjectMap.LongEntry)) {
                return false;
            }
            ConcurrentLongObjectMap.LongEntry e = (ConcurrentLongObjectMap.LongEntry)o;
            long k = e.getKey();
            Object v = e.getValue();
            V r = this.map.get(k);
            return r != null && (v == this.val || v.equals(this.val));
        }
    }

    private static final class EntryIterator<V>
    extends BaseIterator<V>
    implements Iterator<ConcurrentLongObjectMap.LongEntry<V>> {
        private EntryIterator(Node<V>[] tab, int index, int size, int limit, ConcurrentLongObjectHashMap<V> map) {
            super(tab, index, size, limit, map);
        }

        @Override
        public final ConcurrentLongObjectMap.LongEntry<V> next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            long k = p.key;
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return new MapEntry(k, v, this.map);
        }
    }

    private static final class ValueIterator<V>
    extends BaseIterator<V>
    implements Iterator<V>,
    Enumeration<V> {
        private ValueIterator(Node<V>[] tab, int index, int size, int limit, ConcurrentLongObjectHashMap<V> map) {
            super(tab, index, size, limit, map);
        }

        @Override
        public final V next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return v;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    private static class BaseIterator<V>
    extends Traverser<V> {
        final ConcurrentLongObjectHashMap<V> map;
        Node<V> lastReturned;

        private BaseIterator(Node<V>[] tab, int size, int index, int limit, ConcurrentLongObjectHashMap<V> map) {
            super(tab, size, index, limit);
            this.map = map;
            this.advance();
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }

        public final void remove() {
            Node<V> p = this.lastReturned;
            if (p == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            ((ConcurrentLongObjectHashMap)this.map).replaceNode(p.key, null, null);
        }
    }

    private static class Traverser<V> {
        private Node<V>[] tab;
        Node<V> next;
        private int index;
        private int baseIndex;
        private final int baseLimit;
        private final int baseSize;

        private Traverser(Node<V>[] tab, int size, int index, int limit) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = this.index = index;
            this.baseLimit = limit;
            this.next = null;
        }

        final Node<V> advance() {
            TreeNode e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int n;
                Node[] t;
                block9: {
                    block8: {
                        int i;
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block8;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i = this.index) && i >= 0) break block9;
                    }
                    this.next = null;
                    return null;
                }
                e = ConcurrentLongObjectHashMap.tabAt(t, this.index);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)((Object)e)).nextTable;
                        e = null;
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)((Object)e)).first : null;
                }
                if ((this.index += this.baseSize) < n) continue;
                this.index = ++this.baseIndex;
            }
        }
    }

    private static final class TreeBin<V>
    extends Node<V> {
        private TreeNode<V> root;
        private volatile TreeNode<V> first;
        private volatile Thread waiter;
        private volatile int lockState;
        private static final int WRITER = 1;
        private static final int WAITER = 2;
        private static final int READER = 4;
        private static final Unsafe U;
        private static final long LOCKSTATE;

        private TreeBin(TreeNode<V> b) {
            super(-2, 0L, null, null);
            this.first = b;
            TreeNode<V> r = null;
            TreeNode<V> x = b;
            while (x != null) {
                TreeNode<V> next = (TreeNode<V>)x.next;
                ((TreeNode)x).left = (((TreeNode)x).right = null);
                if (r == null) {
                    ((TreeNode)x).parent = null;
                    ((TreeNode)x).red = false;
                    r = x;
                } else {
                    TreeNode<V> xp;
                    int dir;
                    int h = x.hash;
                    TreeNode<V> p = r;
                    do {
                        int ph;
                        dir = (ph = p.hash) > h ? -1 : (ph < h ? 1 : 0);
                        xp = p;
                    } while ((p = dir <= 0 ? ((TreeNode)p).left : ((TreeNode)p).right) != null);
                    ((TreeNode)x).parent = (TreeNode)xp;
                    if (dir <= 0) {
                        ((TreeNode)xp).left = (TreeNode)x;
                    } else {
                        ((TreeNode)xp).right = (TreeNode)x;
                    }
                    r = TreeBin.balanceInsertion(r, x);
                }
                x = next;
            }
            this.root = r;
            assert (TreeBin.checkInvariants(this.root));
        }

        private void lockRoot() {
            if (!U.compareAndSwapInt(this, LOCKSTATE, 0, 1)) {
                this.contendedLock();
            }
        }

        private void unlockRoot() {
            this.lockState = 0;
        }

        private void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s;
                if (((s = this.lockState) & 1) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s & 2) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Node<V> find(int h, long k) {
            Node e = this.first;
            while (e != null) {
                int s = this.lockState;
                if ((s & 3) != 0) {
                    if (e.hash == h && e.key == k) {
                        return e;
                    }
                } else if (U.compareAndSwapInt(this, LOCKSTATE, s, s + 4)) {
                    TreeNode p;
                    try {
                        TreeNode<V> r = this.root;
                        p = r == null ? null : ((TreeNode)r).findTreeNode(h, k);
                    }
                    finally {
                        Thread w;
                        int ls;
                        while (!U.compareAndSwapInt(this, LOCKSTATE, ls = this.lockState, ls - 4)) {
                        }
                        if (ls == 6 && (w = this.waiter) != null) {
                            LockSupport.unpark(w);
                        }
                    }
                    return p;
                }
                e = e.next;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TreeNode<V> putTreeVal(int h, long k, V v) {
            block18: {
                TreeNode xp;
                int dir;
                boolean searched = false;
                TreeNode p = this.root;
                do {
                    if (p == null) {
                        this.root = new TreeNode(h, k, v, null, null);
                        this.first = this.root;
                        break block18;
                    }
                    int ph = p.hash;
                    if (ph > h) {
                        dir = -1;
                    } else if (ph < h) {
                        dir = 1;
                    } else {
                        if (p.key == k) {
                            return p;
                        }
                        if (!searched) {
                            TreeNode q;
                            searched = true;
                            TreeNode ch = p.left;
                            if (ch != null && (q = ch.findTreeNode(h, k)) != null || (ch = p.right) != null && (q = ch.findTreeNode(h, k)) != null) {
                                return q;
                            }
                        }
                        dir = 0;
                    }
                    xp = p;
                } while ((p = dir <= 0 ? p.left : p.right) != null);
                TreeNode<V> f = this.first;
                TreeNode x = new TreeNode(h, k, v, f, xp);
                this.first = x;
                if (f != null) {
                    ((TreeNode)f).prev = x;
                }
                if (dir <= 0) {
                    xp.left = x;
                } else {
                    xp.right = x;
                }
                if (!xp.red) {
                    x.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean removeTreeNode(TreeNode<V> p) {
            TreeNode rl;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode r = this.root;
            if (r == null || r.right == null || (rl = r.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p.left;
                TreeNode pr = p.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s = pr;
                    while ((sl = s.left) != null) {
                        s = sl;
                    }
                    boolean c = s.red;
                    s.red = p.red;
                    p.red = c;
                    TreeNode sr = s.right;
                    TreeNode pp2 = p.parent;
                    if (s == pr) {
                        p.parent = s;
                        s.right = p;
                    } else {
                        TreeNode sp = s.parent;
                        if ((p.parent = sp) != null) {
                            if (s == sp.left) {
                                sp.left = p;
                            } else {
                                sp.right = p;
                            }
                        }
                        if ((s.right = pr) != null) {
                            pr.parent = s;
                        }
                    }
                    p.left = null;
                    if ((p.right = sr) != null) {
                        sr.parent = p;
                    }
                    if ((s.left = pl) != null) {
                        pl.parent = s;
                    }
                    if ((s.parent = pp2) == null) {
                        r = s;
                    } else if (p == pp2.left) {
                        pp2.left = s;
                    } else {
                        pp2.right = s;
                    }
                    replacement = sr != null ? sr : p;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p);
                }
                if (replacement != p) {
                    pp = replacement.parent = p.parent;
                    if (pp == null) {
                        r = replacement;
                    } else if (p == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p.left = (p.right = (p.parent = null));
                }
                TreeNode treeNode = this.root = p.red ? r : TreeBin.balanceDeletion(r, replacement);
                if (p == replacement && (pp = p.parent) != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                    p.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        private static <V> TreeNode<V> rotateLeft(TreeNode<V> root, TreeNode<V> p) {
            TreeNode r;
            if (p != null && (r = ((TreeNode)p).right) != null) {
                TreeNode pp;
                TreeNode rl = ((TreeNode)p).right = r.left;
                if (rl != null) {
                    rl.parent = (TreeNode)p;
                }
                if ((pp = (r.parent = ((TreeNode)p).parent)) == null) {
                    root = r;
                    root.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = (TreeNode)p;
                ((TreeNode)p).parent = r;
            }
            return root;
        }

        private static <V> TreeNode<V> rotateRight(TreeNode<V> root, TreeNode<V> p) {
            TreeNode l;
            if (p != null && (l = ((TreeNode)p).left) != null) {
                TreeNode pp;
                TreeNode lr = ((TreeNode)p).left = l.right;
                if (lr != null) {
                    lr.parent = (TreeNode)p;
                }
                if ((pp = (l.parent = ((TreeNode)p).parent)) == null) {
                    root = l;
                    root.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = (TreeNode)p;
                ((TreeNode)p).parent = l;
            }
            return root;
        }

        private static <V> TreeNode<V> balanceInsertion(TreeNode<V> root, TreeNode<V> x) {
            x.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeBin.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeBin.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeBin.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeBin.rotateLeft(root, xpp);
            }
        }

        private static <V> TreeNode<V> balanceDeletion(TreeNode<V> root, TreeNode<V> x) {
            while (x != null && x != root) {
                TreeNode<V> xp = ((TreeNode)x).parent;
                if (xp == null) {
                    ((TreeNode)x).red = false;
                    return x;
                }
                if (((TreeNode)x).red) {
                    ((TreeNode)x).red = false;
                    return root;
                }
                TreeNode xpl = ((TreeNode)xp).left;
                if (xpl == x) {
                    TreeNode xpr = ((TreeNode)xp).right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        ((TreeNode)xp).red = true;
                        root = TreeBin.rotateLeft(root, xp);
                        xp = ((TreeNode)x).parent;
                        TreeNode treeNode = xpr = xp == null ? null : ((TreeNode)xp).right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    TreeNode sl = xpr.left;
                    TreeNode sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeBin.rotateRight(root, xpr);
                        xp = ((TreeNode)x).parent;
                        TreeNode treeNode = xpr = xp == null ? null : ((TreeNode)xp).right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : ((TreeNode)xp).red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        ((TreeNode)xp).red = false;
                        root = TreeBin.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    ((TreeNode)xp).red = true;
                    root = TreeBin.rotateRight(root, xp);
                    xp = ((TreeNode)x).parent;
                    TreeNode treeNode = xpl = xp == null ? null : ((TreeNode)xp).left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                TreeNode sl = xpl.left;
                TreeNode sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeBin.rotateLeft(root, xpl);
                    xp = ((TreeNode)x).parent;
                    TreeNode treeNode = xpl = xp == null ? null : ((TreeNode)xp).left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : ((TreeNode)xp).red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    ((TreeNode)xp).red = false;
                    root = TreeBin.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        private static <V> boolean checkInvariants(TreeNode<V> t) {
            TreeNode tp = ((TreeNode)t).parent;
            TreeNode tl = ((TreeNode)t).left;
            TreeNode tr = ((TreeNode)t).right;
            TreeNode tb = ((TreeNode)t).prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (((TreeNode)t).red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        static {
            try {
                U = ConcurrentLongObjectHashMap.getUnsafe();
                Class<TreeBin> k = TreeBin.class;
                LOCKSTATE = U.objectFieldOffset(k.getDeclaredField("lockState"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    private static final class TreeNode<V>
    extends Node<V> {
        private TreeNode<V> parent;
        private TreeNode<V> left;
        private TreeNode<V> right;
        private TreeNode<V> prev;
        private boolean red;

        private TreeNode(int hash, long key, V val, Node<V> next, TreeNode<V> parent) {
            super(hash, key, val, next);
            this.parent = parent;
        }

        @Override
        Node<V> find(int h, long k) {
            return this.findTreeNode(h, k);
        }

        private TreeNode<V> findTreeNode(int h, long k) {
            TreeNode<V> p = this;
            do {
                TreeNode<V> pl = p.left;
                TreeNode<V> pr = p.right;
                int ph = p.hash;
                if (ph > h) {
                    p = pl;
                    continue;
                }
                if (ph < h) {
                    p = pr;
                    continue;
                }
                if (p.key == k) {
                    return p;
                }
                if (pl == null) {
                    p = pr;
                    continue;
                }
                if (pr == null) {
                    p = pl;
                    continue;
                }
                TreeNode<V> q = super.findTreeNode(h, k);
                if (q != null) {
                    return q;
                }
                p = pl;
            } while (p != null);
            return null;
        }
    }

    private static final class ForwardingNode<V>
    extends Node<V> {
        private final Node<V>[] nextTable;

        private ForwardingNode(Node<V>[] tab) {
            super(-1, 0L, null, null);
            this.nextTable = tab;
        }

        @Override
        Node<V> find(int h, long k) {
            Node[] tab = this.nextTable;
            block0: while (true) {
                Node e;
                int n;
                if (tab == null || (n = tab.length) == 0 || (e = ConcurrentLongObjectHashMap.tabAt(tab, n - 1 & h)) == null) {
                    return null;
                }
                do {
                    int eh;
                    if ((eh = e.hash) == h && e.key == k) {
                        return e;
                    }
                    if (eh >= 0) continue;
                    if (e instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e).nextTable;
                        continue block0;
                    }
                    return e.find(h, k);
                } while ((e = e.next) != null);
                break;
            }
            return null;
        }
    }

    private static class Node<V> {
        final int hash;
        final long key;
        volatile V val;
        volatile Node<V> next;

        private Node(int hash, long key, V val, Node<V> next) {
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.next = next;
        }

        public final long getKey() {
            return this.key;
        }

        public final V getValue() {
            return this.val;
        }

        public final int hashCode() {
            return HashFunctions.hash((long)this.key) ^ this.val.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.val;
        }

        public final boolean equals(Object o) {
            V u;
            if (!(o instanceof Node)) {
                return false;
            }
            Node e = (Node)o;
            long k = e.getKey();
            V v = e.getValue();
            return v != null && k == this.key && (v == (u = this.val) || v.equals(u));
        }

        Node<V> find(int h, long k) {
            Node<V> e = this;
            do {
                if (e.hash != h || e.key != k) continue;
                return e;
            } while ((e = e.next) != null);
            return null;
        }
    }
}

