/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtSdkPathUtil {
    @NonNls
    public static final String GWT_DEV_JAR = "gwt-dev.jar";
    @NonNls
    private static final String GWT_DEV_WINDOWS_JAR = "gwt-dev-windows.jar";
    @NonNls
    private static final String GWT_DEV_LINUX_JAR = "gwt-dev-linux.jar";
    @NonNls
    private static final String GWT_DEV_MAC_JAR = "gwt-dev-mac.jar";

    @NotNull
    public static List<String> findValidationJars(File parent) {
        File[] files = parent.listFiles();
        ArrayList<String> paths = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith("validation-api-") || !name.endsWith(".jar")) continue;
                paths.add(file.getAbsolutePath());
            }
        }
        ArrayList<String> arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtSdkPathUtil", "findValidationJars"));
        }
        return arrayList;
    }

    public static String getCodeServerJarPath(String homePath) {
        return homePath + File.separator + "gwt-codeserver.jar";
    }

    public static String getUserJarPath(String homePath) {
        return homePath + File.separator + "gwt-user.jar";
    }

    public static String getSystemDependentDevJarName() {
        String jarName = SystemInfo.isWindows ? GWT_DEV_WINDOWS_JAR : (SystemInfo.isMac ? GWT_DEV_MAC_JAR : GWT_DEV_LINUX_JAR);
        return jarName;
    }

    public static String getDevJarPath(String homePath) {
        String newPath = GwtSdkPathUtil.getSystemIndependentDevJarPath(homePath);
        if (new File(newPath).exists()) {
            return newPath;
        }
        return GwtSdkPathUtil.getSystemDependentDevJarPath(homePath);
    }

    public static String getSystemIndependentDevJarPath(String homePath) {
        return homePath + File.separator + GWT_DEV_JAR;
    }

    public static String getSystemDependentDevJarPath(String homePath) {
        return homePath + File.separator + GwtSdkPathUtil.getSystemDependentDevJarName();
    }

    public static List<String> findValidationJarsInMavenRepo(String repositoryPath) {
        File validationDir = new File(FileUtil.toSystemDependentName((String)(repositoryPath + "/javax/validation/validation-api")));
        File[] files = validationDir.listFiles();
        if (files != null && files.length > 0) {
            return GwtSdkPathUtil.findValidationJars(files[0]);
        }
        return Collections.emptyList();
    }
}

