/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Verifier;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.build.OsgiBuildException;
import org.jetbrains.osgi.jps.build.Reporter;
import org.jetbrains.osgi.jps.build.ReportingAnalyzer;
import org.jetbrains.osgi.jps.build.ReportingBuilder;
import org.jetbrains.osgi.jps.model.JpsOsmorcExtensionService;
import org.jetbrains.osgi.jps.model.LibraryBundlificationRule;
import org.jetbrains.osgi.jps.util.OrderedProperties;

public class BndWrapper {
    private final Reporter myReporter;

    public BndWrapper(Reporter reporter) {
        this.myReporter = reporter;
    }

    @Nullable
    public File wrapLibrary(@NotNull File sourceFile, @NotNull File outputDir) throws OsgiBuildException {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/osgi/jps/build/BndWrapper", "wrapLibrary"));
        }
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDir", "org/jetbrains/osgi/jps/build/BndWrapper", "wrapLibrary"));
        }
        if (!sourceFile.isFile()) {
            throw new OsgiBuildException("The library '" + sourceFile + "' does not exist - please check module dependencies.");
        }
        File targetFile = new File(outputDir, sourceFile.getName());
        HashMap additionalProperties = ContainerUtil.newHashMap();
        long lastModified = Long.MIN_VALUE;
        for (LibraryBundlificationRule bundlificationRule : JpsOsmorcExtensionService.getInstance().getLibraryBundlificationRules()) {
            if (!bundlificationRule.appliesTo(sourceFile.getName())) continue;
            if (bundlificationRule.isDoNotBundle()) {
                return null;
            }
            additionalProperties.putAll(bundlificationRule.getAdditionalPropertiesMap());
            lastModified = Math.max(lastModified, bundlificationRule.getLastModified());
            if (!bundlificationRule.isStopAfterThisRule()) continue;
            break;
        }
        if (targetFile.exists() && targetFile.lastModified() >= sourceFile.lastModified() && targetFile.lastModified() >= lastModified) {
            return targetFile;
        }
        this.doWrap(sourceFile, targetFile, additionalProperties);
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrap(@NotNull File inputJar, @NotNull File outputJar, @NotNull Map<String, String> properties) throws OsgiBuildException {
        if (inputJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputJar", "org/jetbrains/osgi/jps/build/BndWrapper", "doWrap"));
        }
        if (outputJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputJar", "org/jetbrains/osgi/jps/build/BndWrapper", "doWrap"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/osgi/jps/build/BndWrapper", "doWrap"));
        }
        if (!FileUtil.delete((File)outputJar)) {
            throw new OsgiBuildException("Can't delete outdated bundle '" + outputJar + "'");
        }
        if (!FileUtil.createParentDirs((File)outputJar)) {
            throw new OsgiBuildException("Can't create output directory for '" + outputJar + "'");
        }
        try {
            ReportingAnalyzer analyzer = new ReportingAnalyzer(this.myReporter);
            analyzer.setPedantic(false);
            analyzer.setJar(inputJar);
            analyzer.putAll(properties, false);
            if (analyzer.getProperty("Import-Package") == null) {
                analyzer.setProperty("Import-Package", "*;resolution:=optional");
            }
            if (analyzer.getProperty("Bundle-SymbolicName") == null) {
                Pattern p = Pattern.compile("(" + Verifier.SYMBOLICNAME.pattern() + ")(-[0-9])?.*\\.jar");
                Matcher m = p.matcher(inputJar.getName());
                if (!m.matches()) {
                    throw new OsgiBuildException("Can't calculate output bundle name for '" + inputJar + "' - rename file or use -properties");
                }
                analyzer.setProperty("Bundle-SymbolicName", m.group(1));
            }
            if (analyzer.getProperty("Export-Package") == null) {
                analyzer.setProperty("Export-Package", "*");
            }
            JarFile jarFile = new JarFile(inputJar);
            try {
                analyzer.mergeManifest(jarFile.getManifest());
            }
            finally {
                jarFile.close();
            }
            String version = analyzer.getProperty("Bundle-Version");
            if (version != null) {
                version = Analyzer.cleanupVersion((String)version);
                analyzer.setProperty("Bundle-Version", version);
            }
            analyzer.calcManifest();
            Jar jar = analyzer.getJar();
            jar.write(outputJar);
            jar.close();
            analyzer.close();
        }
        catch (OsgiBuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OsgiBuildException("There was an unexpected problem when trying to bundlify", e, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public File makeBndFile(@NotNull Map<String, String> contents, @NotNull String comment, @NotNull File outputDir) throws OsgiBuildException {
        File file;
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "org/jetbrains/osgi/jps/build/BndWrapper", "makeBndFile"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "org/jetbrains/osgi/jps/build/BndWrapper", "makeBndFile"));
        }
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDir", "org/jetbrains/osgi/jps/build/BndWrapper", "makeBndFile"));
        }
        try {
            File file2 = FileUtil.createTempFile((File)outputDir, (String)"osgi.", (String)".bnd", (boolean)true, (boolean)true);
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file2));
            try {
                OrderedProperties.fromMap(contents).store(stream, comment);
            }
            finally {
                ((OutputStream)stream).close();
            }
            file = file2;
        }
        catch (IOException e) {
            throw new OsgiBuildException("Problem when generating .bnd file", e, null);
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/BndWrapper", "makeBndFile"));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(@NotNull File bndFile, @NotNull File moduleOutput, @NotNull File outputFile) throws OsgiBuildException {
        if (bndFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bndFile", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
        }
        if (moduleOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleOutput", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/osgi/jps/build/BndWrapper", "build"));
        }
        try {
            File manifestFile;
            ReportingBuilder builder = new ReportingBuilder(this.myReporter);
            builder.setPedantic(false);
            builder.setProperties(bndFile);
            builder.setClasspath(new File[]{moduleOutput});
            String manifest = builder.getProperty("-manifest");
            if (manifest != null && (manifestFile = builder.getFile(manifest)) != null) {
                try {
                    FileInputStream stream = new FileInputStream(manifestFile);
                    try {
                        Properties p = new Properties();
                        p.load(stream);
                        String value = p.getProperty(Attributes.Name.MANIFEST_VERSION.toString());
                        if (StringUtil.isEmptyOrSpaces((String)value)) {
                            String message = "Manifest misses a Manifest-Version entry. This may produce an empty manifest in the resulting bundle.";
                            this.myReporter.warning(message, null, manifest);
                        }
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (Exception e) {
                    this.myReporter.warning("Can't read manifest: " + e.getMessage(), e, manifest);
                }
            }
            Jar jar = builder.build();
            jar.setName(outputFile.getName());
            jar.write(outputFile);
            builder.close();
        }
        catch (Exception e) {
            throw new OsgiBuildException("Unexpected build error", e, null);
        }
    }

    @NotNull
    public static File getOutputDir(@NotNull File moduleOutputDir) throws OsgiBuildException {
        if (moduleOutputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleOutputDir", "org/jetbrains/osgi/jps/build/BndWrapper", "getOutputDir"));
        }
        File outputDir = new File(moduleOutputDir.getParent(), "bundles");
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new OsgiBuildException("Can't create output directory '" + outputDir + "'. Please check file permissions.");
        }
        File file = outputDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/BndWrapper", "getOutputDir"));
        }
        return file;
    }
}

