/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjBuilderBase;
import com.intellij.lang.aspectj.build.AjCompilerMessageHandler;
import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsModuleSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.tools.ajc.Main;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.module.JpsModule;

public class AjJpsCompiler {
    public static final Logger LOG = Logger.getInstance(AjJpsCompiler.class);
    private static final String AJC_MULTI_THREADED_PROPERTY = "aspectj.multithreaded";
    private final CompileContext myContext;
    private final ModuleChunk myChunk;
    private final ModuleBuildTarget myTarget;
    private final AjCompilerSettings myCompilerSettings;
    private final ModuleLevelBuilder.OutputConsumer myOutputConsumer;
    private final AjModuleSettings myModuleSettings;

    public AjJpsCompiler(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull ModuleBuildTarget target, @NotNull AjCompilerSettings settings, @NotNull ModuleLevelBuilder.OutputConsumer consumer) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        this.myContext = context;
        this.myChunk = chunk;
        this.myTarget = target;
        this.myCompilerSettings = settings;
        this.myOutputConsumer = consumer;
        this.myModuleSettings = AjJpsModuleSettings.getSettings(target.getModule());
    }

    public ModuleLevelBuilder.ExitCode build() throws ProjectBuildException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting ajc for target: " + this.myTarget);
        }
        this.myContext.processMessage((BuildMessage)new ProgressMessage(AjJpsBundle.message("aj.progress.loading", new Object[0])));
        if (LOG.isDebugEnabled()) {
            LOG.debug("multi-threaded AJC: " + BuildRunner.PARALLEL_BUILD_ENABLED);
        }
        System.setProperty(AJC_MULTI_THREADED_PROPERTY, BuildRunner.PARALLEL_BUILD_ENABLED ? "true" : "");
        Object[] args = this.getCommandLine();
        if (LOG.isDebugEnabled()) {
            LOG.debug("args: " + Arrays.toString(args));
        }
        Main compiler = new Main();
        AjCompilerMessageHandler mh = new AjCompilerMessageHandler(this.myContext, this.myOutputConsumer, this.myTarget);
        compiler.setHolder((IMessageHolder)mh);
        compiler.runMain((String[])args, false);
        mh.clearMessages();
        return mh.hasErrors() ? ModuleLevelBuilder.ExitCode.ABORT : ModuleLevelBuilder.ExitCode.OK;
    }

    private String[] getCommandLine() throws IOException {
        ArrayList command = ContainerUtilRt.newArrayList();
        this.setOptions(command);
        this.setTargetDir(command);
        this.setClasspath(command);
        this.setFiles(command);
        if (LOG.isDebugEnabled()) {
            LOG.debug("command: " + command);
        }
        return ArrayUtilRt.toStringArray((Collection)command);
    }

    private void setOptions(List<String> command) {
        AjCompilerSettings.addFilteredCompilerOptions(command, this.myCompilerSettings);
        ProcessorConfigProfile profile = null;
        if (this.myCompilerSettings.aptOptionsEnabled) {
            JpsProject project = this.myContext.getProjectDescriptor().getProject();
            JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
            Set modules = this.myChunk.getModules();
            if (compilerConfig != null && modules.size() == 1) {
                JpsModule module = (JpsModule)modules.iterator().next();
                profile = compilerConfig.getAnnotationProcessingProfile(module);
            }
        }
        JavaBuilder.addCompilationOptions(command, (CompileContext)this.myContext, (ModuleChunk)this.myChunk, profile);
        command.add("-verbose");
    }

    private void setTargetDir(List<String> command) {
        command.add("-d");
        command.add(AjBuilderBase.getTargetDir(this.myTarget));
    }

    private void setClasspath(List<String> command) {
        Couple<List<String>> paths = AjBuilderBase.getPaths(this.myChunk, this.myTarget, this.myCompilerSettings, this.myModuleSettings);
        if (!((List)paths.first).isEmpty()) {
            command.add("-classpath");
            command.add(StringUtil.join((Collection)((Collection)paths.first), (String)File.pathSeparator));
        }
        if (!((List)paths.second).isEmpty()) {
            command.add("-aspectpath");
            command.add(StringUtil.join((Collection)((Collection)paths.second), (String)File.pathSeparator));
        }
    }

    private void setFiles(List<String> command) {
        THashSet roots = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        BuildRootIndex index = this.myContext.getProjectDescriptor().getBuildRootIndex();
        for (JavaSourceRootDescriptor root : index.getTargetRoots((BuildTarget)this.myTarget, this.myContext)) {
            File rootFile;
            if (root.isTemp || !(rootFile = root.getRootFile()).exists()) continue;
            roots.add(rootFile.getPath());
        }
        if (roots.isEmpty()) {
            throw new AjBuilderBase.AjBuildException("missing source roots for target '" + this.myTarget + "'");
        }
        command.add("-sourceroots");
        command.add(StringUtil.join((Collection)roots, (String)File.pathSeparator));
    }
}

