/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjBuilderBase;
import com.intellij.lang.aspectj.build.AjJpsWeaver;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsModuleSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.module.JpsModule;

public class AjWeavingBuilder
extends AjBuilderBase {
    private static final String AJ_WEAVER_CLASS = "org.aspectj.weaver.tools.WeavingAdaptor";

    public AjWeavingBuilder() {
        super(BuilderCategory.CLASS_INSTRUMENTER, AJ_WEAVER_CLASS);
    }

    @Override
    public ModuleLevelBuilder.ExitCode doBuild(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> holder, @NotNull ModuleLevelBuilder.OutputConsumer consumer, @NotNull AjCompilerSettings settings) throws ProjectBuildException, IOException, AjBuilderBase.AjBuildException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/aspectj/build/AjWeavingBuilder", "doBuild"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/intellij/lang/aspectj/build/AjWeavingBuilder", "doBuild"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/aspectj/build/AjWeavingBuilder", "doBuild"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/aspectj/build/AjWeavingBuilder", "doBuild"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/aspectj/build/AjWeavingBuilder", "doBuild"));
        }
        if (!settings.delegateToJavac) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        if (consumer.getCompiledClasses().isEmpty()) {
            LOG.debug("no files");
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        ModuleLevelBuilder.ExitCode result = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        for (ModuleBuildTarget target : chunk.getTargets()) {
            JpsModule module = target.getModule();
            AjModuleSettings moduleSettings = AjJpsModuleSettings.getSettings(module);
            if (moduleSettings == null || !moduleSettings.weaveOnly) continue;
            ModuleLevelBuilder.ExitCode targetResult = new AjJpsWeaver(context, chunk, consumer, target, settings).build();
            if (targetResult == ModuleLevelBuilder.ExitCode.ABORT) {
                return targetResult;
            }
            if (targetResult.compareTo((Enum)result) <= 0) continue;
            result = targetResult;
        }
        return result;
    }

    public List<String> getCompilableFileExtensions() {
        return Collections.emptyList();
    }
}

