/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.ClassRepr;
import org.jetbrains.jps.builders.java.dependencyView.ClassfileAnalyzer;
import org.jetbrains.jps.builders.java.dependencyView.CollectionFactory;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.ElemType;
import org.jetbrains.jps.builders.java.dependencyView.FieldRepr;
import org.jetbrains.jps.builders.java.dependencyView.IntIntMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntIntPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntIntTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.LoggerWrapper;
import org.jetbrains.jps.builders.java.dependencyView.MethodRepr;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.ProtoMember;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.storage.FileKeyDescriptor;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class Mappings {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.ether.dependencyView.Mappings");
    private static final String CLASS_TO_SUBCLASSES = "classToSubclasses.tab";
    private static final String CLASS_TO_CLASS = "classToClass.tab";
    private static final String SHORT_NAMES = "shortNames.tab";
    private static final String SOURCE_TO_CLASS = "sourceToClass.tab";
    private static final String CLASS_TO_SOURCE = "classToSource.tab";
    private static final IntInlineKeyDescriptor INT_KEY_DESCRIPTOR = new IntInlineKeyDescriptor();
    private static final int DEFAULT_SET_CAPACITY = 32;
    private static final float DEFAULT_SET_LOAD_FACTOR = 0.98f;
    private static final CollectionFactory<ClassRepr> ourClassSetConstructor = new CollectionFactory<ClassRepr>(){

        @Override
        public Set<ClassRepr> create() {
            return new THashSet(5, 0.98f);
        }
    };
    private final boolean myIsDelta;
    private final boolean myDeltaIsTransient;
    private boolean myIsDifferentiated = false;
    private boolean myIsRebuild = false;
    private final TIntHashSet myChangedClasses;
    private final THashSet<File> myChangedFiles;
    private final Set<Pair<ClassRepr, File>> myDeletedClasses;
    private final Set<ClassRepr> myAddedClasses;
    private final Object myLock;
    private final File myRootDir;
    private DependencyContext myContext;
    private final int myInitName;
    private final int myEmptyName;
    private final int myObjectClassName;
    private LoggerWrapper<Integer> myDebugS;
    private IntIntMultiMaplet myClassToSubclasses;
    private IntIntMultiMaplet myClassToClassDependency;
    private ObjectObjectMultiMaplet<File, ClassRepr> mySourceFileToClasses;
    private IntObjectMultiMaplet<File> myClassToSourceFile;
    private IntIntMultiMaplet myShortClassNameIndex;
    private IntIntTransientMultiMaplet myRemovedSuperClasses;
    private IntIntTransientMultiMaplet myAddedSuperClasses;
    @Nullable
    private Collection<String> myRemovedFiles;
    private final LinkedBlockingQueue<Runnable> myPostPasses = new LinkedBlockingQueue();
    private static final ClassRepr MOCK_CLASS = null;
    private static final MethodRepr MOCK_METHOD = null;

    private Mappings(Mappings base) throws IOException {
        this.myLock = base.myLock;
        this.myIsDelta = true;
        this.myChangedClasses = new TIntHashSet(32, 0.98f);
        this.myChangedFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        this.myDeletedClasses = new HashSet<Pair<ClassRepr, File>>(32, 0.98f);
        this.myAddedClasses = new HashSet<ClassRepr>(32, 0.98f);
        this.myDeltaIsTransient = base.myDeltaIsTransient;
        this.myRootDir = new File(FileUtil.toSystemIndependentName((String)base.myRootDir.getAbsolutePath()) + File.separatorChar + "myDelta");
        this.myContext = base.myContext;
        this.myInitName = this.myContext.get("<init>");
        this.myEmptyName = this.myContext.get("");
        this.myObjectClassName = this.myContext.get("java/lang/Object");
        this.myDebugS = base.myDebugS;
        this.createImplementation();
    }

    public Mappings(File rootDir, boolean transientDelta) throws IOException {
        this.myLock = new Object();
        this.myIsDelta = false;
        this.myChangedClasses = null;
        this.myChangedFiles = null;
        this.myDeletedClasses = null;
        this.myAddedClasses = null;
        this.myDeltaIsTransient = transientDelta;
        this.myRootDir = rootDir;
        this.createImplementation();
        this.myInitName = this.myContext.get("<init>");
        this.myEmptyName = this.myContext.get("");
        this.myObjectClassName = this.myContext.get("java/lang/Object");
    }

    private void createImplementation() throws IOException {
        if (!this.myIsDelta) {
            this.myContext = new DependencyContext(this.myRootDir);
            this.myDebugS = this.myContext.getLogger(LOG);
        }
        this.myRemovedSuperClasses = this.myIsDelta ? new IntIntTransientMultiMaplet() : null;
        this.myAddedSuperClasses = this.myIsDelta ? new IntIntTransientMultiMaplet() : null;
        CollectionFactory<File> fileCollectionFactory = new CollectionFactory<File>(){

            @Override
            public Collection<File> create() {
                return new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            }
        };
        if (this.myIsDelta && this.myDeltaIsTransient) {
            this.myClassToSubclasses = new IntIntTransientMultiMaplet();
            this.myClassToClassDependency = new IntIntTransientMultiMaplet();
            this.myShortClassNameIndex = null;
            this.mySourceFileToClasses = new ObjectObjectTransientMultiMaplet<File, ClassRepr>(FileUtil.FILE_HASHING_STRATEGY, ourClassSetConstructor);
            this.myClassToSourceFile = new IntObjectTransientMultiMaplet<File>(fileCollectionFactory);
        } else {
            if (this.myIsDelta) {
                this.myRootDir.mkdirs();
            }
            this.myClassToSubclasses = new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_SUBCLASSES), (KeyDescriptor<Integer>)INT_KEY_DESCRIPTOR);
            this.myClassToClassDependency = new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_CLASS), (KeyDescriptor<Integer>)INT_KEY_DESCRIPTOR);
            this.myShortClassNameIndex = this.myIsDelta ? null : new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, SHORT_NAMES), (KeyDescriptor<Integer>)INT_KEY_DESCRIPTOR);
            this.mySourceFileToClasses = new ObjectObjectPersistentMultiMaplet<File, ClassRepr>(DependencyContext.getTableFile(this.myRootDir, SOURCE_TO_CLASS), new FileKeyDescriptor(), ClassRepr.externalizer(this.myContext), ourClassSetConstructor);
            this.myClassToSourceFile = new IntObjectPersistentMultiMaplet<File>(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_SOURCE), (KeyDescriptor<Integer>)INT_KEY_DESCRIPTOR, (DataExternalizer<File>)new FileKeyDescriptor(), fileCollectionFactory);
        }
    }

    public String valueOf(int name) {
        return this.myContext.getValue(name);
    }

    public int getName(String string) {
        return this.myContext.get(string);
    }

    public Mappings createDelta() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                return new Mappings(this);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }
    }

    private void compensateRemovedContent(Collection<File> compiled) {
        if (compiled != null) {
            for (File file : compiled) {
                if (this.mySourceFileToClasses.containsKey(file)) continue;
                this.mySourceFileToClasses.put(file, new HashSet());
            }
        }
    }

    @Nullable
    private ClassRepr getReprByName(@Nullable File source, int qName) {
        Set<File> sources;
        Collection<File> collection = sources = source != null ? Collections.singleton(source) : this.myClassToSourceFile.get(qName);
        if (sources != null) {
            for (File src : sources) {
                Collection<ClassRepr> reprs = this.mySourceFileToClasses.get(src);
                if (reprs == null) continue;
                for (ClassRepr repr : reprs) {
                    if (repr.name != qName) continue;
                    return repr;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() throws IOException {
        if (this.myRootDir != null) {
            Object object = this.myLock;
            synchronized (object) {
                this.close();
                FileUtil.delete((File)this.myRootDir);
                this.createImplementation();
            }
        }
    }

    public IntIntTransientMultiMaplet getRemovedSuperClasses() {
        return this.myRemovedSuperClasses;
    }

    public IntIntTransientMultiMaplet getAddedSuperClasses() {
        return this.myAddedSuperClasses;
    }

    private void runPostPasses() {
        Set<Pair<ClassRepr, File>> deleted = this.myDeletedClasses;
        if (deleted != null) {
            for (Pair<ClassRepr, File> pair : deleted) {
                this.myChangedClasses.remove(((ClassRepr)pair.first).name);
            }
        }
        Runnable pass = this.myPostPasses.poll();
        while (pass != null) {
            pass.run();
            pass = this.myPostPasses.poll();
        }
    }

    void affectAll(int className, final @NotNull File sourceFile, final Collection<File> affectedFiles, final @Nullable DependentFilesFilter filter) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/jps/builders/java/dependencyView/Mappings", "affectAll"));
        }
        TIntHashSet dependants = this.myClassToClassDependency.get(className);
        if (dependants != null) {
            dependants.forEach(new TIntProcedure(){

                public boolean execute(int depClass) {
                    Collection allSources = Mappings.this.myClassToSourceFile.get(depClass);
                    if (allSources != null) {
                        for (File depFile : allSources) {
                            if (FileUtil.filesEqual((File)depFile, (File)sourceFile) || filter != null && !filter.accept(depFile)) continue;
                            affectedFiles.add(depFile);
                        }
                    }
                    return true;
                }
            });
        }
    }

    private static boolean isVisibleIn(ClassRepr c, ProtoMember m, ClassRepr scope) {
        boolean privacy = m.isPrivate() && c.name != scope.name;
        boolean packageLocality = m.isPackageLocal() && !c.getPackageName().equals(scope.getPackageName());
        return !privacy && !packageLocality;
    }

    private boolean isEmpty(int s) {
        return s == this.myEmptyName;
    }

    @NotNull
    private TIntHashSet getAllSubclasses(int root) {
        TIntHashSet tIntHashSet = this.addAllSubclasses(root, new TIntHashSet(32, 0.98f));
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/Mappings", "getAllSubclasses"));
        }
        return tIntHashSet;
    }

    private TIntHashSet addAllSubclasses(int root, final TIntHashSet acc) {
        TIntHashSet directSubclasses = this.myClassToSubclasses.get(root);
        acc.add(root);
        if (directSubclasses != null) {
            directSubclasses.forEach(new TIntProcedure(){

                public boolean execute(int s) {
                    if (!acc.contains(s)) {
                        Mappings.this.addAllSubclasses(s, acc);
                    }
                    return true;
                }
            });
        }
        return acc;
    }

    private boolean incrementalDecision(int owner, Proto member, Collection<File> affectedFiles, Collection<File> currentlyCompiled, final @Nullable DependentFilesFilter filter) {
        boolean isField = member instanceof FieldRepr;
        Util self = new Util();
        if (member.isPublic()) {
            Mappings.debug("Public access, switching to a non-incremental mode");
            return false;
        }
        final THashSet toRecompile = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        if (member.isProtected()) {
            Mappings.debug("Protected access, softening non-incremental decision: adding all relevant subclasses for a recompilation");
            this.debug("Root class: ", owner);
            TIntHashSet propagated = self.propagateFieldAccess(isField ? member.name : this.myEmptyName, owner);
            propagated.forEach(new TIntProcedure(){

                public boolean execute(int className) {
                    Collection fileNames = Mappings.this.myClassToSourceFile.get(className);
                    if (fileNames != null) {
                        for (File fileName : fileNames) {
                            Mappings.this.debug("Adding ", fileName);
                        }
                        toRecompile.addAll(fileNames);
                    }
                    return true;
                }
            });
        }
        final String packageName = ClassRepr.getPackageName(this.myContext.getValue(isField ? owner : member.name));
        Mappings.debug("Softening non-incremental decision: adding all package classes for a recompilation");
        this.debug("Package name: ", packageName);
        this.myClassToSourceFile.forEachEntry(new TIntObjectProcedure<Collection<File>>(){

            public boolean execute(int className, Collection<File> fileNames) {
                if (ClassRepr.getPackageName(Mappings.this.myContext.getValue(className)).equals(packageName)) {
                    for (File fileName : fileNames) {
                        if (filter != null && !filter.accept(fileName)) continue;
                        Mappings.this.debug("Adding: ", fileName);
                        toRecompile.add((Object)fileName);
                    }
                }
                return true;
            }
        });
        toRecompile.removeAll(currentlyCompiled);
        Iterator it = toRecompile.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            if (file.exists()) continue;
            it.remove();
        }
        affectedFiles.addAll((Collection<File>)toRecompile);
        return true;
    }

    public void differentiateOnRebuild(Mappings delta) {
        new Differential(delta).differentiate();
    }

    public void differentiateOnNonIncrementalMake(Mappings delta, Collection<String> removed, Collection<File> filesToCompile) {
        new Differential(delta, removed, filesToCompile).differentiate();
    }

    public boolean differentiateOnIncrementalMake(Mappings delta, Collection<String> removed, Collection<File> filesToCompile, Collection<File> compiledFiles, Collection<File> affectedFiles, @NotNull DependentFilesFilter filter, @Nullable Callbacks.ConstantAffectionResolver constantSearch) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/jps/builders/java/dependencyView/Mappings", "differentiateOnIncrementalMake"));
        }
        return new Differential(delta, removed, filesToCompile, compiledFiles, affectedFiles, filter, constantSearch).differentiate();
    }

    private void cleanupBackDependency(int className, @Nullable Set<UsageRepr.Usage> usages, IntIntMultiMaplet buffer) {
        ClassRepr repr;
        if (usages == null && (repr = this.getReprByName(null, className)) != null) {
            usages = repr.getUsages();
        }
        if (usages != null) {
            for (UsageRepr.Usage u : usages) {
                buffer.put(u.getOwner(), className);
            }
        }
    }

    private void cleanupRemovedClass(Mappings delta, @NotNull ClassRepr cr, File sourceFile, Set<UsageRepr.Usage> usages, IntIntMultiMaplet dependenciesTrashBin) {
        if (cr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cr", "org/jetbrains/jps/builders/java/dependencyView/Mappings", "cleanupRemovedClass"));
        }
        int className = cr.name;
        Collection<File> currentlyMapped = this.myClassToSourceFile.get(className);
        if (currentlyMapped == null || currentlyMapped.isEmpty()) {
            return;
        }
        if (currentlyMapped.size() == 1) {
            if (!FileUtil.filesEqual((File)sourceFile, (File)currentlyMapped.iterator().next())) {
                return;
            }
        } else {
            for (File file : currentlyMapped) {
                if (FileUtil.filesEqual((File)sourceFile, (File)file) || !file.exists()) continue;
                return;
            }
        }
        for (int superSomething : cr.getSupers()) {
            delta.registerRemovedSuperClass(className, superSomething);
        }
        this.cleanupBackDependency(className, usages, dependenciesTrashBin);
        this.myClassToClassDependency.remove(className);
        this.myClassToSubclasses.remove(className);
        this.myClassToSourceFile.remove(className);
        if (!cr.isLocal() && !cr.isAnonymous()) {
            this.myShortClassNameIndex.removeFrom(this.myContext.get(cr.getShortName()), className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrate(final Mappings delta) {
        Object object = this.myLock;
        synchronized (object) {
            try {
                assert (delta.isDifferentiated());
                Collection<String> removed = delta.myRemovedFiles;
                delta.runPostPasses();
                final IntIntTransientMultiMaplet dependenciesTrashBin = new IntIntTransientMultiMaplet();
                if (removed != null) {
                    for (String string : removed) {
                        File deletedFile = new File(string);
                        Set fileClasses = (Set)this.mySourceFileToClasses.get(deletedFile);
                        if (fileClasses == null) continue;
                        for (ClassRepr aClass : fileClasses) {
                            this.cleanupRemovedClass(delta, aClass, deletedFile, aClass.getUsages(), dependenciesTrashBin);
                        }
                        this.mySourceFileToClasses.remove(deletedFile);
                    }
                }
                if (!delta.isRebuild()) {
                    for (Pair pair : delta.getDeletedClasses()) {
                        ClassRepr deletedClass = (ClassRepr)pair.first;
                        this.cleanupRemovedClass(delta, deletedClass, (File)pair.second, deletedClass.getUsages(), dependenciesTrashBin);
                    }
                    for (ClassRepr classRepr : delta.getAddedClasses()) {
                        if (classRepr.isAnonymous() || classRepr.isLocal()) continue;
                        this.myShortClassNameIndex.put(this.myContext.get(classRepr.getShortName()), classRepr.name);
                    }
                    TIntHashSet superClasses = new TIntHashSet();
                    final IntIntTransientMultiMaplet intIntTransientMultiMaplet = delta.getAddedSuperClasses();
                    final IntIntTransientMultiMaplet removedSuperClasses = delta.getRemovedSuperClasses();
                    Mappings.addAllKeys(superClasses, intIntTransientMultiMaplet);
                    Mappings.addAllKeys(superClasses, removedSuperClasses);
                    superClasses.forEach(new TIntProcedure(){

                        public boolean execute(int superClass) {
                            TIntHashSet added = intIntTransientMultiMaplet.get(superClass);
                            TIntHashSet removed = removedSuperClasses.get(superClass);
                            TIntHashSet old = Mappings.this.myClassToSubclasses.get(superClass);
                            if (old == null) {
                                if (added != null && !added.isEmpty()) {
                                    Mappings.this.myClassToSubclasses.replace(superClass, added);
                                }
                            } else {
                                int[] addedAsArray;
                                boolean changed = false;
                                int[] nArray = addedAsArray = added != null && !added.isEmpty() ? added.toArray() : null;
                                if (removed != null && !removed.isEmpty()) {
                                    if (addedAsArray != null) {
                                        removed = (TIntHashSet)removed.clone();
                                        removed.removeAll(addedAsArray);
                                    }
                                    if (!removed.isEmpty()) {
                                        changed = old.removeAll(removed.toArray());
                                    }
                                }
                                if (addedAsArray != null) {
                                    changed |= old.addAll(addedAsArray);
                                }
                                if (changed) {
                                    Mappings.this.myClassToSubclasses.replace(superClass, old);
                                }
                            }
                            return true;
                        }
                    });
                    delta.getChangedClasses().forEach(new TIntProcedure(){

                        public boolean execute(int className) {
                            Collection sourceFiles = delta.myClassToSourceFile.get(className);
                            Mappings.this.myClassToSourceFile.replace(className, sourceFiles);
                            Mappings.this.cleanupBackDependency(className, null, dependenciesTrashBin);
                            return true;
                        }
                    });
                    delta.getChangedFiles().forEach((TObjectProcedure)new TObjectProcedure<File>(){

                        public boolean execute(File fileName) {
                            Collection classes = delta.mySourceFileToClasses.get(fileName);
                            Mappings.this.mySourceFileToClasses.replace(fileName, classes);
                            return true;
                        }
                    });
                } else {
                    this.myClassToSubclasses.putAll(delta.myClassToSubclasses);
                    this.myClassToSourceFile.replaceAll(delta.myClassToSourceFile);
                    this.mySourceFileToClasses.replaceAll(delta.mySourceFileToClasses);
                    delta.mySourceFileToClasses.forEachEntry(new TObjectObjectProcedure<File, Collection<ClassRepr>>(){

                        public boolean execute(File src, Collection<ClassRepr> classes) {
                            for (ClassRepr repr : classes) {
                                if (repr.isAnonymous() || repr.isLocal()) continue;
                                Mappings.this.myShortClassNameIndex.put(Mappings.this.myContext.get(repr.getShortName()), repr.name);
                            }
                            return true;
                        }
                    });
                }
                TIntHashSet affectedClasses = new TIntHashSet();
                Mappings.addAllKeys(affectedClasses, dependenciesTrashBin);
                Mappings.addAllKeys(affectedClasses, delta.myClassToClassDependency);
                affectedClasses.forEach(new TIntProcedure(){

                    public boolean execute(int aClass) {
                        boolean hasDataToAdd;
                        TIntHashSet now = delta.myClassToClassDependency.get(aClass);
                        TIntHashSet toRemove = dependenciesTrashBin.get(aClass);
                        boolean bl = hasDataToAdd = now != null && !now.isEmpty();
                        if (toRemove != null && !toRemove.isEmpty()) {
                            TIntHashSet current = Mappings.this.myClassToClassDependency.get(aClass);
                            if (current != null && !current.isEmpty()) {
                                boolean added;
                                TIntHashSet before = new TIntHashSet();
                                Mappings.addAll(before, current);
                                boolean removed = current.removeAll(toRemove.toArray());
                                boolean bl2 = added = hasDataToAdd && current.addAll(now.toArray());
                                if (removed && !added || !removed && added || !before.equals((Object)current)) {
                                    Mappings.this.myClassToClassDependency.replace(aClass, current);
                                }
                            } else if (hasDataToAdd) {
                                Mappings.this.myClassToClassDependency.put(aClass, now);
                            }
                        } else if (hasDataToAdd) {
                            Mappings.this.myClassToClassDependency.put(aClass, now);
                        }
                        return true;
                    }
                });
            }
            finally {
                delta.close();
            }
        }
    }

    public Callbacks.Backend getCallback() {
        return new Callbacks.Backend(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void associate(String classFileName, Collection<String> sources, ClassReader cr) {
                Object object = Mappings.this.myLock;
                synchronized (object) {
                    int classFileNameS = Mappings.this.myContext.get(classFileName);
                    Pair<ClassRepr, Set<UsageRepr.Usage>> result = new ClassfileAnalyzer(Mappings.this.myContext).analyze(classFileNameS, cr);
                    ClassRepr repr = (ClassRepr)result.first;
                    if (repr != null) {
                        Set localUsages = (Set)result.second;
                        int className = repr.name;
                        for (String sourceFileName : sources) {
                            File sourceFile = new File(sourceFileName);
                            Mappings.this.myClassToSourceFile.put(className, sourceFile);
                            Mappings.this.mySourceFileToClasses.put(sourceFile, repr);
                        }
                        for (int s : repr.getSupers()) {
                            Mappings.this.myClassToSubclasses.put(s, className);
                        }
                        for (UsageRepr.Usage u : localUsages) {
                            int owner = u.getOwner();
                            if (owner == className) continue;
                            Mappings.this.myClassToClassDependency.put(owner, className);
                        }
                    }
                }
            }

            @Override
            public void associate(String classFileName, String sourceFileName, ClassReader cr) {
                this.associate(classFileName, Collections.singleton(sourceFileName), cr);
            }

            @Override
            public void registerImports(final String className, Collection<String> imports, Collection<String> staticImports) {
                final ArrayList<String> allImports = new ArrayList<String>();
                for (String anImport : imports) {
                    if (anImport.endsWith("*")) continue;
                    allImports.add(anImport);
                }
                for (String s : staticImports) {
                    int i = s.length() - 1;
                    while (s.charAt(i) != '.') {
                        --i;
                    }
                    String anImport = s.substring(0, i);
                    if (anImport.endsWith("*")) continue;
                    allImports.add(anImport);
                }
                if (!allImports.isEmpty()) {
                    Mappings.this.myPostPasses.offer(new Runnable(){

                        @Override
                        public void run() {
                            int rootClassName = Mappings.this.myContext.get(className.replace(".", "/"));
                            Collection fileNames = Mappings.this.myClassToSourceFile.get(rootClassName);
                            ClassRepr repr = fileNames != null && !fileNames.isEmpty() ? Mappings.this.getReprByName((File)fileNames.iterator().next(), rootClassName) : null;
                            for (String i : allImports) {
                                int iname = Mappings.this.myContext.get(i.replace('.', '/'));
                                Mappings.this.myClassToClassDependency.put(iname, rootClassName);
                                if (repr == null || !repr.addUsage(UsageRepr.createClassUsage(Mappings.this.myContext, iname))) continue;
                                for (File fileName : fileNames) {
                                    Mappings.this.mySourceFileToClasses.put(fileName, repr);
                                }
                            }
                        }
                    });
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Set<ClassRepr> getClasses(String sourceFileName) {
        Object object = this.myLock;
        synchronized (object) {
            return (Set)this.mySourceFileToClasses.get(new File(sourceFileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.myLock;
        synchronized (object) {
            this.myClassToSubclasses.close();
            this.myClassToClassDependency.close();
            this.mySourceFileToClasses.close();
            this.myClassToSourceFile.close();
            if (!this.myIsDelta) {
                this.myShortClassNameIndex.close();
                DependencyContext context = this.myContext;
                if (context != null) {
                    context.close();
                    this.myContext = null;
                }
            } else if (!this.myDeltaIsTransient) {
                FileUtil.delete((File)this.myRootDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean memoryCachesOnly) {
        Object object = this.myLock;
        synchronized (object) {
            this.myClassToSubclasses.flush(memoryCachesOnly);
            this.myClassToClassDependency.flush(memoryCachesOnly);
            this.mySourceFileToClasses.flush(memoryCachesOnly);
            this.myClassToSourceFile.flush(memoryCachesOnly);
            if (!this.myIsDelta) {
                this.myShortClassNameIndex.flush(memoryCachesOnly);
                DependencyContext context = this.myContext;
                if (context != null) {
                    context.clearMemoryCaches();
                    if (!memoryCachesOnly) {
                        context.flush();
                    }
                }
            }
        }
    }

    private static boolean addAll(final TIntHashSet whereToAdd, TIntHashSet whatToAdd) {
        if (whatToAdd.isEmpty()) {
            return false;
        }
        final Ref changed = new Ref((Object)Boolean.FALSE);
        whatToAdd.forEach(new TIntProcedure(){

            public boolean execute(int value) {
                if (whereToAdd.add(value)) {
                    changed.set((Object)Boolean.TRUE);
                }
                return true;
            }
        });
        return (Boolean)changed.get();
    }

    private static void addAllKeys(final TIntHashSet whereToAdd, IntIntMultiMaplet maplet) {
        maplet.forEachEntry(new TIntObjectProcedure<TIntHashSet>(){

            public boolean execute(int key, TIntHashSet b) {
                whereToAdd.add(key);
                return true;
            }
        });
    }

    private void registerAddedSuperClass(int aClass, int superClass) {
        assert (this.myAddedSuperClasses != null);
        this.myAddedSuperClasses.put(superClass, aClass);
    }

    private void registerRemovedSuperClass(int aClass, int superClass) {
        assert (this.myRemovedSuperClasses != null);
        this.myRemovedSuperClasses.put(superClass, aClass);
    }

    private boolean isDifferentiated() {
        return this.myIsDifferentiated;
    }

    private boolean isRebuild() {
        return this.myIsRebuild;
    }

    private void addDeletedClass(ClassRepr cr, File fileName) {
        assert (this.myDeletedClasses != null);
        this.myDeletedClasses.add((Pair<ClassRepr, File>)Pair.create((Object)cr, (Object)fileName));
        this.addChangedClass(cr.name);
    }

    private void addAddedClass(ClassRepr cr) {
        assert (this.myAddedClasses != null);
        this.myAddedClasses.add(cr);
        this.addChangedClass(cr.name);
    }

    private void addChangedClass(int it) {
        assert (this.myChangedClasses != null && this.myChangedFiles != null);
        this.myChangedClasses.add(it);
        Collection<File> files = this.myClassToSourceFile.get(it);
        if (files != null) {
            this.myChangedFiles.addAll(files);
        }
    }

    @NotNull
    private Set<Pair<ClassRepr, File>> getDeletedClasses() {
        Set<Pair<ClassRepr, File>> set = this.myDeletedClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(this.myDeletedClasses);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/Mappings", "getDeletedClasses"));
        }
        return set;
    }

    @NotNull
    private Set<ClassRepr> getAddedClasses() {
        Set<ClassRepr> set = this.myAddedClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(this.myAddedClasses);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/Mappings", "getAddedClasses"));
        }
        return set;
    }

    private TIntHashSet getChangedClasses() {
        return this.myChangedClasses;
    }

    private THashSet<File> getChangedFiles() {
        return this.myChangedFiles;
    }

    private static void debug(String s) {
        LOG.debug(s);
    }

    private void debug(String comment, int s) {
        this.myDebugS.debug(comment, s);
    }

    private void debug(String comment, File f) {
        this.debug(comment, f.getPath());
    }

    private void debug(String comment, String s) {
        this.myDebugS.debug(comment, s);
    }

    private void debug(String comment, boolean s) {
        this.myDebugS.debug(comment, s);
    }

    public void toStream(PrintStream stream) {
        Streamable[] data = new Streamable[]{this.myClassToSubclasses, this.myClassToClassDependency, this.mySourceFileToClasses, this.myClassToSourceFile};
        String[] info = new String[]{"ClassToSubclasses", "ClassToClassDependency", "SourceFileToClasses", "ClassToSourceFile", "SourceFileToAnnotationUsages", "SourceFileToUsages"};
        for (int i = 0; i < data.length; ++i) {
            stream.print("Begin Of ");
            stream.println(info[i]);
            data[i].toStream(this.myContext, stream);
            stream.print("End Of ");
            stream.println(info[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toStream(File outputRoot) {
        Streamable[] data = new Streamable[]{this.myClassToSubclasses, this.myClassToClassDependency, this.mySourceFileToClasses, this.myClassToSourceFile, this.myShortClassNameIndex};
        String[] info = new String[]{"ClassToSubclasses", "ClassToClassDependency", "SourceFileToClasses", "ClassToSourceFile", "ShortClassNameIndex"};
        for (int i = 0; i < data.length; ++i) {
            File file = new File(outputRoot, info[i]);
            FileUtil.createIfDoesntExist((File)file);
            try {
                PrintStream stream = new PrintStream(file);
                try {
                    data[i].toStream(this.myContext, stream);
                    continue;
                }
                finally {
                    stream.close();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private class Differential {
        private static final int DESPERATE_MASK = 16;
        final Mappings myDelta;
        final Collection<File> myFilesToCompile;
        final Collection<File> myCompiledFiles;
        final Collection<File> myAffectedFiles;
        @Nullable
        final DependentFilesFilter myFilter;
        @Nullable
        final Callbacks.ConstantAffectionResolver myConstantSearch;
        final DelayedWorks myDelayedWorks;
        final Util myFuture;
        final Util myPresent;
        final boolean myEasyMode;

        private Differential(Mappings delta) {
            this.myDelta = delta;
            this.myFilesToCompile = null;
            this.myCompiledFiles = null;
            this.myAffectedFiles = null;
            this.myFilter = null;
            this.myConstantSearch = null;
            this.myDelayedWorks = null;
            this.myFuture = null;
            this.myPresent = null;
            this.myEasyMode = true;
            delta.myIsRebuild = true;
        }

        private Differential(Mappings delta, Collection<String> removed, Collection<File> filesToCompile) {
            delta.myRemovedFiles = removed;
            this.myDelta = delta;
            this.myFilesToCompile = filesToCompile;
            this.myCompiledFiles = null;
            this.myAffectedFiles = null;
            this.myFilter = null;
            this.myConstantSearch = null;
            this.myDelayedWorks = null;
            this.myFuture = new Util(delta);
            this.myPresent = new Util();
            this.myEasyMode = true;
        }

        private Differential(Mappings delta, Collection<String> removed, Collection<File> filesToCompile, Collection<File> compiledFiles, @NotNull Collection<File> affectedFiles, @Nullable DependentFilesFilter filter, Callbacks.ConstantAffectionResolver constantSearch) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Differential", "<init>"));
            }
            delta.myRemovedFiles = removed;
            this.myDelta = delta;
            this.myFilesToCompile = filesToCompile;
            this.myCompiledFiles = compiledFiles;
            this.myAffectedFiles = affectedFiles;
            this.myFilter = filter;
            this.myConstantSearch = constantSearch;
            this.myDelayedWorks = new DelayedWorks();
            this.myFuture = new Util(delta);
            this.myPresent = new Util();
            this.myEasyMode = false;
        }

        private void processDisappearedClasses() {
            Collection removed;
            this.myDelta.compensateRemovedContent(this.myFilesToCompile);
            if (!this.myEasyMode && (removed = this.myDelta.myRemovedFiles) != null) {
                for (String file : removed) {
                    File sourceFile = new File(file);
                    Collection classes = Mappings.this.mySourceFileToClasses.get(sourceFile);
                    if (classes == null) continue;
                    for (ClassRepr c : classes) {
                        Mappings.this.debug("Affecting usages of removed class ", c.name);
                        Mappings.this.affectAll(c.name, sourceFile, this.myAffectedFiles, this.myFilter);
                    }
                }
            }
        }

        private void processAddedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<MethodRepr> added = diff.methods().added();
            if (added.isEmpty()) {
                return;
            }
            Mappings.debug("Processing added methods: ");
            if (it.isAnnotation()) {
                Mappings.debug("Class is annotation, skipping method analysis");
                return;
            }
            Ref oldItRef = null;
            for (final MethodRepr m : added) {
                Mappings.this.debug("Method: ", m.name);
                if (it.isInterface() || it.isAbstract() || m.isAbstract()) {
                    Mappings.debug("Class is abstract, or is interface, or added method in abstract => affecting all subclasses");
                    this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles);
                }
                TIntHashSet propagated = null;
                if (!m.isPrivate() && m.name != Mappings.this.myInitName) {
                    ClassRepr oldIt;
                    if (oldItRef == null) {
                        oldItRef = new Ref((Object)Mappings.this.getReprByName(null, it.name));
                    }
                    if (!((oldIt = (ClassRepr)oldItRef.get()) != null && this.myPresent.hasOverriddenMethods(oldIt, MethodRepr.equalByJavaRules(m)) || m.myArgumentTypes.length <= 0)) {
                        propagated = this.myFuture.propagateMethodAccess(m, it.name);
                        Mappings.debug("Conservative case on overriding methods, affecting method usages");
                        this.myFuture.affectMethodUsages(m, propagated, m.createMetaUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                    }
                }
                if (m.isPrivate()) continue;
                Collection affectedMethods = this.myFuture.findAllMethodsBySpecificity(m, it);
                MethodRepr.Predicate overrides = MethodRepr.equalByJavaRules(m);
                if (propagated == null) {
                    propagated = this.myFuture.propagateMethodAccess(m, it.name);
                }
                Collection<MethodRepr> lessSpecific = it.findMethods(this.myFuture.lessSpecific(m));
                for (MethodRepr mm : lessSpecific) {
                    if (mm.equals(m)) continue;
                    Mappings.debug("Found less specific method, affecting method usages");
                    this.myFuture.affectMethodUsages(mm, propagated, mm.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                }
                Mappings.debug("Processing affected by specificity methods");
                for (Pair pair : affectedMethods) {
                    MethodRepr method = (MethodRepr)pair.first;
                    ClassRepr methodClass = (ClassRepr)pair.second;
                    if (methodClass == MOCK_CLASS) continue;
                    Boolean inheritorOf = this.myPresent.isInheritorOf(methodClass.name, it.name);
                    boolean isInheritor = inheritorOf != null && inheritorOf != false;
                    Mappings.this.debug("Method: ", method.name);
                    Mappings.this.debug("Class : ", methodClass.name);
                    if (overrides.satisfy(method) && isInheritor) {
                        Mappings.debug("Current method overrides that found");
                        Collection files = Mappings.this.myClassToSourceFile.get(methodClass.name);
                        if (files == null) continue;
                        this.myAffectedFiles.addAll(files);
                        for (File file : files) {
                            Mappings.this.debug("Affecting file ", file);
                        }
                        continue;
                    }
                    Mappings.debug("Current method does not override that found");
                    TIntHashSet yetPropagated = this.myPresent.propagateMethodAccess(method, it.name);
                    if (isInheritor) {
                        TIntHashSet deps = Mappings.this.myClassToClassDependency.get(methodClass.name);
                        if (deps != null) {
                            Mappings.addAll(state.myDependants, deps);
                        }
                        this.myFuture.affectMethodUsages(method, yetPropagated, method.createUsage(Mappings.this.myContext, methodClass.name), state.myAffectedUsages, state.myDependants);
                    }
                    Mappings.debug("Affecting method usages for that found");
                    this.myFuture.affectMethodUsages(method, yetPropagated, method.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                }
                TIntHashSet subClasses = Mappings.this.getAllSubclasses(it.name);
                subClasses.forEach(new TIntProcedure(){

                    public boolean execute(int subClass) {
                        int outerClass;
                        ClassRepr r = Differential.this.myFuture.reprByName(subClass);
                        if (r == null) {
                            return true;
                        }
                        Collection sourceFileNames = Mappings.this.myClassToSourceFile.get(subClass);
                        if (sourceFileNames != null && !Differential.this.myCompiledFiles.containsAll(sourceFileNames) && !Mappings.this.isEmpty(outerClass = r.getOuterClassName()) && Differential.this.myFuture.isMethodVisible(outerClass, m)) {
                            Differential.this.myAffectedFiles.addAll(sourceFileNames);
                            for (File sourceFileName : sourceFileNames) {
                                Mappings.this.debug("Affecting file due to local overriding: ", sourceFileName);
                            }
                        }
                        return true;
                    }
                });
            }
            Mappings.debug("End of added methods processing");
        }

        private void processRemovedMethods(DiffState state, ClassRepr.Diff diff, final ClassRepr it) {
            Collection<MethodRepr> removed = diff.methods().removed();
            if (removed.isEmpty()) {
                return;
            }
            Mappings.debug("Processing removed methods:");
            for (final MethodRepr m : removed) {
                Mappings.this.debug("Method ", m.name);
                final Collection overridenMethods = this.myFuture.findOverriddenMethods(m, it);
                TIntHashSet propagated = this.myFuture.propagateMethodAccess(m, it.name);
                if (overridenMethods.size() == 0) {
                    Mappings.debug("No overridden methods found, affecting method usages");
                    this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                } else {
                    boolean clear = true;
                    for (Pair overriden : overridenMethods) {
                        MethodRepr mm = (MethodRepr)overriden.first;
                        if (mm != MOCK_METHOD && mm.myType.equals(m.myType) && Mappings.this.isEmpty(mm.signature) && Mappings.this.isEmpty(m.signature) && !m.isMoreAccessibleThan(mm)) continue;
                        clear = false;
                        break;
                    }
                    if (!clear) {
                        Mappings.debug("No clearly overridden methods found, affecting method usages");
                        this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                    }
                }
                HashSet overridingMethods = new HashSet();
                this.myFuture.addOverridingMethods(m, it, MethodRepr.equalByJavaRules(m), overridingMethods);
                for (Pair p : overridingMethods) {
                    Collection fNames = Mappings.this.myClassToSourceFile.get(((ClassRepr)p.second).name);
                    if (fNames == null) continue;
                    this.myAffectedFiles.addAll(fNames);
                    for (File fName : fNames) {
                        Mappings.this.debug("Affecting file by overriding: ", fName);
                    }
                }
                if (m.isAbstract()) continue;
                propagated.forEach(new TIntProcedure(){

                    public boolean execute(int p) {
                        ClassRepr s;
                        if (p != it.name && (s = Differential.this.myFuture.reprByName(p)) != null) {
                            Collection sources;
                            Collection overridenInS = Differential.this.myFuture.findOverriddenMethods(m, s);
                            overridenInS.addAll(overridenMethods);
                            boolean allAbstract = true;
                            boolean visited = false;
                            for (Pair pp : overridenInS) {
                                ClassRepr cc = (ClassRepr)pp.second;
                                if (cc == MOCK_CLASS) {
                                    visited = true;
                                    continue;
                                }
                                if (cc.name == it.name) continue;
                                visited = true;
                                allAbstract = ((MethodRepr)pp.first).isAbstract() || cc.isInterface();
                                if (allAbstract) continue;
                                break;
                            }
                            if (allAbstract && visited && (sources = Mappings.this.myClassToSourceFile.get(p)) != null && !Differential.this.myCompiledFiles.containsAll(sources)) {
                                Differential.this.myAffectedFiles.addAll(sources);
                                Mappings.this.debug("Removed method is not abstract & overrides some abstract method which is not then over-overridden in subclass ", p);
                                for (File source : sources) {
                                    Mappings.this.debug("Affecting subclass source file ", source);
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            Mappings.debug("End of removed methods processing");
        }

        private void processChangedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<Pair<MethodRepr, Difference>> changed = diff.methods().changed();
            if (changed.isEmpty()) {
                return;
            }
            Mappings.debug("Processing changed methods:");
            for (Pair<MethodRepr, Difference> mr : changed) {
                MethodRepr m = (MethodRepr)mr.first;
                MethodRepr.Diff d = (MethodRepr.Diff)mr.second;
                boolean throwsChanged = !d.exceptions().unchanged();
                Mappings.this.debug("Method: ", m.name);
                if (it.isAnnotation()) {
                    if (!d.defaultRemoved()) continue;
                    Mappings.debug("Class is annotation, default value is removed => adding annotation query");
                    TIntHashSet l = new TIntHashSet(32, 0.98f);
                    l.add(m.name);
                    UsageRepr.AnnotationUsage annotationUsage = (UsageRepr.AnnotationUsage)UsageRepr.createAnnotationUsage(Mappings.this.myContext, TypeRepr.createClassType(Mappings.this.myContext, it.name), l, null);
                    state.myAnnotationQuery.add(annotationUsage);
                    continue;
                }
                if (d.base() == 0 && !throwsChanged) continue;
                TIntHashSet propagated = this.myFuture.propagateMethodAccess(m, it.name);
                boolean affected = false;
                boolean constrained = false;
                HashSet<UsageRepr.Usage> usages = new HashSet<UsageRepr.Usage>();
                if (d.packageLocalOn()) {
                    Mappings.debug("Method became package-local, affecting method usages outside the package");
                    this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                    for (UsageRepr.Usage usage : usages) {
                        Map<UsageRepr.Usage, Util.UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        util.getClass();
                        map.put(usage, util.new Util.InheritanceConstraint(it.name));
                    }
                    state.myAffectedUsages.addAll(usages);
                    affected = true;
                    constrained = true;
                }
                if ((d.base() & 2) > 0 || (d.base() & 8) > 0 || throwsChanged) {
                    if (affected) continue;
                    Mappings.debug("Return type, throws list or signature changed --- affecting method usages");
                    this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                    LinkedList overridingMethods = new LinkedList();
                    this.myFuture.addOverridingMethods(m, it, MethodRepr.equalByJavaRules(m), overridingMethods);
                    for (Pair p : overridingMethods) {
                        Collection fileNames;
                        ClassRepr aClass = (ClassRepr)p.getSecond();
                        if (aClass == MOCK_CLASS || (fileNames = Mappings.this.myClassToSourceFile.get(aClass.name)) == null) continue;
                        this.myAffectedFiles.addAll(fileNames);
                    }
                    state.myAffectedUsages.addAll(usages);
                    continue;
                }
                if ((d.base() & 1) <= 0) continue;
                if ((d.addedModifiers() & 8) > 0 || (d.removedModifiers() & 8) > 0 || (d.addedModifiers() & 2) > 0) {
                    if (!affected) {
                        Mappings.debug("Added static or private specifier or removed static specifier --- affecting method usages");
                        this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                        state.myAffectedUsages.addAll(usages);
                    }
                    if ((d.addedModifiers() & 8) <= 0) continue;
                    Mappings.debug("Added static specifier --- affecting subclasses");
                    this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles);
                    continue;
                }
                if ((d.addedModifiers() & 0x10) > 0 || (d.addedModifiers() & 1) > 0 || (d.addedModifiers() & 0x400) > 0) {
                    Mappings.debug("Added final, public or abstract specifier --- affecting subclasses");
                    this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles);
                }
                if ((d.addedModifiers() & 4) <= 0 || (d.removedModifiers() & 2) > 0 || constrained) continue;
                Mappings.debug("Added public or package-local method became protected --- affect method usages with protected constraint");
                if (!affected) {
                    this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                    state.myAffectedUsages.addAll(usages);
                }
                for (UsageRepr.Usage usage : usages) {
                    Map<UsageRepr.Usage, Util.UsageConstraint> map = state.myUsageConstraints;
                    Util util = this.myFuture;
                    util.getClass();
                    map.put(usage, util.new Util.InheritanceConstraint(it.name));
                }
            }
            Mappings.debug("End of changed methods processing");
        }

        private boolean processAddedFields(final DiffState state, ClassRepr.Diff diff, ClassRepr classRepr) {
            Collection<FieldRepr> added = diff.fields().added();
            if (added.isEmpty()) {
                return true;
            }
            Mappings.debug("Processing added fields");
            for (final FieldRepr f : added) {
                Mappings.this.debug("Field: ", f.name);
                if (!f.isPrivate()) {
                    TIntHashSet subClasses = Mappings.this.getAllSubclasses(classRepr.name);
                    subClasses.forEach(new TIntProcedure(){

                        public boolean execute(int subClass) {
                            Collection sourceFileNames;
                            ClassRepr r = Differential.this.myFuture.reprByName(subClass);
                            if (r != null && (sourceFileNames = Mappings.this.myClassToSourceFile.get(subClass)) != null && !Differential.this.myCompiledFiles.containsAll(sourceFileNames)) {
                                if (r.isLocal()) {
                                    for (File sourceFileName : sourceFileNames) {
                                        Mappings.this.debug("Affecting local subclass (introduced field can potentially hide surrounding method parameters/local variables): ", sourceFileName);
                                    }
                                    Differential.this.myAffectedFiles.addAll(sourceFileNames);
                                } else {
                                    int outerClass = r.getOuterClassName();
                                    if (!Mappings.this.isEmpty(outerClass) && Differential.this.myFuture.isFieldVisible(outerClass, f)) {
                                        for (File sourceFileName : sourceFileNames) {
                                            Mappings.this.debug("Affecting inner subclass (introduced field can potentially hide surrounding class fields): ", sourceFileName);
                                        }
                                        Differential.this.myAffectedFiles.addAll(sourceFileNames);
                                    }
                                }
                            }
                            Mappings.this.debug("Affecting field usages referenced from subclass ", subClass);
                            TIntHashSet propagated = Differential.this.myFuture.propagateFieldAccess(f.name, subClass);
                            Differential.this.myFuture.affectFieldUsages(f, propagated, f.createUsage(Mappings.this.myContext, subClass), state.myAffectedUsages, state.myDependants);
                            TIntHashSet deps = Mappings.this.myClassToClassDependency.get(subClass);
                            if (deps != null) {
                                Mappings.addAll(state.myDependants, deps);
                            }
                            return true;
                        }
                    });
                }
                HashSet<Pair<FieldRepr, ClassRepr>> overriddenFields = new HashSet<Pair<FieldRepr, ClassRepr>>();
                this.myFuture.addOverriddenFields(f, classRepr, overriddenFields);
                for (Pair pair : overriddenFields) {
                    FieldRepr ff = (FieldRepr)pair.first;
                    ClassRepr cc = (ClassRepr)pair.second;
                    if (ff.isPrivate()) continue;
                    TIntHashSet propagated = this.myPresent.propagateFieldAccess(ff.name, cc.name);
                    HashSet<UsageRepr.Usage> localUsages = new HashSet<UsageRepr.Usage>();
                    Mappings.this.debug("Affecting usages of overridden field in class ", cc.name);
                    this.myFuture.affectFieldUsages(ff, propagated, ff.createUsage(Mappings.this.myContext, cc.name), localUsages, state.myDependants);
                    if (!(f.isPrivate() || f.isPublic() && (ff.isPublic() || ff.isPackageLocal()) || f.isProtected() && ff.isProtected() || f.isPackageLocal() && ff.isPackageLocal())) {
                        Util.UsageConstraint constaint;
                        if (ff.isProtected() && f.isPublic() || f.isProtected() && ff.isPublic() || ff.isPackageLocal() && f.isProtected()) {
                            Util util = this.myFuture;
                            util.getClass();
                            Util util2 = this.myFuture;
                            util2.getClass();
                            constaint = util.new Util.NegationConstraint(util2.new Util.InheritanceConstraint(cc.name));
                        } else if (ff.isPublic() && ff.isPackageLocal()) {
                            Util util = this.myFuture;
                            util.getClass();
                            Util util3 = this.myFuture;
                            util3.getClass();
                            constaint = util.new Util.NegationConstraint(util3.new Util.PackageConstraint(cc.getPackageName()));
                        } else {
                            Util util = this.myFuture;
                            util.getClass();
                            Util util4 = this.myFuture;
                            util4.getClass();
                            Util util5 = this.myFuture;
                            util5.getClass();
                            Util.NegationConstraint negationConstraint = util4.new Util.NegationConstraint(util5.new Util.InheritanceConstraint(cc.name));
                            Util util6 = this.myFuture;
                            util6.getClass();
                            Util util7 = this.myFuture;
                            util7.getClass();
                            constaint = util.new Util.IntersectionConstraint(negationConstraint, util6.new Util.NegationConstraint(util7.new Util.PackageConstraint(cc.getPackageName())));
                        }
                        for (UsageRepr.Usage usage : localUsages) {
                            state.myUsageConstraints.put(usage, constaint);
                        }
                    }
                    state.myAffectedUsages.addAll(localUsages);
                }
            }
            Mappings.debug("End of added fields processing");
            return true;
        }

        private boolean processRemovedFields(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<FieldRepr> removed = diff.fields().removed();
            if (removed.isEmpty()) {
                return true;
            }
            Mappings.debug("Processing removed fields:");
            for (FieldRepr f : removed) {
                Mappings.this.debug("Field: ", f.name);
                if (!f.isPrivate() && (f.access & 0x10) == 16 && f.hasValue()) {
                    Mappings.debug("Field had value and was (non-private) final static => a switch to non-incremental mode requested");
                    if (this.myConstantSearch != null) {
                        this.myDelayedWorks.addConstantWork(it.name, f, true, false);
                    } else if (!Mappings.this.incrementalDecision(it.name, f, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                        Mappings.debug("End of Differentiate, returning false");
                        return false;
                    }
                }
                TIntHashSet propagated = this.myFuture.propagateFieldAccess(f.name, it.name);
                this.myFuture.affectFieldUsages(f, propagated, f.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
            }
            Mappings.debug("End of removed fields processing");
            return true;
        }

        private boolean processChangedFields(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<Pair<FieldRepr, Difference>> changed = diff.fields().changed();
            if (changed.isEmpty()) {
                return true;
            }
            Mappings.debug("Processing changed fields:");
            for (Pair<FieldRepr, Difference> f : changed) {
                Difference d = (Difference)f.second;
                FieldRepr field = (FieldRepr)f.first;
                Mappings.this.debug("Field: ", field.name);
                if (!field.isPrivate() && (field.access & 0x10) == 16) {
                    boolean valueChanged;
                    int changedModifiers = d.addedModifiers() | d.removedModifiers();
                    boolean harmful = (changedModifiers & 0x18) > 0;
                    boolean accessChanged = (changedModifiers & 7) > 0;
                    boolean bl = valueChanged = (d.base() & 4) > 0 && d.hadValue();
                    if (harmful || valueChanged || accessChanged && !d.weakedAccess()) {
                        Mappings.debug("Inline field changed it's access or value => a switch to non-incremental mode requested");
                        if (this.myConstantSearch != null) {
                            this.myDelayedWorks.addConstantWork(it.name, field, false, accessChanged);
                        } else if (!Mappings.this.incrementalDecision(it.name, field, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                            Mappings.debug("End of Differentiate, returning false");
                            return false;
                        }
                    }
                }
                if (d.base() == 0) continue;
                TIntHashSet propagated = this.myFuture.propagateFieldAccess(field.name, it.name);
                if ((d.base() & 2) > 0 || (d.base() & 8) > 0) {
                    Mappings.debug("Type or signature changed --- affecting field usages");
                    this.myFuture.affectFieldUsages(field, propagated, field.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                    continue;
                }
                if ((d.base() & 1) <= 0) continue;
                if ((d.addedModifiers() & 8) > 0 || (d.removedModifiers() & 8) > 0 || (d.addedModifiers() & 2) > 0 || (d.addedModifiers() & 0x40) > 0) {
                    Mappings.debug("Added/removed static modifier or added private/volatile modifier --- affecting field usages");
                    this.myFuture.affectFieldUsages(field, propagated, field.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                    continue;
                }
                boolean affected = false;
                HashSet<UsageRepr.Usage> usages = new HashSet<UsageRepr.Usage>();
                if ((d.addedModifiers() & 0x10) > 0) {
                    Mappings.debug("Added final modifier --- affecting field assign usages");
                    this.myFuture.affectFieldUsages(field, propagated, field.createAssignUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                    state.myAffectedUsages.addAll(usages);
                    affected = true;
                }
                if ((d.removedModifiers() & 1) <= 0) continue;
                Mappings.debug("Removed public modifier, affecting field usages with appropriate constraint");
                if (!affected) {
                    this.myFuture.affectFieldUsages(field, propagated, field.createUsage(Mappings.this.myContext, it.name), usages, state.myDependants);
                    state.myAffectedUsages.addAll(usages);
                }
                for (UsageRepr.Usage usage : usages) {
                    if ((d.addedModifiers() & 4) > 0) {
                        Map<UsageRepr.Usage, Util.UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        util.getClass();
                        map.put(usage, util.new Util.InheritanceConstraint(it.name));
                        continue;
                    }
                    Map<UsageRepr.Usage, Util.UsageConstraint> map = state.myUsageConstraints;
                    Util util = this.myFuture;
                    util.getClass();
                    map.put(usage, util.new Util.PackageConstraint(it.getPackageName()));
                }
            }
            Mappings.debug("End of changed fields processing");
            return true;
        }

        private boolean processChangedClasses(final DiffState state) {
            Collection<Pair<ClassRepr, Difference>> changedClasses = state.myClassDiff.changed();
            if (!changedClasses.isEmpty()) {
                Mappings.debug("Processing changed classes:");
                for (Pair<ClassRepr, Difference> changed : changedClasses) {
                    boolean signatureChanged;
                    ClassRepr changedClass = (ClassRepr)changed.first;
                    ClassRepr.Diff diff = (ClassRepr.Diff)changed.second;
                    this.myDelta.addChangedClass(changedClass.name);
                    Mappings.this.debug("Changed: ", changedClass.name);
                    int addedModifiers = diff.addedModifiers();
                    boolean superClassChanged = (diff.base() & 0x10) > 0;
                    boolean interfacesChanged = !diff.interfaces().unchanged();
                    boolean bl = signatureChanged = (diff.base() & 8) > 0;
                    if (superClassChanged) {
                        this.myDelta.registerRemovedSuperClass(changedClass.name, changedClass.getSuperClass().className);
                        ClassRepr newClass = this.myDelta.getReprByName(null, changedClass.name);
                        assert (newClass != null);
                        this.myDelta.registerAddedSuperClass(changedClass.name, newClass.getSuperClass().className);
                    }
                    if (interfacesChanged) {
                        for (TypeRepr.AbstractType typ : diff.interfaces().removed()) {
                            this.myDelta.registerRemovedSuperClass(changedClass.name, ((TypeRepr.ClassType)typ).className);
                        }
                        for (TypeRepr.AbstractType typ : diff.interfaces().added()) {
                            this.myDelta.registerAddedSuperClass(changedClass.name, ((TypeRepr.ClassType)typ).className);
                        }
                    }
                    if (this.myEasyMode) continue;
                    this.myPresent.appendDependents(changedClass, state.myDependants);
                    if (superClassChanged || interfacesChanged || signatureChanged) {
                        Mappings.this.debug("Superclass changed: ", superClassChanged);
                        Mappings.this.debug("Interfaces changed: ", interfacesChanged);
                        Mappings.this.debug("Signature changed ", signatureChanged);
                        boolean extendsChanged = superClassChanged && !diff.extendsAdded();
                        boolean interfacesRemoved = interfacesChanged && !diff.interfaces().removed().isEmpty();
                        Mappings.this.debug("Extends changed: ", extendsChanged);
                        Mappings.this.debug("Interfaces removed: ", interfacesRemoved);
                        this.myFuture.affectSubclasses(changedClass.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, extendsChanged || interfacesRemoved || signatureChanged, this.myCompiledFiles);
                        if (!changedClass.isAnonymous()) {
                            TIntHashSet parents = new TIntHashSet();
                            this.myPresent.collectSupersRecursively(changedClass.name, parents);
                            TIntHashSet futureParents = new TIntHashSet();
                            this.myFuture.collectSupersRecursively(changedClass.name, futureParents);
                            parents.removeAll(futureParents.toArray());
                            parents.remove(Mappings.this.myObjectClassName);
                            if (!parents.isEmpty()) {
                                parents.forEach(new TIntProcedure(){

                                    public boolean execute(int className) {
                                        Mappings.this.debug("Affecting usages in generic type parameter bounds of class: ", className);
                                        state.myAffectedUsages.add(UsageRepr.createClassAsGenericBoundUsage(Mappings.this.myContext, className));
                                        TIntHashSet depClasses = Mappings.this.myClassToClassDependency.get(className);
                                        if (depClasses != null) {
                                            Mappings.addAll(state.myDependants, depClasses);
                                        }
                                        return true;
                                    }
                                });
                            }
                        }
                    }
                    if ((diff.addedModifiers() & 0x200) > 0 || (diff.removedModifiers() & 0x200) > 0) {
                        Mappings.debug("Class-to-interface or interface-to-class conversion detected, added class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if (changedClass.isAnnotation() && changedClass.getRetentionPolicy() == RetentionPolicy.SOURCE) {
                        Mappings.debug("Annotation, retention policy = SOURCE => a switch to non-incremental mode requested");
                        if (!Mappings.this.incrementalDecision(changedClass.getOuterClassName(), changedClass, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                            Mappings.debug("End of Differentiate, returning false");
                            return false;
                        }
                    }
                    if ((addedModifiers & 4) > 0) {
                        Mappings.debug("Introduction of 'protected' modifier detected, adding class usage + inheritance constraint to affected usages");
                        UsageRepr.Usage usage = changedClass.createUsage();
                        state.myAffectedUsages.add(usage);
                        Map<UsageRepr.Usage, Util.UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        util.getClass();
                        map.put(usage, util.new Util.InheritanceConstraint(changedClass.name));
                    }
                    if (diff.packageLocalOn()) {
                        Mappings.debug("Introduction of 'package local' access detected, adding class usage + package constraint to affected usages");
                        UsageRepr.Usage usage = changedClass.createUsage();
                        state.myAffectedUsages.add(usage);
                        Map<UsageRepr.Usage, Util.UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        util.getClass();
                        map.put(usage, util.new Util.PackageConstraint(changedClass.getPackageName()));
                    }
                    if ((addedModifiers & 0x10) > 0 || (addedModifiers & 2) > 0) {
                        Mappings.debug("Introduction of 'private' or 'final' modifier(s) detected, adding class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if ((addedModifiers & 0x400) > 0 || (addedModifiers & 8) > 0) {
                        Mappings.debug("Introduction of 'abstract' or 'static' modifier(s) detected, adding class new usage to affected usages");
                        state.myAffectedUsages.add(UsageRepr.createClassNewUsage(Mappings.this.myContext, changedClass.name));
                    }
                    if (changedClass.isAnnotation()) {
                        Mappings.debug("Class is annotation, performing annotation-specific analysis");
                        if (diff.retentionChanged()) {
                            Mappings.debug("Retention policy change detected, adding class usage to affected usages");
                            state.myAffectedUsages.add(changedClass.createUsage());
                        } else {
                            Collection<ElemType> removedtargets = diff.targets().removed();
                            if (removedtargets.contains((Object)ElemType.LOCAL_VARIABLE)) {
                                Mappings.debug("Removed target contains LOCAL_VARIABLE => a switch to non-incremental mode requested");
                                if (!Mappings.this.incrementalDecision(changedClass.getOuterClassName(), changedClass, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                                    Mappings.debug("End of Differentiate, returning false");
                                    return false;
                                }
                            }
                            if (!removedtargets.isEmpty()) {
                                Mappings.debug("Removed some annotation targets, adding annotation query");
                                UsageRepr.AnnotationUsage annotationUsage = (UsageRepr.AnnotationUsage)UsageRepr.createAnnotationUsage(Mappings.this.myContext, TypeRepr.createClassType(Mappings.this.myContext, changedClass.name), null, EnumSet.copyOf(removedtargets));
                                state.myAnnotationQuery.add(annotationUsage);
                            }
                            for (MethodRepr m : diff.methods().added()) {
                                if (m.hasValue()) continue;
                                Mappings.this.debug("Added method with no default value: ", m.name);
                                Mappings.debug("Adding class usage to affected usages");
                                state.myAffectedUsages.add(changedClass.createUsage());
                            }
                        }
                        Mappings.debug("End of annotation-specific analysis");
                    }
                    this.processAddedMethods(state, diff, changedClass);
                    this.processRemovedMethods(state, diff, changedClass);
                    this.processChangedMethods(state, diff, changedClass);
                    if (!this.processAddedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if (!this.processRemovedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if (this.processChangedFields(state, diff, changedClass)) continue;
                    return false;
                }
                Mappings.debug("End of changed classes processing");
            }
            return !this.myEasyMode;
        }

        private void processRemovedClases(DiffState state, @NotNull File fileName) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Differential", "processRemovedClases"));
            }
            Collection<ClassRepr> removed = state.myClassDiff.removed();
            if (removed.isEmpty()) {
                return;
            }
            this.myDelta.myChangedFiles.add((Object)fileName);
            Mappings.debug("Processing removed classes:");
            for (ClassRepr c : removed) {
                this.myDelta.addDeletedClass(c, fileName);
                if (this.myEasyMode) continue;
                this.myPresent.appendDependents(c, state.myDependants);
                Mappings.this.debug("Adding usages of class ", c.name);
                state.myAffectedUsages.add(c.createUsage());
                Mappings.this.debug("Affecting usages of removed class ", c.name);
                Mappings.this.affectAll(c.name, fileName, this.myAffectedFiles, this.myFilter);
            }
            Mappings.debug("End of removed classes processing.");
        }

        private void processAddedClasses(DiffState state, File srcFile) {
            Collection<ClassRepr> addedClasses = state.myClassDiff.added();
            if (addedClasses.isEmpty()) {
                return;
            }
            Mappings.debug("Processing added classes:");
            if (!this.myEasyMode && this.myFilter != null) {
                for (ClassRepr c : addedClasses) {
                    File currentlyMappedTo;
                    if (c.isLocal() || c.isAnonymous() || !Mappings.this.isEmpty(c.getOuterClassName())) continue;
                    Collection currentSources = Mappings.this.myClassToSourceFile.get(c.name);
                    File file = currentlyMappedTo = currentSources != null && currentSources.size() == 1 ? (File)currentSources.iterator().next() : null;
                    if (currentlyMappedTo == null || FileUtil.filesEqual(currentlyMappedTo, (File)srcFile) || !currentlyMappedTo.exists() || !this.myFilter.belongsToCurrentTargetChunk(currentlyMappedTo)) break;
                    Mappings.this.debug("Scheduling for recompilation duplicated sources: ", currentlyMappedTo.getPath() + "; " + srcFile.getPath());
                    this.myAffectedFiles.add(currentlyMappedTo);
                    this.myAffectedFiles.add(srcFile);
                    return;
                }
            }
            for (ClassRepr c : addedClasses) {
                Mappings.this.debug("Class name: ", c.name);
                this.myDelta.addAddedClass(c);
                for (int sup : c.getSupers()) {
                    this.myDelta.registerAddedSuperClass(c.name, sup);
                }
                if (this.myEasyMode || c.isAnonymous() || c.isLocal()) continue;
                TIntHashSet toAffect = new TIntHashSet();
                toAffect.add(c.name);
                TIntHashSet classes = Mappings.this.myShortClassNameIndex.get(Mappings.this.myContext.get(c.getShortName()));
                if (classes != null) {
                    toAffect.addAll(classes.toArray());
                }
                toAffect.forEach(new TIntProcedure(){

                    public boolean execute(int qName) {
                        TIntHashSet depClasses = Mappings.this.myClassToClassDependency.get(qName);
                        if (depClasses != null) {
                            Differential.this.affectCorrespondingSourceFiles(depClasses);
                        }
                        return true;
                    }
                });
            }
            Mappings.debug("End of added classes processing.");
        }

        private void affectCorrespondingSourceFiles(TIntHashSet toAffect) {
            toAffect.forEach(new TIntProcedure(){

                public boolean execute(int depClass) {
                    Collection fNames = Mappings.this.myClassToSourceFile.get(depClass);
                    if (fNames != null) {
                        for (File fName : fNames) {
                            if (Differential.this.myFilter != null && !Differential.this.myFilter.accept(fName)) continue;
                            Mappings.this.debug("Adding dependent file ", fName);
                            Differential.this.myAffectedFiles.add(fName);
                        }
                    }
                    return true;
                }
            });
        }

        private void calculateAffectedFiles(final DiffState state) {
            Mappings.debug("Checking dependent classes:");
            state.myDependants.forEach(new TIntProcedure(){

                public boolean execute(int depClass) {
                    Collection depFiles = Mappings.this.myClassToSourceFile.get(depClass);
                    if (depFiles != null) {
                        for (File depFile : depFiles) {
                            this.processDependentFile(depClass, depFile);
                        }
                    }
                    return true;
                }

                private void processDependentFile(int depClass, @NotNull File depFile) {
                    if (depFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depFile", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Differential$7", "processDependentFile"));
                    }
                    if (Differential.this.myAffectedFiles.contains(depFile) || Differential.this.myCompiledFiles.contains(depFile)) {
                        return;
                    }
                    Mappings.this.debug("Dependent class: ", depClass);
                    ClassRepr classRepr = Mappings.this.getReprByName(depFile, depClass);
                    if (classRepr == null) {
                        return;
                    }
                    Set<UsageRepr.Usage> depUsages = classRepr.getUsages();
                    if (depUsages == null || depUsages.isEmpty()) {
                        return;
                    }
                    for (UsageRepr.Usage usage : depUsages) {
                        if (usage instanceof UsageRepr.AnnotationUsage) {
                            for (UsageRepr.AnnotationUsage query : state.myAnnotationQuery) {
                                if (!query.satisfies(usage)) continue;
                                Mappings.debug("Added file due to annotation query");
                                Differential.this.myAffectedFiles.add(depFile);
                                return;
                            }
                            continue;
                        }
                        if (!state.myAffectedUsages.contains(usage)) continue;
                        Util.UsageConstraint constraint = state.myUsageConstraints.get(usage);
                        if (constraint == null) {
                            Mappings.debug("Added file with no constraints");
                            Differential.this.myAffectedFiles.add(depFile);
                            return;
                        }
                        if (!constraint.checkResidence(depClass)) continue;
                        Mappings.debug("Added file with satisfied constraint");
                        Differential.this.myAffectedFiles.add(depFile);
                        return;
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean differentiate() {
            Object object = Mappings.this.myLock;
            synchronized (object) {
                this.myDelta.myIsDifferentiated = true;
                if (this.myDelta.myIsRebuild) {
                    return true;
                }
                Mappings.debug("Begin of Differentiate:");
                Mappings.this.debug("Easy mode: ", this.myEasyMode);
                this.processDisappearedClasses();
                final ArrayList newClasses = new ArrayList();
                this.myDelta.mySourceFileToClasses.forEachEntry(new TObjectObjectProcedure<File, Collection<ClassRepr>>(){

                    public boolean execute(File fileName, Collection<ClassRepr> classes) {
                        newClasses.add(new FileClasses(fileName, classes));
                        return true;
                    }
                });
                for (FileClasses compiledFile : newClasses) {
                    File fileName = compiledFile.myFileName;
                    Set<ClassRepr> classes = compiledFile.myFileClasses;
                    Set pastClasses = (Set)Mappings.this.mySourceFileToClasses.get(fileName);
                    DiffState state = new DiffState(Difference.make(pastClasses, classes));
                    if (!this.processChangedClasses(state) && !this.myEasyMode) {
                        return false;
                    }
                    this.processRemovedClases(state, fileName);
                    this.processAddedClasses(state, fileName);
                    if (this.myEasyMode) continue;
                    this.calculateAffectedFiles(state);
                }
                Mappings.debug("End of Differentiate.");
                if (this.myEasyMode) {
                    return false;
                }
                Collection removed = this.myDelta.myRemovedFiles;
                if (removed != null) {
                    for (String r : removed) {
                        this.myAffectedFiles.remove(new File(r));
                    }
                }
                return this.myDelayedWorks.doWork(this.myAffectedFiles);
            }
        }

        private class DiffState {
            public final TIntHashSet myDependants = new TIntHashSet(32, 0.98f);
            public final Set<UsageRepr.Usage> myAffectedUsages = new HashSet<UsageRepr.Usage>();
            public final Set<UsageRepr.AnnotationUsage> myAnnotationQuery = new HashSet<UsageRepr.AnnotationUsage>();
            public final Map<UsageRepr.Usage, Util.UsageConstraint> myUsageConstraints = new HashMap<UsageRepr.Usage, Util.UsageConstraint>();
            final Difference.Specifier<ClassRepr> myClassDiff;

            private DiffState(Difference.Specifier<ClassRepr> classDiff) {
                this.myClassDiff = classDiff;
            }
        }

        private class FileClasses {
            final File myFileName;
            final Set<ClassRepr> myFileClasses;

            FileClasses(File fileName, Collection<ClassRepr> fileClasses) {
                this.myFileName = fileName;
                this.myFileClasses = new HashSet<ClassRepr>(fileClasses);
            }
        }

        private class DelayedWorks {
            final Collection<Triple> myQueue = new LinkedList<Triple>();

            private DelayedWorks() {
            }

            void addConstantWork(int ownerClass, FieldRepr changedField, boolean isRemoved, boolean accessChanged) {
                Future<Callbacks.ConstantAffection> future;
                if (Differential.this.myConstantSearch == null) {
                    future = null;
                } else {
                    String className = Mappings.this.myContext.getValue(ownerClass);
                    String fieldName = Mappings.this.myContext.getValue(changedField.name);
                    future = Differential.this.myConstantSearch.request(className.replace('/', '.'), fieldName, changedField.access, isRemoved, accessChanged);
                }
                this.myQueue.add(new Triple(ownerClass, changedField, future));
            }

            boolean doWork(@NotNull Collection<File> affectedFiles) {
                if (affectedFiles == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFiles", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Differential$DelayedWorks", "doWork"));
                }
                if (!this.myQueue.isEmpty()) {
                    Mappings.debug("Starting delayed works.");
                    for (Triple t : this.myQueue) {
                        Callbacks.ConstantAffection affection = t.getAffection();
                        Mappings.this.debug("Class: ", t.owner);
                        Mappings.this.debug("Field: ", t.field.name);
                        if (!affection.isKnown()) {
                            if (Differential.this.myConstantSearch != null) {
                                Mappings.debug("No external dependency information available.");
                            } else {
                                Mappings.debug("Constant search service not available.");
                            }
                            Mappings.debug("Trying to soften non-incremental decision.");
                            if (Mappings.this.incrementalDecision(t.owner, t.field, affectedFiles, Differential.this.myFilesToCompile, Differential.this.myFilter)) continue;
                            Mappings.debug("No luck.");
                            Mappings.debug("End of delayed work, returning false.");
                            return false;
                        }
                        Mappings.debug("External dependency information retrieved.");
                        Collection<File> files = affection.getAffectedFiles();
                        if (Differential.this.myFilter == null) {
                            affectedFiles.addAll(files);
                            continue;
                        }
                        for (File file : files) {
                            if (!Differential.this.myFilter.accept(file)) continue;
                            affectedFiles.add(file);
                        }
                    }
                    Mappings.debug("End of delayed work, returning true.");
                }
                return true;
            }

            class Triple {
                final int owner;
                final FieldRepr field;
                @Nullable
                final Future<Callbacks.ConstantAffection> affection;

                private Triple(int owner, @Nullable FieldRepr field, Future<Callbacks.ConstantAffection> affection) {
                    this.owner = owner;
                    this.field = field;
                    this.affection = affection;
                }

                Callbacks.ConstantAffection getAffection() {
                    try {
                        return this.affection != null ? this.affection.get() : Callbacks.ConstantAffection.EMPTY;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static interface DependentFilesFilter {
        public static final DependentFilesFilter ALL_FILES = new DependentFilesFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }

            @Override
            public boolean belongsToCurrentTargetChunk(File file) {
                return true;
            }
        };

        public boolean accept(File var1);

        public boolean belongsToCurrentTargetChunk(File var1);
    }

    private class Util {
        @Nullable
        private final Mappings myMappings;

        private Util() {
            this.myMappings = null;
        }

        private Util(Mappings mappings2) {
            if (mappings2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Util", "<init>"));
            }
            this.myMappings = mappings2;
        }

        void appendDependents(ClassRepr c, TIntHashSet result) {
            TIntHashSet depClasses = Mappings.this.myClassToClassDependency.get(c.name);
            if (depClasses != null) {
                Mappings.addAll(result, depClasses);
            }
        }

        void propagateMemberAccessRec(final TIntHashSet acc, final boolean isField, boolean root, final MemberComparator comparator, int reflcass) {
            ClassRepr repr = this.reprByName(reflcass);
            if (repr != null) {
                TIntHashSet subclasses;
                if (!root) {
                    Set<ProtoMember> members = isField ? repr.getFields() : repr.getMethods();
                    for (ProtoMember m : members) {
                        if (!comparator.isSame(m)) continue;
                        return;
                    }
                    acc.add(reflcass);
                }
                if ((subclasses = Mappings.this.myClassToSubclasses.get(reflcass)) != null) {
                    subclasses.forEach(new TIntProcedure(){

                        public boolean execute(int subclass) {
                            Util.this.propagateMemberAccessRec(acc, isField, false, comparator, subclass);
                            return true;
                        }
                    });
                }
            }
        }

        TIntHashSet propagateMemberAccess(boolean isField, MemberComparator comparator, int className) {
            TIntHashSet acc = new TIntHashSet(32, 0.98f);
            this.propagateMemberAccessRec(acc, isField, true, comparator, className);
            return acc;
        }

        TIntHashSet propagateFieldAccess(final int name, int className) {
            return this.propagateMemberAccess(true, new MemberComparator(){

                @Override
                public boolean isSame(ProtoMember member) {
                    return member.name == name;
                }
            }, className);
        }

        TIntHashSet propagateMethodAccess(final MethodRepr m, int className) {
            return this.propagateMemberAccess(false, new MemberComparator(){

                @Override
                public boolean isSame(ProtoMember member) {
                    if (member instanceof MethodRepr) {
                        MethodRepr memberMethod = (MethodRepr)member;
                        return memberMethod.name == m.name && Arrays.equals(memberMethod.myArgumentTypes, m.myArgumentTypes);
                    }
                    return member.name == m.name;
                }
            }, className);
        }

        MethodRepr.Predicate lessSpecific(final MethodRepr than) {
            return new MethodRepr.Predicate(){

                @Override
                public boolean satisfy(MethodRepr m) {
                    if (m.name == Mappings.this.myInitName || m.name != than.name || m.myArgumentTypes.length != than.myArgumentTypes.length) {
                        return false;
                    }
                    for (int i = 0; i < than.myArgumentTypes.length; ++i) {
                        Boolean subtypeOf = Util.this.isSubtypeOf(than.myArgumentTypes[i], m.myArgumentTypes[i]);
                        if (subtypeOf == null || subtypeOf.booleanValue()) continue;
                        return false;
                    }
                    return true;
                }
            };
        }

        private void addOverridingMethods(final MethodRepr m, final ClassRepr fromClass, final MethodRepr.Predicate predicate, final Collection<Pair<MethodRepr, ClassRepr>> container) {
            if (m.name == Mappings.this.myInitName) {
                return;
            }
            TIntHashSet subClasses = Mappings.this.myClassToSubclasses.get(fromClass.name);
            if (subClasses == null) {
                return;
            }
            subClasses.forEach(new TIntProcedure(){

                public boolean execute(int subClassName) {
                    ClassRepr r = Util.this.reprByName(subClassName);
                    if (r != null) {
                        boolean cont = true;
                        Collection<MethodRepr> methods = r.findMethods(predicate);
                        for (MethodRepr mm : methods) {
                            if (!Mappings.isVisibleIn(fromClass, m, r)) continue;
                            container.add(Pair.create((Object)mm, (Object)r));
                            cont = false;
                        }
                        if (cont) {
                            Util.this.addOverridingMethods(m, r, predicate, container);
                        }
                    }
                    return true;
                }
            });
        }

        private Collection<Pair<MethodRepr, ClassRepr>> findAllMethodsBySpecificity(MethodRepr m, ClassRepr c) {
            MethodRepr.Predicate predicate = this.lessSpecific(m);
            HashSet<Pair<MethodRepr, ClassRepr>> result = new HashSet<Pair<MethodRepr, ClassRepr>>();
            this.addOverridenMethods(c, predicate, result);
            this.addOverridingMethods(m, c, predicate, result);
            return result;
        }

        private Collection<Pair<MethodRepr, ClassRepr>> findOverriddenMethods(MethodRepr m, ClassRepr c) {
            if (m.name == Mappings.this.myInitName) {
                return Collections.emptySet();
            }
            HashSet<Pair<MethodRepr, ClassRepr>> result = new HashSet<Pair<MethodRepr, ClassRepr>>();
            this.addOverridenMethods(c, MethodRepr.equalByJavaRules(m), result);
            return result;
        }

        private boolean hasOverriddenMethods(ClassRepr fromClass, MethodRepr.Predicate predicate) {
            for (int superName : fromClass.getSupers()) {
                ClassRepr superClass = this.reprByName(superName);
                if (superClass == null) {
                    return true;
                }
                for (MethodRepr mm : superClass.findMethods(predicate)) {
                    if (!Mappings.isVisibleIn(superClass, mm, fromClass)) continue;
                    return true;
                }
                if (!this.hasOverriddenMethods(superClass, predicate)) continue;
                return true;
            }
            return false;
        }

        private void addOverridenMethods(ClassRepr fromClass, MethodRepr.Predicate predicate, Collection<Pair<MethodRepr, ClassRepr>> container) {
            for (int superName : fromClass.getSupers()) {
                ClassRepr superClass = this.reprByName(superName);
                if (superClass != null) {
                    boolean cont = true;
                    Collection<MethodRepr> methods = superClass.findMethods(predicate);
                    for (MethodRepr mm : methods) {
                        if (!Mappings.isVisibleIn(superClass, mm, fromClass)) continue;
                        container.add((Pair<MethodRepr, ClassRepr>)Pair.create((Object)mm, (Object)superClass));
                        cont = false;
                    }
                    if (!cont) continue;
                    this.addOverridenMethods(superClass, predicate, container);
                    continue;
                }
                container.add((Pair<MethodRepr, ClassRepr>)Pair.create((Object)MOCK_METHOD, (Object)MOCK_CLASS));
            }
        }

        void addOverriddenFields(FieldRepr f, ClassRepr fromClass, Collection<Pair<FieldRepr, ClassRepr>> container) {
            for (int supername : fromClass.getSupers()) {
                ClassRepr superClass = this.reprByName(supername);
                if (superClass == null) continue;
                FieldRepr ff = superClass.findField(f.name);
                if (ff != null && Mappings.isVisibleIn(superClass, ff, fromClass)) {
                    container.add((Pair<FieldRepr, ClassRepr>)Pair.create((Object)ff, (Object)superClass));
                    continue;
                }
                this.addOverriddenFields(f, superClass, container);
            }
        }

        boolean hasOverriddenFields(FieldRepr f, ClassRepr fromClass) {
            for (int supername : fromClass.getSupers()) {
                ClassRepr superClass = this.reprByName(supername);
                if (superClass == null) continue;
                FieldRepr ff = superClass.findField(f.name);
                if (ff != null && Mappings.isVisibleIn(superClass, ff, fromClass)) {
                    return true;
                }
                boolean found = this.hasOverriddenFields(f, superClass);
                if (!found) continue;
                return true;
            }
            return false;
        }

        @Nullable
        ClassRepr reprByName(int name) {
            ClassRepr r;
            if (this.myMappings != null && (r = this.myMappings.getReprByName(null, name)) != null) {
                return r;
            }
            return Mappings.this.getReprByName(null, name);
        }

        @Nullable
        private Boolean isInheritorOf(int who, int whom) {
            if (who == whom) {
                return Boolean.TRUE;
            }
            ClassRepr repr = this.reprByName(who);
            if (repr != null) {
                for (int s : repr.getSupers()) {
                    Boolean inheritorOf = this.isInheritorOf(s, whom);
                    if (inheritorOf == null || !inheritorOf.booleanValue()) continue;
                    return inheritorOf;
                }
            }
            return null;
        }

        @Nullable
        Boolean isSubtypeOf(TypeRepr.AbstractType who, TypeRepr.AbstractType whom) {
            if (who.equals(whom)) {
                return Boolean.TRUE;
            }
            if (who instanceof TypeRepr.PrimitiveType || whom instanceof TypeRepr.PrimitiveType) {
                return Boolean.FALSE;
            }
            if (who instanceof TypeRepr.ArrayType) {
                if (whom instanceof TypeRepr.ArrayType) {
                    return this.isSubtypeOf(((TypeRepr.ArrayType)who).elementType, ((TypeRepr.ArrayType)whom).elementType);
                }
                String descr = whom.getDescr(Mappings.this.myContext);
                if (descr.equals("Ljava/lang/Cloneable") || descr.equals("Ljava/lang/Object") || descr.equals("Ljava/io/Serializable")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (whom instanceof TypeRepr.ClassType) {
                return this.isInheritorOf(((TypeRepr.ClassType)who).className, ((TypeRepr.ClassType)whom).className);
            }
            return Boolean.FALSE;
        }

        boolean isMethodVisible(int className, MethodRepr m) {
            ClassRepr r = this.reprByName(className);
            if (r != null) {
                if (r.findMethods(MethodRepr.equalByJavaRules(m)).size() > 0) {
                    return true;
                }
                return this.hasOverriddenMethods(r, MethodRepr.equalByJavaRules(m));
            }
            return false;
        }

        boolean isFieldVisible(int className, FieldRepr field) {
            ClassRepr r = this.reprByName(className);
            if (r == null || r.getFields().contains(field)) {
                return true;
            }
            return this.hasOverriddenFields(field, r);
        }

        void collectSupersRecursively(@NotNull int className, @NotNull TIntHashSet container) {
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Util", "collectSupersRecursively"));
            }
            ClassRepr classRepr = this.reprByName(className);
            if (classRepr != null) {
                int[] supers = classRepr.getSupers();
                container.addAll(supers);
                for (int aSuper : supers) {
                    this.collectSupersRecursively(aSuper, container);
                }
            }
        }

        void affectSubclasses(int className, final Collection<File> affectedFiles, final Collection<UsageRepr.Usage> affectedUsages, final TIntHashSet dependants, final boolean usages, final Collection<File> alreadyCompiledFiles) {
            TIntHashSet directSubclasses;
            TIntHashSet depClasses;
            Mappings.this.debug("Affecting subclasses of class: ", className);
            Collection allSources = Mappings.this.myClassToSourceFile.get(className);
            if (allSources == null || allSources.isEmpty()) {
                Mappings.this.debug("No source file detected for class ", className);
                Mappings.debug("End of affectSubclasses");
                return;
            }
            for (File fName : allSources) {
                Mappings.this.debug("Source file name: ", fName);
                if (alreadyCompiledFiles.contains(fName)) continue;
                affectedFiles.add(fName);
            }
            if (usages) {
                Mappings.debug("Class usages affection requested");
                ClassRepr classRepr = this.reprByName(className);
                if (classRepr != null) {
                    Mappings.this.debug("Added class usage for ", classRepr.name);
                    affectedUsages.add(classRepr.createUsage());
                }
            }
            if ((depClasses = Mappings.this.myClassToClassDependency.get(className)) != null) {
                Mappings.addAll(dependants, depClasses);
            }
            if ((directSubclasses = Mappings.this.myClassToSubclasses.get(className)) != null) {
                directSubclasses.forEach(new TIntProcedure(){

                    public boolean execute(int subClass) {
                        Util.this.affectSubclasses(subClass, affectedFiles, affectedUsages, dependants, usages, alreadyCompiledFiles);
                        return true;
                    }
                });
            }
        }

        void affectFieldUsages(final FieldRepr field, TIntHashSet classes, final UsageRepr.Usage rootUsage, final Set<UsageRepr.Usage> affectedUsages, final TIntHashSet dependents) {
            affectedUsages.add(rootUsage);
            classes.forEach(new TIntProcedure(){

                public boolean execute(int p) {
                    TIntHashSet deps = Mappings.this.myClassToClassDependency.get(p);
                    if (deps != null) {
                        Mappings.addAll(dependents, deps);
                    }
                    Mappings.this.debug("Affect field usage referenced of class ", p);
                    affectedUsages.add(rootUsage instanceof UsageRepr.FieldAssignUsage ? field.createAssignUsage(Mappings.this.myContext, p) : field.createUsage(Mappings.this.myContext, p));
                    return true;
                }
            });
        }

        void affectMethodUsages(final MethodRepr method, TIntHashSet subclasses, final UsageRepr.Usage rootUsage, final Set<UsageRepr.Usage> affectedUsages, final TIntHashSet dependents) {
            affectedUsages.add(rootUsage);
            if (subclasses != null) {
                subclasses.forEach(new TIntProcedure(){

                    public boolean execute(int p) {
                        TIntHashSet deps = Mappings.this.myClassToClassDependency.get(p);
                        if (deps != null) {
                            Mappings.addAll(dependents, deps);
                        }
                        Mappings.this.debug("Affect method usage referenced of class ", p);
                        UsageRepr.Usage usage = rootUsage instanceof UsageRepr.MetaMethodUsage ? method.createMetaUsage(Mappings.this.myContext, p) : method.createUsage(Mappings.this.myContext, p);
                        affectedUsages.add(usage);
                        return true;
                    }
                });
            }
        }

        public class IntersectionConstraint
        extends UsageConstraint {
            final UsageConstraint x;
            final UsageConstraint y;

            public IntersectionConstraint(UsageConstraint x, UsageConstraint y) {
                this.x = x;
                this.y = y;
            }

            @Override
            public boolean checkResidence(int residence) {
                return this.x.checkResidence(residence) && this.y.checkResidence(residence);
            }
        }

        public class NegationConstraint
        extends UsageConstraint {
            final UsageConstraint x;

            public NegationConstraint(UsageConstraint x) {
                this.x = x;
            }

            @Override
            public boolean checkResidence(int residence) {
                return !this.x.checkResidence(residence);
            }
        }

        public class InheritanceConstraint
        extends PackageConstraint {
            public final int rootClass;

            public InheritanceConstraint(int rootClass) {
                super(ClassRepr.getPackageName(Mappings.this.myContext.getValue(rootClass)));
                this.rootClass = rootClass;
            }

            @Override
            public boolean checkResidence(int residence) {
                Boolean inheritorOf = Util.this.isInheritorOf(residence, this.rootClass);
                return inheritorOf == null || inheritorOf == false || super.checkResidence(residence);
            }
        }

        public class PackageConstraint
        extends UsageConstraint {
            public final String packageName;

            public PackageConstraint(String packageName) {
                this.packageName = packageName;
            }

            @Override
            public boolean checkResidence(int residence) {
                return !ClassRepr.getPackageName(Mappings.this.myContext.getValue(residence)).equals(this.packageName);
            }
        }

        public abstract class UsageConstraint {
            public abstract boolean checkResidence(int var1);
        }
    }

    private static interface MemberComparator {
        public boolean isSame(ProtoMember var1);
    }
}

