/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildOutputConsumerImpl;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;

class ChunkBuildOutputConsumerImpl
implements ModuleLevelBuilder.OutputConsumer {
    private final CompileContext myContext;
    private Map<BuildTarget<?>, BuildOutputConsumerImpl> myTarget2Consumer = new THashMap();
    private Map<String, CompiledClass> myClasses = new THashMap();
    private Map<BuildTarget<?>, Collection<CompiledClass>> myTargetToClassesMap = new THashMap();

    public ChunkBuildOutputConsumerImpl(CompileContext context) {
        this.myContext = context;
    }

    @Override
    public Collection<CompiledClass> getTargetCompiledClasses(BuildTarget<?> target) {
        Collection<CompiledClass> classes = this.myTargetToClassesMap.get(target);
        if (classes != null) {
            return Collections.unmodifiableCollection(classes);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Map<String, CompiledClass> getCompiledClasses() {
        Map<String, CompiledClass> map = Collections.unmodifiableMap(this.myClasses);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/ChunkBuildOutputConsumerImpl", "getCompiledClasses"));
        }
        return map;
    }

    @Override
    @Nullable
    public BinaryContent lookupClassBytes(String className) {
        CompiledClass object = this.myClasses.get(className);
        return object != null ? object.getContent() : null;
    }

    @Override
    public void registerCompiledClass(BuildTarget<?> target, CompiledClass compiled) throws IOException {
        if (compiled.getClassName() != null) {
            this.myClasses.put(compiled.getClassName(), compiled);
            Collection<CompiledClass> classes = this.myTargetToClassesMap.get(target);
            if (classes == null) {
                classes = new ArrayList<CompiledClass>();
                this.myTargetToClassesMap.put(target, classes);
            }
            classes.add(compiled);
        }
        this.registerOutputFile(target, compiled.getOutputFile(), Collections.singleton(compiled.getSourceFile().getPath()));
    }

    @Override
    public void registerOutputFile(BuildTarget<?> target, File outputFile, Collection<String> sourcePaths) throws IOException {
        BuildOutputConsumerImpl consumer = this.myTarget2Consumer.get(target);
        if (consumer == null) {
            consumer = new BuildOutputConsumerImpl(target, this.myContext);
            this.myTarget2Consumer.put(target, consumer);
        }
        consumer.registerOutputFile(outputFile, sourcePaths);
    }

    public void fireFileGeneratedEvents() {
        for (BuildOutputConsumerImpl consumer : this.myTarget2Consumer.values()) {
            consumer.fireFileGeneratedEvent();
        }
    }

    public void clear() {
        this.myTarget2Consumer.clear();
        this.myClasses.clear();
        this.myTargetToClassesMap.clear();
    }
}

