/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.build.common;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.io.URLUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.build.common.OutputLineReader;
import org.jetbrains.jps.util.JpsPathUtil;

public abstract class GwtCompilerProcessHandlerBase
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.make.GwtCompilerProcessHandler");
    @NonNls
    private static final String[] COMPILATION_PROGRESS_PREFIXES = new String[]{"Analyzing source", "Copying all files found on public path", "Output will be written into", "Loading inherited module", "Refreshing resources", "Compiling module", "Compiling permutation"};
    @NonNls
    private static final String FINDING_ENTRY_POINTS_PREFIX = "Finding entry point classes";
    @NonNls
    private static final String ERROR_PREFIX = "[ERROR] ";
    @NonNls
    private static final String WARNING_PREFIX = "[WARN] ";
    @NonNls
    private static final String[] IGNORED_PATTERNS_IN_STDERR = new String[]{"INFO:", "com.vaadin.terminal.gwt.widgetsetutils.ClassPathExplorer", "Picked up _JAVA_OPTIONS:", "Picked up JAVA_TOOL_OPTIONS:"};
    @NonNls
    private static final String ERROR_FILE_PREFIX = "Errors in ";
    @NonNls
    private static final String ERROR_LINE_PREFIX = "Line ";
    @NonNls
    private static final String ERROR_LINE_SUFFIX = ": ";
    @NonNls
    private static final String BUILD_FAILED_MESSAGE = "Build failed";
    @NonNls
    private static final String STACKTRACE_PREFIX = "at ";
    @NonNls
    private static final Set<String> MODULE_FILE_ERRORS = new HashSet<String>(Arrays.asList("Module has no entry points defined"));
    @NonNls
    private static final String[] CLASS_NAME_PREFIXES = new String[]{"Type ", "Return type: ", "Parameter: "};
    private final Map<Key, GwtCompilerOutputParser> myParsers = new FactoryMap<Key, GwtCompilerOutputParser>(){

        protected GwtCompilerOutputParser create(Key key) {
            return new GwtCompilerOutputParser(ProcessOutputTypes.STDERR.equals((Object)key));
        }
    };
    private final String myModuleFileUrl;
    private boolean myWasCanceled;

    public GwtCompilerProcessHandlerBase(Process process, String moduleFileUrl) {
        super(process, "", null);
        this.myModuleFileUrl = moduleFileUrl;
    }

    @Nullable
    protected abstract String findFileUrlByClassName(String var1);

    protected abstract boolean isCanceled();

    protected abstract void reportMessage(String var1, boolean var2, String var3, int var4, int var5);

    protected abstract void showProgressMessage(String var1);

    public void notifyTextAvailable(String text, Key outputType) {
        super.notifyTextAvailable(text, outputType);
        this.myParsers.get(outputType).parseOutput(text);
        this.destroyProcessIfCanceled();
    }

    private void destroyProcessIfCanceled() {
        boolean canceled = this.isCanceled();
        if (canceled) {
            this.myWasCanceled = true;
            this.destroyProcess();
        }
    }

    public boolean wasCanceled() {
        return this.myWasCanceled;
    }

    private static String fixFileUrl(String url) {
        if ((url = URLUtil.unescapePercentSequences((String)url)).contains(":/")) {
            return JpsPathUtil.fixURLforIDEA((String)url);
        }
        return JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)url));
    }

    public void waitForTerminationOrCancellation() {
        while (!this.waitFor(300L)) {
            this.destroyProcessIfCanceled();
        }
    }

    private class GwtCompilerOutputParser
    extends OutputLineReader {
        private String myCurrentFileUrl;
        private int myCurrentClassIsActualCountdown;
        private boolean myFindingEntryPoints = false;
        private boolean myStackTraceExpected = false;
        private final boolean myErrorStream;

        public GwtCompilerOutputParser(boolean isErrorStream) {
            this.myErrorStream = isErrorStream;
        }

        @Override
        protected void parseLine(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/jps/gwt/build/common/GwtCompilerProcessHandlerBase$GwtCompilerOutputParser", "parseLine"));
            }
            if (line.length() == 0) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((this.myErrorStream ? "[stderr]" : "") + line);
            }
            for (String prefix : COMPILATION_PROGRESS_PREFIXES) {
                if (!line.startsWith(prefix)) continue;
                GwtCompilerProcessHandlerBase.this.showProgressMessage(line);
            }
            if (line.startsWith(GwtCompilerProcessHandlerBase.ERROR_FILE_PREFIX)) {
                this.myStackTraceExpected = false;
                this.setCurrentFileUrl(line.substring(GwtCompilerProcessHandlerBase.ERROR_FILE_PREFIX.length()));
            } else if (line.startsWith(GwtCompilerProcessHandlerBase.WARNING_PREFIX)) {
                String message = line.substring(GwtCompilerProcessHandlerBase.WARNING_PREFIX.length());
                GwtCompilerProcessHandlerBase.this.reportMessage(message, false, this.myCurrentFileUrl, -1, -1);
            } else if (line.startsWith(GwtCompilerProcessHandlerBase.ERROR_PREFIX)) {
                this.myStackTraceExpected = false;
                boolean errorLineParsed = false;
                int start = GwtCompilerProcessHandlerBase.ERROR_PREFIX.length();
                if (line.startsWith(GwtCompilerProcessHandlerBase.ERROR_FILE_PREFIX, start)) {
                    int first = line.indexOf(39, start += GwtCompilerProcessHandlerBase.ERROR_FILE_PREFIX.length());
                    int last = line.lastIndexOf(39);
                    if (first != -1 && last != -1) {
                        this.setCurrentFileUrl(line.substring(first + 1, last));
                        errorLineParsed = true;
                    }
                } else if (line.startsWith(GwtCompilerProcessHandlerBase.ERROR_LINE_PREFIX, start)) {
                    int end = line.indexOf(GwtCompilerProcessHandlerBase.ERROR_LINE_SUFFIX, start += GwtCompilerProcessHandlerBase.ERROR_LINE_PREFIX.length());
                    if (end != -1) {
                        try {
                            int lineNumber = Integer.parseInt(line.substring(start, end));
                            String message = line.substring(end + GwtCompilerProcessHandlerBase.ERROR_LINE_SUFFIX.length());
                            GwtCompilerProcessHandlerBase.this.reportMessage(message, true, this.myCurrentFileUrl, lineNumber, 0);
                            errorLineParsed = true;
                        }
                        catch (NumberFormatException ignored) {}
                    }
                } else {
                    line = line.substring(start);
                }
                if (MODULE_FILE_ERRORS.contains(line) || this.myFindingEntryPoints) {
                    GwtCompilerProcessHandlerBase.this.reportMessage(line, true, GwtCompilerProcessHandlerBase.this.myModuleFileUrl, -1, -1);
                    errorLineParsed = true;
                }
                if (!errorLineParsed && !GwtCompilerProcessHandlerBase.BUILD_FAILED_MESSAGE.equals(line)) {
                    GwtCompilerProcessHandlerBase.this.reportMessage(line, true, null, -1, -1);
                    this.myStackTraceExpected = true;
                }
            } else if (line.startsWith(GwtCompilerProcessHandlerBase.FINDING_ENTRY_POINTS_PREFIX)) {
                this.myFindingEntryPoints = true;
            } else if (line.startsWith(GwtCompilerProcessHandlerBase.STACKTRACE_PREFIX) && this.myStackTraceExpected) {
                GwtCompilerProcessHandlerBase.this.reportMessage(line, true, null, -1, -1);
            } else if (this.myErrorStream) {
                this.processStderrLine(line);
            } else {
                for (String prefix : CLASS_NAME_PREFIXES) {
                    String url;
                    if (!line.startsWith(prefix)) continue;
                    int start = prefix.length();
                    int end = line.indexOf(32, start);
                    if (end == -1) {
                        end = line.length();
                    }
                    if ((url = GwtCompilerProcessHandlerBase.this.findFileUrlByClassName(line.substring(start, end))) == null) break;
                    this.myCurrentFileUrl = url;
                    this.myCurrentClassIsActualCountdown = 5;
                    break;
                }
                this.myFindingEntryPoints = false;
            }
            if (this.myCurrentFileUrl != null && this.myCurrentClassIsActualCountdown > 0) {
                --this.myCurrentClassIsActualCountdown;
                if (this.myCurrentClassIsActualCountdown == 0) {
                    this.myCurrentFileUrl = null;
                }
            }
        }

        private void processStderrLine(String line) {
            for (String s : IGNORED_PATTERNS_IN_STDERR) {
                if (!line.contains(s)) continue;
                return;
            }
            GwtCompilerProcessHandlerBase.this.reportMessage("[stderr]: " + line, false, null, -1, -1);
        }

        private void setCurrentFileUrl(String url) {
            this.myCurrentFileUrl = GwtCompilerProcessHandlerBase.fixFileUrl(url);
        }
    }
}

