/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;

public class GroovycOSProcessHandler
extends BaseOSProcessHandler {
    public static final String GROOVY_COMPILER_IN_OPERATION = "Groovy compiler in operation...";
    public static final String GRAPE_ROOT = "grape.root";
    private final List<OutputItem> myCompiledItems = new ArrayList<OutputItem>();
    private final Set<File> toRecompileFiles = new HashSet<File>();
    private final List<CompilerMessage> compilerMessages = new ArrayList<CompilerMessage>();
    private final StringBuffer stdErr = new StringBuffer();
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.groovy.GroovycOSProcessHandler");
    private final Consumer<String> myStatusUpdater;
    private final StringBuffer outputBuffer = new StringBuffer();

    public GroovycOSProcessHandler(Process process, Consumer<String> statusUpdater) {
        super(process, null, null);
        this.myStatusUpdater = statusUpdater;
    }

    public void notifyTextAvailable(String text, Key outputType) {
        super.notifyTextAvailable(text, outputType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received from groovyc " + outputType + ": " + text);
        }
        if (outputType == ProcessOutputTypes.SYSTEM) {
            return;
        }
        if (outputType == ProcessOutputTypes.STDERR && !text.startsWith("Picked up JAVA_TOOL_OPTIONS")) {
            this.stdErr.append(StringUtil.convertLineSeparators((String)text));
            return;
        }
        this.parseOutput(text);
    }

    protected void updateStatus(@Nullable String status) {
        this.myStatusUpdater.consume((Object)(status == null ? GROOVY_COMPILER_IN_OPERATION : status));
    }

    private void parseOutput(String text) {
        String trimmed = text.trim();
        if (trimmed.startsWith("@#$%@# Presentable:")) {
            this.updateStatus(trimmed.substring("@#$%@# Presentable:".length()));
            return;
        }
        if ("$@#$%^ CLEAR_PRESENTABLE".equals(trimmed)) {
            this.updateStatus(null);
            return;
        }
        if (StringUtil.isNotEmpty((String)text)) {
            this.outputBuffer.append(text);
            if (this.outputBuffer.indexOf("%%c") != -1) {
                if (this.outputBuffer.indexOf("/%c") == -1) {
                    return;
                }
                String compiled = this.handleOutputBuffer("%%c", "/%c");
                List<String> list = GroovycOSProcessHandler.splitAndTrim(compiled);
                String outputPath = list.get(0);
                String sourceFile = list.get(1);
                OutputItem item = new OutputItem(outputPath, sourceFile);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Output: " + item);
                }
                this.myCompiledItems.add(item);
            } else if (this.outputBuffer.indexOf("%%rc") != -1) {
                if (this.outputBuffer.indexOf("/%rc") != -1) {
                    String url = this.handleOutputBuffer("%%rc", "/%rc");
                    this.toRecompileFiles.add(new File(url));
                }
            } else if (this.outputBuffer.indexOf("%%m") != -1) {
                int columnInt;
                int lineInt;
                if (this.outputBuffer.indexOf("/%m") == -1) {
                    return;
                }
                text = this.handleOutputBuffer("%%m", "/%m");
                List<String> tokens = GroovycOSProcessHandler.splitAndTrim(text);
                LOG.assertTrue(tokens.size() > 4, (Object)"Wrong number of output params");
                String category = tokens.get(0);
                String message = tokens.get(1);
                String url = tokens.get(2);
                String lineNum = tokens.get(3);
                String columnNum = tokens.get(4);
                try {
                    lineInt = Integer.parseInt(lineNum);
                    columnInt = Integer.parseInt(columnNum);
                }
                catch (NumberFormatException e) {
                    LOG.error((Throwable)e);
                    lineInt = 0;
                    columnInt = 0;
                }
                BuildMessage.Kind kind = category.equals("error") ? BuildMessage.Kind.ERROR : (category.equals("warning") ? BuildMessage.Kind.WARNING : BuildMessage.Kind.INFO);
                CompilerMessage compilerMessage = new CompilerMessage("Groovyc", kind, message, url, -1L, -1L, -1L, (long)lineInt, (long)columnInt);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Message: " + compilerMessage);
                }
                this.compilerMessages.add(compilerMessage);
            }
        }
    }

    private String handleOutputBuffer(String startMarker, String endMarker) {
        int end;
        int start = this.outputBuffer.indexOf(startMarker);
        if (start > (end = this.outputBuffer.indexOf(endMarker))) {
            throw new AssertionError((Object)("Malformed Groovyc output: " + this.outputBuffer.toString()));
        }
        String text = this.outputBuffer.substring(start + startMarker.length(), end);
        this.outputBuffer.delete(start, end + endMarker.length());
        return text.trim();
    }

    private static List<String> splitAndTrim(String compiled) {
        return ContainerUtil.map((Collection)StringUtil.split((String)compiled, (String)"#%%#%%%#%%%%%%%%%#"), (Function)new Function<String, String>(){

            public String fun(String s) {
                return s.trim();
            }
        });
    }

    public List<OutputItem> getSuccessfullyCompiled() {
        return this.myCompiledItems;
    }

    public Set<File> getToRecompileFiles() {
        return this.toRecompileFiles;
    }

    public boolean shouldRetry() {
        if (this.getProcess().exitValue() != 0) {
            LOG.debug("Non-zero exit code");
            return true;
        }
        for (CompilerMessage message : this.compilerMessages) {
            if (message.getKind() != BuildMessage.Kind.ERROR) continue;
            LOG.debug("Error message: " + message);
            return true;
        }
        if (this.getStdErr().length() > 0) {
            LOG.debug("Non-empty stderr: '" + this.getStdErr() + "'");
            return true;
        }
        return false;
    }

    public List<CompilerMessage> getCompilerMessages(String moduleName) {
        int exitValue;
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>(this.compilerMessages);
        StringBuffer unparsedBuffer = this.getStdErr();
        if (unparsedBuffer.length() != 0) {
            String msg = unparsedBuffer.toString();
            if (msg.contains("Cannot compile Groovy files: no Groovy library is defined")) {
                messages.add(new CompilerMessage("", BuildMessage.Kind.ERROR, "Cannot compile Groovy files: no Groovy library is defined for module '" + moduleName + "'"));
            } else {
                messages.add(new CompilerMessage("Groovyc", BuildMessage.Kind.INFO, msg));
            }
        }
        if ((exitValue = this.getProcess().exitValue()) != 0) {
            for (CompilerMessage message : messages) {
                if (message.getKind() != BuildMessage.Kind.ERROR) continue;
                return messages;
            }
            messages.add(new CompilerMessage("Groovyc", BuildMessage.Kind.ERROR, "Internal groovyc error: code " + exitValue));
        }
        return messages;
    }

    public StringBuffer getStdErr() {
        return this.stdErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File fillFileWithGroovycParameters(String outputDir, Collection<String> changedSources, Collection<String> finalOutputs, Map<String, String> class2Src, @Nullable String encoding, List<String> patchers, String classpath) throws IOException {
        File tempFile = FileUtil.createTempFile((String)"ideaGroovyToCompile", (String)".txt", (boolean)true);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tempFile)));
        try {
            writer.write(classpath);
            writer.write("\n");
            for (String string : changedSources) {
                writer.write("src_file\n");
                writer.write(string);
                writer.write("\n");
            }
            writer.write("class2src\n");
            for (Map.Entry entry : class2Src.entrySet()) {
                writer.write((String)entry.getKey() + "\n");
                writer.write((String)entry.getValue() + "\n");
            }
            writer.write("end\n");
            writer.write("patchers\n");
            for (String string : patchers) {
                writer.write(string + "\n");
            }
            writer.write("end\n");
            if (encoding != null) {
                writer.write("encoding\n");
                writer.write(encoding + "\n");
            }
            writer.write("outputpath\n");
            writer.write(outputDir);
            writer.write("\n");
            writer.write("final_outputpath\n");
            writer.write(StringUtil.join(finalOutputs, (String)File.pathSeparator));
            writer.write("\n");
        }
        finally {
            ((Writer)writer).close();
        }
        return tempFile;
    }

    public static GroovycOSProcessHandler runGroovyc(Process process, Consumer<String> updater) {
        GroovycOSProcessHandler processHandler = new GroovycOSProcessHandler(process, updater);
        processHandler.startNotify();
        processHandler.waitFor();
        return processHandler;
    }

    public static class OutputItem {
        public final String outputPath;
        public final String sourcePath;

        public OutputItem(String outputPath, String sourceFileName) {
            this.outputPath = outputPath;
            this.sourcePath = sourceFileName;
        }

        public String toString() {
            return "OutputItem{outputPath='" + this.outputPath + '\'' + ", sourcePath='" + this.sourcePath + '\'' + '}';
        }
    }
}

