/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.impl.JpsGlobalImpl;
import org.jetbrains.jps.model.impl.JpsProjectImpl;

public class JpsModelImpl
implements JpsModel {
    private JpsProjectImpl myProject;
    private JpsGlobalImpl myGlobal;
    private JpsModelImpl myOriginalModel;
    private final JpsEventDispatcher myEventDispatcher;

    public JpsModelImpl(JpsEventDispatcher eventDispatcher) {
        this.myEventDispatcher = eventDispatcher;
        this.myProject = new JpsProjectImpl(this, eventDispatcher);
        this.myGlobal = new JpsGlobalImpl(this, eventDispatcher);
    }

    private JpsModelImpl(JpsModelImpl original, JpsEventDispatcher eventDispatcher) {
        this.myOriginalModel = original;
        this.myEventDispatcher = eventDispatcher;
        this.myProject = new JpsProjectImpl(original.myProject, (JpsModel)this, eventDispatcher);
        this.myGlobal = new JpsGlobalImpl(original.myGlobal, (JpsModel)this, eventDispatcher);
    }

    @Override
    @NotNull
    public JpsProjectImpl getProject() {
        JpsProjectImpl jpsProjectImpl = this.myProject;
        if (jpsProjectImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsModelImpl", "getProject"));
        }
        return jpsProjectImpl;
    }

    @Override
    @NotNull
    public JpsGlobalImpl getGlobal() {
        JpsGlobalImpl jpsGlobalImpl = this.myGlobal;
        if (jpsGlobalImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsModelImpl", "getGlobal"));
        }
        return jpsGlobalImpl;
    }

    @Override
    @NotNull
    public JpsModel createModifiableModel(@NotNull JpsEventDispatcher eventDispatcher) {
        if (eventDispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventDispatcher", "org/jetbrains/jps/model/impl/JpsModelImpl", "createModifiableModel"));
        }
        JpsModelImpl jpsModelImpl = new JpsModelImpl(this, eventDispatcher);
        if (jpsModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsModelImpl", "createModifiableModel"));
        }
        return jpsModelImpl;
    }

    @Override
    public void registerExternalReference(@NotNull JpsElementReference<?> reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jps/model/impl/JpsModelImpl", "registerExternalReference"));
        }
        this.myProject.addExternalReference(reference);
    }

    @Override
    public void commit() {
        this.myOriginalModel.applyChanges(this);
    }

    private void applyChanges(@NotNull JpsModelImpl modifiedCopy) {
        if (modifiedCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiedCopy", "org/jetbrains/jps/model/impl/JpsModelImpl", "applyChanges"));
        }
        this.myProject.applyChanges(modifiedCopy.myProject);
        this.myGlobal.applyChanges(modifiedCopy.myGlobal);
    }
}

