/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.sdk;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PathUtilRt;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class RslUtil {
    private static final Logger LOG = Logger.getInstance((String)RslUtil.class.getName());
    private static final Map<String, Pair<Long, Map<String, List<String>>>> ourConfigFilePathToTimestampAndSwcPathToRslUrls = new THashMap();

    public static boolean canBeRsl(String sdkHome, String swcPath) {
        List<String> rslUrls = RslUtil.getRslUrls(sdkHome, swcPath);
        for (String url : rslUrls) {
            if (!url.startsWith("http://") && !new File(sdkHome + "/frameworks/rsls/" + url).isFile()) continue;
            return true;
        }
        return false;
    }

    public static List<String> getRslUrls(String sdkHome, String swcPath) {
        Map<String, List<String>> swcPathToRslUrlMap = RslUtil.getSwcPathToRslUrlsMap(sdkHome);
        List<String> rslUrls = swcPathToRslUrlMap.get(SystemInfo.isFileSystemCaseSensitive ? swcPath : swcPath.toLowerCase());
        return rslUrls == null ? Collections.emptyList() : rslUrls;
    }

    private static synchronized Map<String, List<String>> getSwcPathToRslUrlsMap(String sdkHome) {
        Long cachedTimestamp;
        String configFilePath = sdkHome + "/frameworks/flex-config.xml";
        File configFile = new File(configFilePath);
        if (!configFile.isFile()) {
            LOG.warn("File not found: " + configFilePath);
            ourConfigFilePathToTimestampAndSwcPathToRslUrls.remove(configFilePath);
            return Collections.emptyMap();
        }
        Pair data = ourConfigFilePathToTimestampAndSwcPathToRslUrls.get(configFilePath);
        Long currentTimestamp = configFile.lastModified();
        Long l = cachedTimestamp = data == null ? null : (Long)data.first;
        if (cachedTimestamp == null || !cachedTimestamp.equals(currentTimestamp)) {
            ourConfigFilePathToTimestampAndSwcPathToRslUrls.remove(configFilePath);
            THashMap swcPathToRslMap = new THashMap();
            try {
                Document document = JDOMUtil.loadDocument((File)configFile);
                Element rootElement = document.getRootElement();
                if (rootElement != null) {
                    for (Element rslElement : rootElement.getChildren("runtime-shared-library-path", rootElement.getNamespace())) {
                        Element swcPathElement = rslElement.getChild("path-element", rslElement.getNamespace());
                        if (swcPathElement == null) continue;
                        ArrayList<String> rslUrls = new ArrayList<String>(2);
                        for (Element rslUrlElement : rslElement.getChildren("rsl-url", rootElement.getNamespace())) {
                            String rslUrl = rslUrlElement.getTextNormalize();
                            rslUrls.add(rslUrl);
                        }
                        String swcPath = PathUtilRt.getParentPath((String)configFilePath) + "/" + swcPathElement.getTextNormalize();
                        swcPathToRslMap.put(SystemInfo.isFileSystemCaseSensitive ? swcPath : swcPath.toLowerCase(), rslUrls);
                    }
                }
            }
            catch (IOException e) {
                LOG.warn(configFilePath, (Throwable)e);
            }
            catch (JDOMException e) {
                LOG.warn(configFilePath, (Throwable)e);
            }
            data = Pair.create((Object)currentTimestamp, (Object)swcPathToRslMap);
            ourConfigFilePathToTimestampAndSwcPathToRslUrls.put(configFilePath, (Pair<Long, Map<String, List<String>>>)data);
        }
        return (Map)data.second;
    }
}

