/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;

public interface IMergerLog {
    public static final String MAIN_MANIFEST = "@main";
    public static final String LIBRARY = "@library";

    public void error(@NonNull Severity var1, @NonNull FileAndLine var2, @NonNull String var3, Object ... var4);

    public void conflict(@NonNull Severity var1, @NonNull FileAndLine var2, @NonNull FileAndLine var3, @NonNull String var4, Object ... var5);

    public static class FileAndLine {
        private final String mFilePath;
        private final int mLine;

        public FileAndLine(@Nullable String filePath, int line) {
            this.mFilePath = filePath;
            this.mLine = line;
        }

        @Nullable
        public String getFileName() {
            return this.mFilePath;
        }

        public int getLine() {
            return this.mLine;
        }

        public String toString() {
            String name = this.mFilePath;
            if (IMergerLog.MAIN_MANIFEST.equals(name)) {
                name = "main manifest";
            } else if (IMergerLog.LIBRARY.equals(name)) {
                name = "library";
            } else if (name == null) {
                name = "(Unknown)";
            }
            if (this.mLine <= 0) {
                return name;
            }
            return name + ':' + this.mLine;
        }
    }

    public static enum Severity {
        INFO,
        WARNING,
        ERROR;

    }
}

