/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser;

import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.parser.OutputLineReader;
import com.android.tools.idea.gradle.output.parser.ParsingFailedException;
import com.android.tools.idea.gradle.output.parser.PatternAwareOutputParser;
import com.android.tools.idea.gradle.output.parser.aapt.AaptOutputParser;
import com.android.tools.idea.gradle.output.parser.aapt.AbstractAaptOutputParser;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildFailureParser
implements PatternAwareOutputParser {
    private static final Pattern[] BEGINNING_PATTERNS = new Pattern[]{Pattern.compile("^FAILURE: Build failed with an exception."), Pattern.compile("^\\* What went wrong:")};
    private static final Pattern WHERE_LINE_1 = Pattern.compile("^\\* Where:");
    private static final Pattern WHERE_LINE_2 = Pattern.compile("^Build file '(.+)' line: (\\d+)");
    private static final Pattern[] ENDING_PATTERNS = new Pattern[]{Pattern.compile("^\\* Try:"), Pattern.compile("^Run with --stacktrace option to get the stack trace. Run with --info or --debug option to get more log output.")};
    private static final Pattern COMMAND_FAILURE_MESSAGE = Pattern.compile("^> Failed to run command:");
    private static final Pattern COMMAND_LINE_PARSER = Pattern.compile("^\\s+/([^/ ]+/)+([^/ ]+) (.*)");
    private static final Pattern COMMAND_LINE_ERROR_OUTPUT = Pattern.compile("^  Output:$");
    private AaptOutputParser myAaptParser = new AaptOutputParser();

    @Override
    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<GradleMessage> messages) throws ParsingFailedException {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/gradle/output/parser/BuildFailureParser", "parse"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/android/tools/idea/gradle/output/parser/BuildFailureParser", "parse"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/android/tools/idea/gradle/output/parser/BuildFailureParser", "parse"));
        }
        State state = State.BEGINNING;
        int pos = 0;
        String currentLine = line;
        String file = null;
        int lineNum = -1;
        int column = -1;
        String lastQuotedLine = null;
        StringBuilder errorMessage = new StringBuilder();
        while (true) {
            switch (state) {
                case BEGINNING: {
                    if (WHERE_LINE_1.matcher(currentLine).matches()) {
                        state = State.WHERE;
                        break;
                    }
                    if (!BEGINNING_PATTERNS[pos].matcher(currentLine).matches()) {
                        return false;
                    }
                    if (++pos < BEGINNING_PATTERNS.length) break;
                    state = State.MESSAGE;
                    break;
                }
                case WHERE: {
                    Matcher matcher = WHERE_LINE_2.matcher(currentLine);
                    if (!matcher.matches()) {
                        return false;
                    }
                    file = matcher.group(1);
                    lineNum = Integer.parseInt(matcher.group(2));
                    column = 0;
                    state = State.BEGINNING;
                    break;
                }
                case MESSAGE: {
                    Matcher matcher;
                    if (ENDING_PATTERNS[0].matcher(currentLine).matches()) {
                        state = State.ENDING;
                        pos = 1;
                        break;
                    }
                    if (COMMAND_FAILURE_MESSAGE.matcher(currentLine).matches()) {
                        state = State.COMMAND_FAILURE_COMMAND_LINE;
                        break;
                    }
                    int quoted = -1;
                    int n = currentLine.length();
                    for (int i = 0; i < n; ++i) {
                        char c = currentLine.charAt(i);
                        if (c == '>') {
                            quoted = i;
                            break;
                        }
                        if (!Character.isWhitespace(c)) break;
                    }
                    if (quoted != -1) {
                        if (currentLine.startsWith("> In DataSet ", quoted) && currentLine.contains("no data file for changedFile")) {
                            matcher = Pattern.compile("\\s*> In DataSet '.+', no data file for changedFile '(.+)'").matcher(currentLine);
                            if (matcher.find()) {
                                file = matcher.group(1);
                            }
                        } else if (currentLine.startsWith("> Duplicate resources: ", quoted)) {
                            matcher = Pattern.compile("\\s*> Duplicate resources: (.+):(.+), (.+):(.+)\\s*").matcher(currentLine);
                            if (matcher.matches()) {
                                file = matcher.group(1);
                                lineNum = AbstractAaptOutputParser.findResourceLine(new File(file), matcher.group(2));
                                messages.add(new GradleMessage(GradleMessage.Kind.ERROR, currentLine, file, lineNum, -1));
                                String other = matcher.group(3);
                                int otherLine = AbstractAaptOutputParser.findResourceLine(new File(other), matcher.group(4));
                                messages.add(new GradleMessage(GradleMessage.Kind.ERROR, "Other duplicate occurrence here", other, otherLine, -1));
                                break;
                            }
                        } else if (currentLine.startsWith("> Problems pinging owner of lock ", quoted)) {
                            String text = "Possibly unstable network connection: Failed to connect to lock owner. Try to rebuild.";
                            messages.add(new GradleMessage(GradleMessage.Kind.ERROR, text, null, -1, -1));
                        }
                    }
                    if (errorMessage.length() > 0) {
                        errorMessage.append("\n");
                    }
                    if (BuildFailureParser.isGradleQuotedLine(currentLine)) {
                        lastQuotedLine = currentLine;
                    }
                    errorMessage.append(currentLine);
                    break;
                }
                case COMMAND_FAILURE_COMMAND_LINE: {
                    currentLine = currentLine.replaceAll("Android Studio", "Android_Studio");
                    Matcher matcher = COMMAND_LINE_PARSER.matcher(currentLine);
                    if (matcher.matches()) {
                        String message = String.format("Error while executing %s command", matcher.group(2));
                        messages.add(new GradleMessage(GradleMessage.Kind.ERROR, message));
                        break;
                    }
                    if (COMMAND_LINE_ERROR_OUTPUT.matcher(currentLine).matches()) {
                        state = State.COMMAND_FAILURE_OUTPUT;
                        break;
                    }
                    if (!ENDING_PATTERNS[0].matcher(currentLine).matches()) break;
                    state = State.ENDING;
                    pos = 1;
                    break;
                }
                case COMMAND_FAILURE_OUTPUT: {
                    if (ENDING_PATTERNS[0].matcher(currentLine).matches()) {
                        state = State.ENDING;
                        pos = 1;
                        break;
                    }
                    if (this.myAaptParser.parse(currentLine = currentLine.trim(), reader, messages)) break;
                    messages.add(new GradleMessage(GradleMessage.Kind.ERROR, currentLine));
                    break;
                }
                case ENDING: {
                    if (!ENDING_PATTERNS[pos].matcher(currentLine).matches()) {
                        return false;
                    }
                    if (++pos < ENDING_PATTERNS.length) break;
                    if (errorMessage.length() > 0) {
                        String text = errorMessage.toString();
                        if (file == null && lastQuotedLine != null) {
                            String lastLine;
                            String[] lines;
                            String msg = BuildFailureParser.unquoteGradleLine(lastQuotedLine);
                            GradleMessage rootCause = BuildFailureParser.findRootCause(msg, messages);
                            if (rootCause == null && msg.endsWith("Failed to run command:") && (lines = text.split("\n")).length > 2 && lines[lines.length - 2].contains("Output:") && !(lastLine = lines[lines.length - 1]).isEmpty()) {
                                rootCause = BuildFailureParser.findRootCause(lastLine.trim(), messages);
                            }
                            if (rootCause != null) {
                                file = rootCause.getSourcePath();
                                lineNum = rootCause.getLineNumber();
                                column = rootCause.getColumn();
                            }
                        }
                        if (file != null) {
                            messages.add(new GradleMessage(GradleMessage.Kind.ERROR, text, file, lineNum, column));
                        } else {
                            messages.add(new GradleMessage(GradleMessage.Kind.ERROR, text));
                        }
                    }
                    return true;
                }
            }
            do {
                if ((currentLine = reader.readLine()) != null) continue;
                return false;
            } while (currentLine.trim().isEmpty());
        }
    }

    @Nullable
    private static GradleMessage findRootCause(@NotNull String text, @NotNull Collection<GradleMessage> messages) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/output/parser/BuildFailureParser", "findRootCause"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/android/tools/idea/gradle/output/parser/BuildFailureParser", "findRootCause"));
        }
        for (GradleMessage message : messages) {
            String sourcePath;
            if (message.getKind() == GradleMessage.Kind.INFO || !message.getText().contains(text) || (sourcePath = message.getSourcePath()) == null) continue;
            return message;
        }
        int index = text.indexOf(58);
        if (index != -1 && index < text.length() - 1) {
            return BuildFailureParser.findRootCause(text.substring(index + 1).trim(), messages);
        }
        return null;
    }

    private static boolean isGradleQuotedLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/gradle/output/parser/BuildFailureParser", "isGradleQuotedLine"));
        }
        int n = line.length() - 1;
        for (int i = 0; i < n; ++i) {
            char c = line.charAt(i);
            if (c == '>') {
                return line.charAt(i + 1) == ' ';
            }
            if (c != ' ') break;
        }
        return false;
    }

    private static String unquoteGradleLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/gradle/output/parser/BuildFailureParser", "unquoteGradleLine"));
        }
        assert (BuildFailureParser.isGradleQuotedLine(line));
        return line.substring(line.indexOf(62) + 2);
    }

    private static enum State {
        BEGINNING,
        WHERE,
        MESSAGE,
        COMMAND_FAILURE_COMMAND_LINE,
        COMMAND_FAILURE_OUTPUT,
        ENDING;

    }
}

