/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.java.ExplodedDirectoryModuleExtension;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsAnnotationRootType;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaDependencyScope;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsNativeLibraryRootType;
import org.jetbrains.jps.model.java.JpsProductionModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.JpsTestModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsEclipseCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerConfigurationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerWorkspaceConfigurationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.RmicCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryRootTypeSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootDummyPropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;

public class JpsJavaModelSerializerExtension
extends JpsModelSerializerExtension {
    public static final String EXPORTED_ATTRIBUTE = "exported";
    public static final String SCOPE_ATTRIBUTE = "scope";
    public static final String OUTPUT_TAG = "output";
    public static final String URL_ATTRIBUTE = "url";
    public static final String LANGUAGE_LEVEL_ATTRIBUTE = "languageLevel";
    public static final String EXPLODED_TAG = "exploded";
    public static final String EXCLUDE_EXPLODED_TAG = "exclude-exploded";
    public static final String TEST_OUTPUT_TAG = "output-test";
    public static final String INHERIT_COMPILER_OUTPUT_ATTRIBUTE = "inherit-compiler-output";
    public static final String EXCLUDE_OUTPUT_TAG = "exclude-output";
    private static final String ANNOTATION_PATHS_TAG = "annotation-paths";
    private static final String JAVADOC_PATHS_TAG = "javadoc-paths";
    private static final String MODULE_LANGUAGE_LEVEL_ATTRIBUTE = "LANGUAGE_LEVEL";
    public static final String ROOT_TAG = "root";
    private static final String IS_GENERATED_ATTRIBUTE = "generated";
    public static final JavaSourceRootPropertiesSerializer JAVA_SOURCE_ROOT_PROPERTIES_SERIALIZER = new JavaSourceRootPropertiesSerializer(JavaSourceRootType.SOURCE, "java-source");

    @Override
    public void loadRootModel(@NotNull JpsModule module, @NotNull Element rootModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension", "loadRootModel"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension", "loadRootModel"));
        }
        JpsJavaModelSerializerExtension.loadExplodedDirectoryExtension(module, rootModel);
        JpsJavaModelSerializerExtension.loadJavaModuleExtension(module, rootModel);
    }

    @Override
    public void saveRootModel(@NotNull JpsModule module, @NotNull Element rootModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension", "saveRootModel"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension", "saveRootModel"));
        }
        JpsJavaModelSerializerExtension.saveExplodedDirectoryExtension(module, rootModel);
        JpsJavaModelSerializerExtension.saveJavaModuleExtension(module, rootModel);
    }

    @Override
    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List<JpsProjectExtensionSerializer> list = Arrays.asList(new JavaProjectExtensionSerializer(), new JpsJavaCompilerConfigurationSerializer(), new JpsJavaCompilerWorkspaceConfigurationSerializer(), new JpsJavaCompilerOptionsSerializer("JavacSettings", "Javac"), new JpsEclipseCompilerOptionsSerializer("EclipseCompilerSettings", "Eclipse"), new RmicCompilerOptionsSerializer("RmicSettings", "Rmic"));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension", "getProjectExtensionSerializers"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends JpsModuleSourceRootPropertiesSerializer<?>> getModuleSourceRootPropertiesSerializers() {
        List<JpsModuleSourceRootPropertiesSerializer> list = Arrays.asList(JAVA_SOURCE_ROOT_PROPERTIES_SERIALIZER, new JavaSourceRootPropertiesSerializer(JavaSourceRootType.TEST_SOURCE, "java-test"), new JpsModuleSourceRootDummyPropertiesSerializer(JavaResourceRootType.RESOURCE, "java-resource"), new JpsModuleSourceRootDummyPropertiesSerializer(JavaResourceRootType.TEST_RESOURCE, "java-test-resource"));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension", "getModuleSourceRootPropertiesSerializers"));
        }
        return list;
    }

    @Override
    public void loadModuleDependencyProperties(JpsDependencyElement dependency, Element entry) {
        boolean exported = entry.getAttributeValue(EXPORTED_ATTRIBUTE) != null;
        String scopeName = entry.getAttributeValue(SCOPE_ATTRIBUTE);
        JpsJavaDependencyScope scope = null;
        try {
            scope = scopeName != null ? JpsJavaDependencyScope.valueOf(scopeName) : JpsJavaDependencyScope.COMPILE;
        }
        catch (IllegalArgumentException e) {
            scope = JpsJavaDependencyScope.COMPILE;
        }
        JpsJavaDependencyExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateDependencyExtension(dependency);
        extension.setExported(exported);
        extension.setScope(scope);
    }

    @Override
    public void saveModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
        JpsJavaDependencyExtension extension = JpsJavaModelSerializerExtension.getService().getDependencyExtension(dependency);
        if (extension != null) {
            JpsJavaDependencyScope scope;
            if (extension.isExported()) {
                orderEntry.setAttribute(EXPORTED_ATTRIBUTE, "");
            }
            if ((scope = extension.getScope()) != JpsJavaDependencyScope.COMPILE) {
                orderEntry.setAttribute(SCOPE_ATTRIBUTE, scope.name());
            }
        }
    }

    @Override
    public List<JpsLibraryRootTypeSerializer> getLibraryRootTypeSerializers() {
        return Arrays.asList(new JpsLibraryRootTypeSerializer("JAVADOC", JpsOrderRootType.DOCUMENTATION, true), new JpsLibraryRootTypeSerializer("ANNOTATIONS", JpsAnnotationRootType.INSTANCE, false), new JpsLibraryRootTypeSerializer("NATIVE", JpsNativeLibraryRootType.INSTANCE, false));
    }

    @Override
    @NotNull
    public List<JpsLibraryRootTypeSerializer> getSdkRootTypeSerializers() {
        List<JpsLibraryRootTypeSerializer> list = Arrays.asList(new JpsLibraryRootTypeSerializer("javadocPath", JpsOrderRootType.DOCUMENTATION, true), new JpsLibraryRootTypeSerializer("annotationsPath", JpsAnnotationRootType.INSTANCE, true));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension", "getSdkRootTypeSerializers"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends JpsPackagingElementSerializer<?>> getPackagingElementSerializers() {
        List<JpsPackagingElementSerializer> list = Arrays.asList(new JpsModuleOutputPackagingElementSerializer(), new JpsTestModuleOutputPackagingElementSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension", "getPackagingElementSerializers"));
        }
        return list;
    }

    private static void loadExplodedDirectoryExtension(JpsModule module, Element rootModelComponent) {
        Element exploded = rootModelComponent.getChild(EXPLODED_TAG);
        if (exploded != null) {
            ExplodedDirectoryModuleExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateExplodedDirectoryExtension(module);
            extension.setExcludeExploded(rootModelComponent.getChild(EXCLUDE_EXPLODED_TAG) != null);
            extension.setExplodedUrl(exploded.getAttributeValue(URL_ATTRIBUTE));
        }
    }

    private static void saveExplodedDirectoryExtension(JpsModule module, Element rootModelElement) {
        ExplodedDirectoryModuleExtension extension = JpsJavaModelSerializerExtension.getService().getExplodedDirectoryExtension(module);
        if (extension != null) {
            if (extension.isExcludeExploded()) {
                rootModelElement.addContent(0, (Content)new Element(EXCLUDE_EXPLODED_TAG));
            }
            rootModelElement.addContent(0, (Content)new Element(EXPLODED_TAG).setAttribute(URL_ATTRIBUTE, extension.getExplodedUrl()));
        }
    }

    private static void loadJavaModuleExtension(JpsModule module, Element rootModelComponent) {
        JpsJavaModuleExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateModuleExtension(module);
        Element outputTag = rootModelComponent.getChild(OUTPUT_TAG);
        String outputUrl = outputTag != null ? outputTag.getAttributeValue(URL_ATTRIBUTE) : null;
        extension.setOutputUrl(outputUrl);
        Element testOutputTag = rootModelComponent.getChild(TEST_OUTPUT_TAG);
        String testOutputUrl = testOutputTag != null ? testOutputTag.getAttributeValue(URL_ATTRIBUTE) : null;
        extension.setTestOutputUrl(StringUtil.isEmpty((String)testOutputUrl) ? outputUrl : testOutputUrl);
        extension.setInheritOutput(Boolean.parseBoolean(rootModelComponent.getAttributeValue(INHERIT_COMPILER_OUTPUT_ATTRIBUTE)));
        extension.setExcludeOutput(rootModelComponent.getChild(EXCLUDE_OUTPUT_TAG) != null);
        String languageLevel = rootModelComponent.getAttributeValue(MODULE_LANGUAGE_LEVEL_ATTRIBUTE);
        if (languageLevel != null) {
            extension.setLanguageLevel(LanguageLevel.valueOf(languageLevel));
        }
        JpsJavaModelSerializerExtension.loadAdditionalRoots(rootModelComponent, ANNOTATION_PATHS_TAG, extension.getAnnotationRoots());
        JpsJavaModelSerializerExtension.loadAdditionalRoots(rootModelComponent, JAVADOC_PATHS_TAG, extension.getJavadocRoots());
    }

    private static void saveJavaModuleExtension(JpsModule module, Element rootModelComponent) {
        LanguageLevel languageLevel;
        String outputUrl;
        String testOutputUrl;
        JpsJavaModuleExtension extension = JpsJavaModelSerializerExtension.getService().getModuleExtension(module);
        if (extension == null) {
            return;
        }
        if (extension.isExcludeOutput()) {
            rootModelComponent.addContent(0, (Content)new Element(EXCLUDE_OUTPUT_TAG));
        }
        if ((testOutputUrl = extension.getTestOutputUrl()) != null) {
            rootModelComponent.addContent(0, (Content)new Element(TEST_OUTPUT_TAG).setAttribute(URL_ATTRIBUTE, testOutputUrl));
        }
        if ((outputUrl = extension.getOutputUrl()) != null) {
            rootModelComponent.addContent(0, (Content)new Element(OUTPUT_TAG).setAttribute(URL_ATTRIBUTE, outputUrl));
        }
        if ((languageLevel = extension.getLanguageLevel()) != null) {
            rootModelComponent.setAttribute(MODULE_LANGUAGE_LEVEL_ATTRIBUTE, languageLevel.name());
        }
        rootModelComponent.setAttribute(INHERIT_COMPILER_OUTPUT_ATTRIBUTE, String.valueOf(extension.isInheritOutput()));
        JpsJavaModelSerializerExtension.saveAdditionalRoots(rootModelComponent, JAVADOC_PATHS_TAG, extension.getJavadocRoots());
        JpsJavaModelSerializerExtension.saveAdditionalRoots(rootModelComponent, ANNOTATION_PATHS_TAG, extension.getAnnotationRoots());
    }

    private static void loadAdditionalRoots(Element rootModelComponent, String rootsTagName, JpsUrlList result) {
        Element roots = rootModelComponent.getChild(rootsTagName);
        for (Element root : JDOMUtil.getChildren((Element)roots, (String)ROOT_TAG)) {
            result.addUrl(root.getAttributeValue(URL_ATTRIBUTE));
        }
    }

    private static void saveAdditionalRoots(Element rootModelComponent, String rootsTagName, JpsUrlList list) {
        List<String> urls = list.getUrls();
        if (!urls.isEmpty()) {
            Element roots = new Element(rootsTagName);
            for (String url : urls) {
                roots.addContent(new Element(ROOT_TAG).setAttribute(URL_ATTRIBUTE, url));
            }
            rootModelComponent.addContent(roots);
        }
    }

    private static JpsJavaExtensionService getService() {
        return JpsJavaExtensionService.getInstance();
    }

    private static class JavaSourceRootPropertiesSerializer
    extends JpsModuleSourceRootPropertiesSerializer<JavaSourceRootProperties> {
        private JavaSourceRootPropertiesSerializer(JpsModuleSourceRootType<JavaSourceRootProperties> type, String typeId) {
            super(type, typeId);
        }

        @Override
        public JavaSourceRootProperties loadProperties(@NotNull Element sourceRootTag) {
            if (sourceRootTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRootTag", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaSourceRootPropertiesSerializer", "loadProperties"));
            }
            String packagePrefix = StringUtil.notNullize((String)sourceRootTag.getAttributeValue("packagePrefix"));
            boolean isGenerated = Boolean.parseBoolean(sourceRootTag.getAttributeValue(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE));
            return JpsJavaModelSerializerExtension.getService().createSourceRootProperties(packagePrefix, isGenerated);
        }

        @Override
        public void saveProperties(@NotNull JavaSourceRootProperties properties, @NotNull Element sourceRootTag) {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaSourceRootPropertiesSerializer", "saveProperties"));
            }
            if (sourceRootTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRootTag", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaSourceRootPropertiesSerializer", "saveProperties"));
            }
            String isTestSource = Boolean.toString(((JpsModuleSourceRootType)this.getType()).equals(JavaSourceRootType.TEST_SOURCE));
            sourceRootTag.setAttribute("isTestSource", isTestSource);
            String packagePrefix = properties.getPackagePrefix();
            if (!packagePrefix.isEmpty()) {
                sourceRootTag.setAttribute("packagePrefix", packagePrefix);
            }
            if (properties.isForGeneratedSources()) {
                sourceRootTag.setAttribute(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE, Boolean.TRUE.toString());
            }
        }
    }

    private static class JavaProjectExtensionSerializer
    extends JpsProjectExtensionSerializer {
        public JavaProjectExtensionSerializer() {
            super(null, "ProjectRootManager");
        }

        @Override
        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            String languageLevel;
            String url;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaProjectExtensionSerializer", "loadExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaProjectExtensionSerializer", "loadExtension"));
            }
            JpsJavaProjectExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateProjectExtension(project);
            Element output = componentTag.getChild(JpsJavaModelSerializerExtension.OUTPUT_TAG);
            if (output != null && (url = output.getAttributeValue(JpsJavaModelSerializerExtension.URL_ATTRIBUTE)) != null) {
                extension.setOutputUrl(url);
            }
            if ((languageLevel = componentTag.getAttributeValue(JpsJavaModelSerializerExtension.LANGUAGE_LEVEL_ATTRIBUTE)) != null) {
                extension.setLanguageLevel(LanguageLevel.valueOf(languageLevel));
            }
        }

        @Override
        public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaProjectExtensionSerializer", "saveExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaProjectExtensionSerializer", "saveExtension"));
            }
            JpsJavaProjectExtension extension = JpsJavaModelSerializerExtension.getService().getProjectExtension(project);
            if (extension == null) {
                return;
            }
            String outputUrl = extension.getOutputUrl();
            if (outputUrl != null) {
                componentTag.addContent(new Element(JpsJavaModelSerializerExtension.OUTPUT_TAG).setAttribute(JpsJavaModelSerializerExtension.URL_ATTRIBUTE, outputUrl));
            }
            LanguageLevel level = extension.getLanguageLevel();
            componentTag.setAttribute(JpsJavaModelSerializerExtension.LANGUAGE_LEVEL_ATTRIBUTE, level.name());
            componentTag.setAttribute("assert-keyword", Boolean.toString(level.compareTo(LanguageLevel.JDK_1_4) >= 0));
            componentTag.setAttribute("jdk-15", Boolean.toString(level.compareTo(LanguageLevel.JDK_1_5) >= 0));
        }
    }

    private static class JpsTestModuleOutputPackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsTestModuleOutputPackagingElement> {
        private JpsTestModuleOutputPackagingElementSerializer() {
            super("module-test-output", JpsTestModuleOutputPackagingElement.class);
        }

        @Override
        public JpsTestModuleOutputPackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createTestModuleOutput(reference);
        }

        @Override
        public void save(JpsTestModuleOutputPackagingElement element, Element tag) {
            tag.setAttribute("name", element.getModuleReference().getModuleName());
        }
    }

    private static class JpsModuleOutputPackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsProductionModuleOutputPackagingElement> {
        private JpsModuleOutputPackagingElementSerializer() {
            super("module-output", JpsProductionModuleOutputPackagingElement.class);
        }

        @Override
        public JpsProductionModuleOutputPackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createProductionModuleOutput(reference);
        }

        @Override
        public void save(JpsProductionModuleOutputPackagingElement element, Element tag) {
            tag.setAttribute("name", element.getModuleReference().getModuleName());
        }
    }
}

