/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtVaadinMavenSdkPaths
implements GwtSdkPaths {
    public static final String TYPE_ID = "Vaadin-Maven";
    private final String myBasePath;
    private final String myClientDirPath;
    private final String myVersion;

    public GwtVaadinMavenSdkPaths(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinMavenSdkPaths", "<init>"));
        }
        this.myClientDirPath = homePath;
        this.myBasePath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)homePath));
        this.myVersion = GwtVaadinMavenSdkPaths.getVersion(homePath);
    }

    public static String getVersion(String homePath) {
        return PathUtilRt.getFileName((String)homePath);
    }

    @Override
    @NotNull
    public String getDevJarPath(boolean systemIndependent) {
        String string = this.getJarPath("vaadin-client-compiler");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinMavenSdkPaths", "getDevJarPath"));
        }
        return string;
    }

    private String getJarPath(String artifactName) {
        return FileUtil.toSystemDependentName((String)(this.myBasePath + "/" + artifactName + "/" + this.myVersion + "/" + artifactName + "-" + this.myVersion + ".jar"));
    }

    @Override
    @NotNull
    public String getServletJarPath() {
        String string = this.getJarPath("vaadin-server");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinMavenSdkPaths", "getServletJarPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getUserJarPath() {
        String string = this.getJarPath("vaadin-client");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinMavenSdkPaths", "getUserJarPath"));
        }
        return string;
    }

    @Override
    public String getCodeServerJarPath() {
        return null;
    }

    @Override
    @NotNull
    public List<String> getAdditionalCompilerJars() {
        String version;
        File antJar;
        String repositoryPath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)this.myBasePath));
        ArrayList<String> additionalJars = new ArrayList<String>();
        additionalJars.addAll(GwtSdkPathUtil.findValidationJarsInMavenRepo(repositoryPath));
        File antDir = new File(FileUtil.toSystemDependentName((String)(repositoryPath + "/ant/ant")));
        String[] fileNames = antDir.list();
        if (fileNames != null && fileNames.length > 0 && (antJar = new File(antDir, (version = Collections.max(Arrays.asList(fileNames), VersionComparatorUtil.COMPARATOR)) + "/ant-" + version + ".jar")).isFile()) {
            additionalJars.add(antJar.getAbsolutePath());
        }
        ArrayList<String> arrayList = additionalJars;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinMavenSdkPaths", "getAdditionalCompilerJars"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getHomeDirectoryUrl() {
        String string = JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.myClientDirPath));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtVaadinMavenSdkPaths", "getHomeDirectoryUrl"));
        }
        return string;
    }
}

