/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Condition;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectUtils {
    public static final Object NULL = new Object();

    private ObjectUtils() {
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        T t2 = ObjectUtils._assertNotNull(t);
        if (t2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ObjectUtils", "assertNotNull"));
        }
        return t2;
    }

    @NotNull
    private static <T> T _assertNotNull(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/ObjectUtils", "_assertNotNull"));
        }
        T t2 = t;
        if (t2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ObjectUtils", "_assertNotNull"));
        }
        return t2;
    }

    @Contract(value="null, null -> null")
    public static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/util/ObjectUtils", "notNull"));
        }
        T t = value != null ? value : defaultValue;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ObjectUtils", "notNull"));
        }
        return t;
    }

    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ObjectUtils", "tryCast"));
        }
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        return null;
    }

    @Nullable
    public static <T> T nullizeByCondition(@Nullable T obj, @NotNull Condition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/ObjectUtils", "nullizeByCondition"));
        }
        if (condition.value(obj)) {
            return null;
        }
        return obj;
    }
}

