/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;

public class NotNullVerifyingInstrumenter
extends ClassVisitor
implements Opcodes {
    private static final String NOT_NULL_CLASS_NAME = "org/jetbrains/annotations/NotNull";
    private static final String NOT_NULL_TYPE = "Lorg/jetbrains/annotations/NotNull;";
    private static final String SYNTHETIC_CLASS_NAME = "java/lang/Synthetic";
    private static final String SYNTHETIC_TYPE = "Ljava/lang/Synthetic;";
    private static final String IAE_CLASS_NAME = "java/lang/IllegalArgumentException";
    private static final String ISE_CLASS_NAME = "java/lang/IllegalStateException";
    private static final String STRING_CLASS_NAME = "java/lang/String";
    private static final String OBJECT_CLASS_NAME = "java/lang/Object";
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String EXCEPTION_INIT_SIGNATURE = "(Ljava/lang/String;)V";
    private static final String ANNOTATION_DEFAULT_METHOD = "value";
    private static final String NULL_ARG_MESSAGE_INDEXED = "Argument %s for @NotNull parameter of %s.%s must not be null";
    private static final String NULL_ARG_MESSAGE_NAMED = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
    private static final String NULL_RESULT_MESSAGE = "@NotNull method %s.%s must not return null";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Map<String, Map<Integer, String>> myMethodParamNames;
    private String myClassName;
    private boolean myIsModification = false;
    private RuntimeException myPostponedError;

    private NotNullVerifyingInstrumenter(ClassVisitor classVisitor, ClassReader reader) {
        super(327680, classVisitor);
        this.myMethodParamNames = NotNullVerifyingInstrumenter.getAllParameterNames(reader);
    }

    public static boolean processClassFile(ClassReader reader, ClassVisitor writer) {
        NotNullVerifyingInstrumenter instrumenter = new NotNullVerifyingInstrumenter(writer, reader);
        reader.accept((ClassVisitor)instrumenter, 0);
        return instrumenter.isModification();
    }

    private static Map<String, Map<Integer, String>> getAllParameterNames(ClassReader reader) {
        final LinkedHashMap<String, Map<Integer, String>> methodParamNames = new LinkedHashMap<String, Map<Integer, String>>();
        reader.accept(new ClassVisitor(327680){
            private String myClassName;
            {
                super(x0);
                this.myClassName = null;
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.myClassName = name;
            }

            public MethodVisitor visitMethod(final int access, String name, String desc, String signature, String[] exceptions) {
                String methodName = this.myClassName + '.' + name + desc;
                final LinkedHashMap names = new LinkedHashMap();
                final Type[] args = Type.getArgumentTypes((String)desc);
                methodParamNames.put(methodName, names);
                return new MethodVisitor(this.api){

                    public void visitLocalVariable(String name2, String desc, String signature, Label start, Label end, int index) {
                        int parameterIndex = NotNullVerifyingInstrumenter.getParameterIndex(index, access, args);
                        if (parameterIndex >= 0) {
                            names.put(parameterIndex, name2);
                        }
                    }
                };
            }
        }, 0);
        return methodParamNames;
    }

    public boolean isModification() {
        return this.myIsModification;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.myClassName = name;
    }

    public MethodVisitor visitMethod(final int access, final String name, String desc, String signature, String[] exceptions) {
        final Type[] args = Type.getArgumentTypes((String)desc);
        final Type returnType = Type.getReturnType((String)desc);
        MethodVisitor v = this.cv.visitMethod(access, name, desc, signature, exceptions);
        final Map<Integer, String> paramNames = this.myMethodParamNames.get(this.myClassName + '.' + name + desc);
        return new MethodVisitor(327680, v){
            private final Map<Integer, NotNullState> myNotNullParams;
            private int mySyntheticCount;
            private NotNullState myMethodNotNull;
            private Label myStartGeneratedCodeLabel;
            {
                super(x0, x1);
                this.myNotNullParams = new LinkedHashMap<Integer, NotNullState>();
                this.mySyntheticCount = 0;
            }

            private AnnotationVisitor collectNotNullArgs(AnnotationVisitor base, final NotNullState state) {
                return new AnnotationVisitor(327680, base){

                    public void visit(String methodName, Object o) {
                        if (NotNullVerifyingInstrumenter.ANNOTATION_DEFAULT_METHOD.equals(methodName) && !((String)o).isEmpty()) {
                            state.message = (String)o;
                        } else if ("exception".equals(methodName) && o instanceof Type && !((Type)o).getClassName().equals(Exception.class.getName())) {
                            state.exceptionType = ((Type)o).getInternalName();
                        }
                        super.visit(methodName, o);
                    }
                };
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String anno, boolean visible) {
                AnnotationVisitor av = this.mv.visitParameterAnnotation(parameter, anno, visible);
                if (NotNullVerifyingInstrumenter.isReferenceType(args[parameter]) && anno.equals(NotNullVerifyingInstrumenter.NOT_NULL_TYPE)) {
                    NotNullState state = new NotNullState(NotNullVerifyingInstrumenter.IAE_CLASS_NAME);
                    this.myNotNullParams.put(new Integer(parameter), state);
                    av = this.collectNotNullArgs(av, state);
                } else if (anno.equals(NotNullVerifyingInstrumenter.SYNTHETIC_TYPE)) {
                    ++this.mySyntheticCount;
                }
                return av;
            }

            public AnnotationVisitor visitAnnotation(String anno, boolean isRuntime) {
                AnnotationVisitor av = this.mv.visitAnnotation(anno, isRuntime);
                if (NotNullVerifyingInstrumenter.isReferenceType(returnType) && anno.equals(NotNullVerifyingInstrumenter.NOT_NULL_TYPE)) {
                    this.myMethodNotNull = new NotNullState(NotNullVerifyingInstrumenter.ISE_CLASS_NAME);
                    av = this.collectNotNullArgs(av, this.myMethodNotNull);
                }
                return av;
            }

            public void visitCode() {
                if (this.myNotNullParams.size() > 0) {
                    this.myStartGeneratedCodeLabel = new Label();
                    this.mv.visitLabel(this.myStartGeneratedCodeLabel);
                }
                for (Map.Entry<Integer, NotNullState> entry : this.myNotNullParams.entrySet()) {
                    String[] stringArray;
                    String descrPattern;
                    String paramName;
                    Integer param = entry.getKey();
                    int var = (access & 8) == 0 ? 1 : 0;
                    for (int i = 0; i < param; ++i) {
                        var += args[i].getSize();
                    }
                    this.mv.visitVarInsn(25, var);
                    Label end = new Label();
                    this.mv.visitJumpInsn(199, end);
                    NotNullState state = entry.getValue();
                    String string = paramName = paramNames == null ? null : (String)paramNames.get(param);
                    String string2 = state.message != null ? state.message : (descrPattern = paramName != null ? NotNullVerifyingInstrumenter.NULL_ARG_MESSAGE_NAMED : NotNullVerifyingInstrumenter.NULL_ARG_MESSAGE_INDEXED);
                    if (state.message != null) {
                        stringArray = EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = paramName != null ? paramName : String.valueOf(param - this.mySyntheticCount);
                        stringArray2[1] = NotNullVerifyingInstrumenter.this.myClassName;
                        stringArray = stringArray2;
                        stringArray2[2] = name;
                    }
                    String[] args2 = stringArray;
                    this.generateThrow(state.exceptionType, end, descrPattern, args2);
                }
            }

            public void visitLocalVariable(String name2, String desc, String signature, Label start, Label end, int index) {
                boolean isStatic;
                boolean bl = isStatic = (access & 8) != 0;
                boolean isParameterOrThisRef = isStatic ? index < args.length : index <= args.length;
                Label label = isParameterOrThisRef && this.myStartGeneratedCodeLabel != null ? this.myStartGeneratedCodeLabel : start;
                this.mv.visitLocalVariable(name2, desc, signature, label, end, index);
            }

            public void visitInsn(int opcode) {
                if (opcode == 176 && this.myMethodNotNull != null) {
                    String[] stringArray;
                    String descrPattern;
                    this.mv.visitInsn(89);
                    Label skipLabel = new Label();
                    this.mv.visitJumpInsn(199, skipLabel);
                    String string = descrPattern = this.myMethodNotNull.message != null ? this.myMethodNotNull.message : NotNullVerifyingInstrumenter.NULL_RESULT_MESSAGE;
                    if (this.myMethodNotNull.message != null) {
                        stringArray = EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = NotNullVerifyingInstrumenter.this.myClassName;
                        stringArray = stringArray2;
                        stringArray2[1] = name;
                    }
                    String[] args2 = stringArray;
                    this.generateThrow(this.myMethodNotNull.exceptionType, skipLabel, descrPattern, args2);
                }
                this.mv.visitInsn(opcode);
            }

            private void generateThrow(String exceptionClass, Label end, String descrPattern, String[] args2) {
                this.mv.visitTypeInsn(187, exceptionClass);
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn((Object)descrPattern);
                this.mv.visitLdcInsn((Object)args2.length);
                this.mv.visitTypeInsn(189, NotNullVerifyingInstrumenter.OBJECT_CLASS_NAME);
                for (int i = 0; i < args2.length; ++i) {
                    this.mv.visitInsn(89);
                    this.mv.visitLdcInsn((Object)i);
                    this.mv.visitLdcInsn((Object)args2[i]);
                    this.mv.visitInsn(83);
                }
                this.mv.visitMethodInsn(184, NotNullVerifyingInstrumenter.STRING_CLASS_NAME, "format", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
                this.mv.visitMethodInsn(183, exceptionClass, NotNullVerifyingInstrumenter.CONSTRUCTOR_NAME, NotNullVerifyingInstrumenter.EXCEPTION_INIT_SIGNATURE, false);
                this.mv.visitInsn(191);
                this.mv.visitLabel(end);
                NotNullVerifyingInstrumenter.this.myIsModification = true;
                NotNullVerifyingInstrumenter.this.processPostponedErrors();
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                try {
                    super.visitMaxs(maxStack, maxLocals);
                }
                catch (Throwable e) {
                    NotNullVerifyingInstrumenter.this.registerError(name, "visitMaxs", e);
                }
            }
        };
    }

    private static int getParameterIndex(int localVarIndex, int methodAccess, Type[] paramTypes) {
        int parameterIndex;
        boolean isStatic = (methodAccess & 8) != 0;
        int n = parameterIndex = isStatic ? localVarIndex : localVarIndex - 1;
        if (parameterIndex >= paramTypes.length) {
            parameterIndex = -1;
        }
        return parameterIndex;
    }

    private static boolean isReferenceType(Type type) {
        return type.getSort() == 10 || type.getSort() == 9;
    }

    private void registerError(String methodName, String operationName, Throwable e) {
        if (this.myPostponedError == null) {
            Throwable err = e.getCause();
            if (err == null) {
                err = e;
            }
            this.myPostponedError = new RuntimeException("Operation '" + operationName + "' failed for " + this.myClassName + "." + methodName + "(): " + err.getMessage(), err);
        }
        if (this.myIsModification) {
            this.processPostponedErrors();
        }
    }

    private void processPostponedErrors() {
        RuntimeException error = this.myPostponedError;
        if (error != null) {
            throw error;
        }
    }

    private static class NotNullState {
        @Nullable
        String message;
        @NotNull
        String exceptionType;

        NotNullState(String exceptionType) {
            this.exceptionType = exceptionType;
        }
    }
}

