/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GwtJavaScriptOutputStyle {
    OBFUSCATED("OBF", "Obfuscated", 1),
    PRETTY("PRETTY", "Pretty", 2),
    DETAILED("DETAILED", "Detailed", 3);

    @NonNls
    private final String myId;
    private final int myNumericId;
    private final String myPresentableName;

    private GwtJavaScriptOutputStyle(String id, String presentableName, int numericId) {
        this.myPresentableName = presentableName;
        this.myId = id;
        this.myNumericId = numericId;
    }

    public String getId() {
        return this.myId;
    }

    public int getNumericId() {
        return this.myNumericId;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/GwtJavaScriptOutputStyle", "getPresentableName"));
        }
        return string;
    }

    public String toString() {
        return this.myId;
    }

    @Nullable
    public static GwtJavaScriptOutputStyle byId(int id) {
        for (GwtJavaScriptOutputStyle style : GwtJavaScriptOutputStyle.values()) {
            if (style.getNumericId() != id) continue;
            return style;
        }
        return null;
    }

    @Nullable
    public static GwtJavaScriptOutputStyle byId(@Nullable String id) {
        for (GwtJavaScriptOutputStyle style : GwtJavaScriptOutputStyle.values()) {
            if (!style.getId().equals(id)) continue;
            return style;
        }
        return null;
    }
}

