/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v4;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.socksx.v4.Socks4CmdType;
import io.netty.handler.codec.socksx.v4.Socks4Request;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import java.net.IDN;

public final class Socks4CmdRequest
extends Socks4Request {
    private final String userId;
    private final Socks4CmdType cmdType;
    private final String host;
    private final int port;
    private static final byte[] IPv4_DOMAIN_MARKER = new byte[]{0, 0, 0, 1};

    public Socks4CmdRequest(String userId, Socks4CmdType cmdType, String host, int port) {
        if (userId == null) {
            throw new NullPointerException("username");
        }
        if (cmdType == null) {
            throw new NullPointerException("cmdType");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        if (port <= 0 || port >= 65536) {
            throw new IllegalArgumentException(port + " is not in bounds 0 < x < 65536");
        }
        this.userId = userId;
        this.cmdType = cmdType;
        this.host = IDN.toASCII(host);
        this.port = port;
    }

    public Socks4CmdRequest(Socks4CmdType cmdType, String host, int port) {
        this("", cmdType, host, port);
    }

    public Socks4CmdType cmdType() {
        return this.cmdType;
    }

    public String host() {
        return IDN.toUnicode(this.host);
    }

    public String userId() {
        return this.userId;
    }

    public int port() {
        return this.port;
    }

    @Override
    void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.protocolVersion().byteValue());
        byteBuf.writeByte(this.cmdType.byteValue());
        byteBuf.writeShort(this.port);
        if (NetUtil.isValidIpV4Address(this.host)) {
            byteBuf.writeBytes(NetUtil.createByteArrayFromIpAddressString(this.host));
            byteBuf.writeBytes(this.userId.getBytes());
            byteBuf.writeZero(1);
        } else {
            byteBuf.writeBytes(IPv4_DOMAIN_MARKER);
            byteBuf.writeBytes(this.userId.getBytes());
            byteBuf.writeZero(1);
            byteBuf.writeBytes(this.host.getBytes(CharsetUtil.US_ASCII));
            byteBuf.writeZero(1);
        }
    }
}

