/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class FieldAccessor
implements Accessor {
    private final Field myField;

    public FieldAccessor(@NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/util/xmlb/FieldAccessor", "<init>"));
        }
        this.myField = field;
        field.setAccessible(true);
    }

    @Override
    public Object read(Object o) {
        assert (this.myField.getDeclaringClass().isInstance(o)) : "Wrong class: " + o.getClass() + "; should be: " + this.myField.getDeclaringClass();
        try {
            return this.myField.get(o);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Reading " + this.myField, e);
        }
    }

    @Override
    public void write(Object o, Object value) {
        Class<?> declaringClass = this.myField.getDeclaringClass();
        assert (declaringClass.isInstance(o)) : "Wrong class: " + o.getClass() + "; should be: " + declaringClass;
        try {
            Class<?> type = this.myField.getType();
            this.myField.set(o, XmlSerializerImpl.convert(value, type));
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        Annotation[] annotationArray = this.myField.getAnnotations();
        if (annotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/FieldAccessor", "getAnnotations"));
        }
        return annotationArray;
    }

    @Override
    public String getName() {
        return this.myField.getName();
    }

    @Override
    public Class<?> getValueClass() {
        return this.myField.getType();
    }

    @Override
    public Type getGenericType() {
        return this.myField.getGenericType();
    }

    @NonNls
    public String toString() {
        return "FieldAccessor[" + this.myField.getDeclaringClass() + "." + this.myField.getName() + "]";
    }
}

