/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.maven.compiler.MavenResourceFileProcessor;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceRootDescriptor;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTarget;
import org.jetbrains.jps.maven.model.impl.MavenResourcesTargetType;

public class MavenResourcesBuilder
extends TargetBuilder<MavenResourceRootDescriptor, MavenResourcesTarget> {
    public static final String BUILDER_NAME = "Maven Resources Compiler";

    public MavenResourcesBuilder() {
        super(Arrays.asList(MavenResourcesTargetType.PRODUCTION, MavenResourcesTargetType.TEST));
    }

    public void build(final @NotNull MavenResourcesTarget target, @NotNull DirtyFilesHolder<MavenResourceRootDescriptor, MavenResourcesTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder", "build"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder", "build"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder", "build"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder", "build"));
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        MavenProjectConfiguration projectConfig = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
        MavenModuleResourceConfiguration config = target.getModuleResourcesConfiguration(dataPaths);
        if (config == null) {
            return;
        }
        final HashMap files = new HashMap();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<MavenResourceRootDescriptor, MavenResourcesTarget>(){

            public boolean apply(MavenResourcesTarget t, File file, MavenResourceRootDescriptor rd) throws IOException {
                assert (target == t);
                ArrayList<File> fileList = (ArrayList<File>)files.get((Object)rd);
                if (fileList == null) {
                    fileList = new ArrayList<File>();
                    files.put(rd, fileList);
                }
                fileList.add(file);
                return true;
            }
        });
        MavenResourceRootDescriptor[] roots = files.keySet().toArray(new MavenResourceRootDescriptor[files.keySet().size()]);
        Arrays.sort(roots, new Comparator<MavenResourceRootDescriptor>(){

            @Override
            public int compare(MavenResourceRootDescriptor r1, MavenResourceRootDescriptor r2) {
                int res = r1.getIndexInPom() - r2.getIndexInPom();
                if (r1.isOverwrite()) {
                    assert (r2.isOverwrite());
                    return res;
                }
                if (r1.getConfiguration().isFiltered && !r2.getConfiguration().isFiltered) {
                    return 1;
                }
                if (!r1.getConfiguration().isFiltered && r2.getConfiguration().isFiltered) {
                    return -1;
                }
                if (!r1.getConfiguration().isFiltered) {
                    res = -res;
                }
                return res;
            }
        });
        MavenResourceFileProcessor fileProcessor = new MavenResourceFileProcessor(projectConfig, target.getModule().getProject(), config);
        for (MavenResourceRootDescriptor rd : roots) {
            for (File file : (List)files.get((Object)rd)) {
                String relPath = FileUtil.getRelativePath((File)rd.getRootFile(), (File)file);
                if (relPath == null) continue;
                String outputDirectory = target.isTests() ? config.testOutputDirectory : config.outputDirectory;
                File outputDir = MavenResourcesTarget.getOutputDir(target.getModuleOutputDir(), rd.getConfiguration(), outputDirectory);
                if (outputDir == null) continue;
                File outputFile = new File(outputDir, relPath);
                String sourcePath = file.getPath();
                try {
                    context.processMessage((BuildMessage)new ProgressMessage("Copying resources... [" + target.getModule().getName() + "]"));
                    fileProcessor.copyFile(file, outputFile, rd.getConfiguration(), context, FileUtilRt.ALL_FILES);
                    outputConsumer.registerOutputFile(outputFile, Collections.singleton(sourcePath));
                }
                catch (UnsupportedEncodingException e) {
                    context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.INFO, "Resource was not copied: " + e.getMessage(), sourcePath));
                }
                if (!context.getCancelStatus().isCanceled()) continue;
                return;
            }
        }
        context.checkCanceled();
        context.processMessage((BuildMessage)new ProgressMessage(""));
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/compiler/MavenResourcesBuilder", "getPresentableName"));
        }
        return BUILDER_NAME;
    }
}

