/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;

public class OutputToTargetRegistry
extends AbstractStateStorage<Integer, TIntHashSet> {
    private static final DataExternalizer<TIntHashSet> DATA_EXTERNALIZER = new DataExternalizer<TIntHashSet>(){

        public void save(final @NotNull DataOutput out, TIntHashSet value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/incremental/storage/OutputToTargetRegistry$1", "save"));
            }
            final Ref exRef = Ref.create(null);
            value.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    try {
                        out.writeInt(value);
                    }
                    catch (IOException e) {
                        exRef.set((Object)e);
                        return false;
                    }
                    return true;
                }
            });
            IOException error = (IOException)exRef.get();
            if (error != null) {
                throw error;
            }
        }

        public TIntHashSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/incremental/storage/OutputToTargetRegistry$1", "read"));
            }
            TIntHashSet result = new TIntHashSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(in.readInt());
            }
            return result;
        }
    };

    OutputToTargetRegistry(@NonNls File storePath) throws IOException {
        super(storePath, new IntInlineKeyDescriptor(), DATA_EXTERNALIZER);
    }

    protected void addMapping(String outputPath, int buildTargetId) throws IOException {
        this.addMapping(Collections.singleton(outputPath), buildTargetId);
    }

    protected void addMapping(Collection<String> outputPaths, int buildTargetId) throws IOException {
        TIntHashSet set = new TIntHashSet();
        set.add(buildTargetId);
        for (String outputPath : outputPaths) {
            this.appendData(FileUtil.pathHashCode((String)outputPath), set);
        }
    }

    public void removeMapping(String outputPath, int buildTargetId) throws IOException {
        this.removeMapping(Collections.singleton(outputPath), buildTargetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapping(Collection<String> outputPaths, int buildTargetId) throws IOException {
        if (outputPaths.isEmpty()) {
            return;
        }
        for (String outputPath : outputPaths) {
            int key = FileUtil.pathHashCode((String)outputPath);
            Object object = this.myDataLock;
            synchronized (object) {
                TIntHashSet state = (TIntHashSet)this.getState(key);
                if (state != null) {
                    boolean removed = state.remove(buildTargetId);
                    if (state.isEmpty()) {
                        this.remove(key);
                    } else if (removed) {
                        this.update(key, state);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getSafeToDeleteOutputs(Collection<String> outputPaths, int currentTargetId) throws IOException {
        int size = outputPaths.size();
        if (size == 0) {
            return outputPaths;
        }
        ArrayList<String> result = new ArrayList<String>(size);
        for (String outputPath : outputPaths) {
            int key = FileUtil.pathHashCode((String)outputPath);
            Object object = this.myDataLock;
            synchronized (object) {
                TIntHashSet associatedTargets = (TIntHashSet)this.getState(key);
                if (associatedTargets == null || associatedTargets.size() != 1) {
                    continue;
                }
                if (associatedTargets.contains(currentTargetId)) {
                    result.add(outputPath);
                }
            }
        }
        return result;
    }
}

