/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import java.lang.reflect.Method;

class ProfilingHelper {
    private final Class<?> myControllerClass = Class.forName("com.yourkit.api.Controller");
    private final Object myController = this.myControllerClass.newInstance();

    ProfilingHelper() throws Exception {
    }

    public void startProfiling() {
        try {
            Method startMethod = this.myControllerClass.getDeclaredMethod("startCPUProfiling", Long.TYPE, String.class);
            if (startMethod != null) {
                startMethod.invoke(this.myController, 4L, null);
            } else {
                System.err.println("Cannot find method 'startCPUProfiling' in class " + this.myControllerClass.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void stopProfiling() {
        try {
            Method captureMethod = this.myControllerClass.getDeclaredMethod("captureSnapshot", Long.TYPE);
            if (captureMethod != null) {
                String path = (String)captureMethod.invoke(this.myController, 0L);
                System.err.println("CPU Snapshot captured: " + path);
                Method stopMethod = this.myControllerClass.getDeclaredMethod("stopCPUProfiling", new Class[0]);
                if (stopMethod != null) {
                    stopMethod.invoke(this.myController, new Object[0]);
                } else {
                    System.err.println("Cannot find method 'stopCPUProfiling' in class " + this.myControllerClass.getName());
                }
            } else {
                System.err.println("Cannot find method 'captureSnapshot' in class " + this.myControllerClass.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

