/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.Immutable;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.PositionImpl;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.manifmerger.XmlNode;
import com.android.utils.ILogger;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.LineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Immutable
public class Actions {
    static final String HEADER = "-- Merging decision tree log ---\n";
    private final ImmutableMap<XmlNode.NodeKey, DecisionTreeRecord> mRecords;

    public Actions(ImmutableMap<XmlNode.NodeKey, DecisionTreeRecord> records) {
        this.mRecords = records;
    }

    @NonNull
    public ImmutableList<NodeRecord> getNodeRecords(Element element) {
        XmlNode.NodeKey nodeKey = XmlNode.NodeKey.fromXml(element);
        return this.mRecords.containsKey((Object)nodeKey) ? ((DecisionTreeRecord)this.mRecords.get((Object)nodeKey)).getNodeRecords() : ImmutableList.of();
    }

    @NonNull
    public ImmutableSet<XmlNode.NodeKey> getNodeKeys() {
        return this.mRecords.keySet();
    }

    @NonNull
    public ImmutableList<NodeRecord> getNodeRecords(XmlNode.NodeKey key) {
        return this.mRecords.containsKey((Object)key) ? ((DecisionTreeRecord)this.mRecords.get((Object)key)).getNodeRecords() : ImmutableList.of();
    }

    @NonNull
    public ImmutableList<XmlNode.NodeName> getRecordedAttributeNames(XmlNode.NodeKey nodeKey) {
        DecisionTreeRecord decisionTreeRecord = (DecisionTreeRecord)this.mRecords.get((Object)nodeKey);
        if (decisionTreeRecord == null) {
            return ImmutableList.of();
        }
        return decisionTreeRecord.getAttributesRecords().keySet().asList();
    }

    @NonNull
    public ImmutableList<AttributeRecord> getAttributeRecords(XmlNode.NodeKey elementKey, XmlNode.NodeName attributeName) {
        DecisionTreeRecord decisionTreeRecord = (DecisionTreeRecord)this.mRecords.get((Object)elementKey);
        if (decisionTreeRecord == null) {
            return ImmutableList.of();
        }
        return decisionTreeRecord.getAttributeRecords(attributeName);
    }

    void log(ILogger logger) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HEADER);
        for (Map.Entry record : this.mRecords.entrySet()) {
            stringBuilder.append(record.getKey()).append("\n");
            for (NodeRecord nodeRecord : ((DecisionTreeRecord)record.getValue()).getNodeRecords()) {
                nodeRecord.print(stringBuilder);
                stringBuilder.append('\n');
            }
            for (Map.Entry<XmlNode.NodeName, List<AttributeRecord>> attributeRecords : ((DecisionTreeRecord)record.getValue()).mAttributeRecords.entrySet()) {
                stringBuilder.append('\t').append(attributeRecords.getKey()).append('\n');
                for (AttributeRecord attributeRecord : attributeRecords.getValue()) {
                    stringBuilder.append("\t\t");
                    attributeRecord.print(stringBuilder);
                    stringBuilder.append('\n');
                }
            }
        }
        logger.verbose(stringBuilder.toString(), new Object[0]);
    }

    public String persist() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element rootElement = document.createElement("manifest-merger-mappings");
        document.appendChild(rootElement);
        for (Map.Entry decisionTreeRecordEntry : this.mRecords.entrySet()) {
            Element elementActions = document.createElement("element-actions");
            elementActions.setAttribute("id", ((XmlNode.NodeKey)decisionTreeRecordEntry.getKey()).toString());
            ((DecisionTreeRecord)decisionTreeRecordEntry.getValue()).toXml(elementActions);
            rootElement.appendChild(elementActions);
        }
        return XmlPrettyPrinter.prettyPrint((Node)document, (boolean)false);
    }

    @Nullable
    public static Actions load(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        return Actions.load(new PositionXmlParser().parse(inputStream));
    }

    @Nullable
    public static Actions load(String xml) throws IOException, SAXException, ParserConfigurationException {
        return Actions.load(new PositionXmlParser().parse(xml));
    }

    @Nullable
    private static Actions load(Document document) throws IOException {
        if (document == null) {
            return null;
        }
        Element rootElement = document.getDocumentElement();
        if (!rootElement.getNodeName().equals("manifest-merger-mappings")) {
            throw new IOException("File is not a manifest-merger-mappings");
        }
        ImmutableMap.Builder records = ImmutableMap.builder();
        NodeList elementActions = rootElement.getChildNodes();
        for (int i = 0; i < elementActions.getLength(); ++i) {
            if (elementActions.item(i).getNodeType() != 1) continue;
            Element elementAction = (Element)elementActions.item(i);
            XmlNode.NodeKey key = new XmlNode.NodeKey(elementAction.getAttribute("id"));
            DecisionTreeRecord decisionTreeRecord = new DecisionTreeRecord(elementAction);
            records.put((Object)key, (Object)decisionTreeRecord);
        }
        return new Actions((ImmutableMap<XmlNode.NodeKey, DecisionTreeRecord>)records.build());
    }

    private static Element getFirstChildElement(Element element) {
        Node child = element.getFirstChild();
        while (child.getNodeType() != 1) {
            child = child.getNextSibling();
        }
        return (Element)child;
    }

    private static Element getNextSiblingElement(Element element) {
        Node sibling;
        for (sibling = element.getNextSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getNextSibling()) {
        }
        return (Element)sibling;
    }

    public ImmutableMultimap<Integer, Record> getResultingSourceMapping(XmlDocument xmlDocument) throws ParserConfigurationException, SAXException, IOException {
        XmlLoader.SourceLocation inMemory = XmlLoader.UNKNOWN;
        XmlDocument loadedWithLineNumbers = XmlLoader.load(xmlDocument.getSelectors(), xmlDocument.getSystemPropertyResolver(), inMemory, xmlDocument.prettyPrint(), XmlDocument.Type.MAIN, (Optional<String>)Optional.absent());
        ImmutableMultimap.Builder mappingBuilder = ImmutableMultimap.builder();
        for (XmlElement xmlElement : loadedWithLineNumbers.getRootNode().getMergeableElements()) {
            this.parse(xmlElement, (ImmutableMultimap.Builder<Integer, Record>)mappingBuilder);
        }
        return mappingBuilder.build();
    }

    private void parse(XmlElement element, ImmutableMultimap.Builder<Integer, Record> mappings) {
        DecisionTreeRecord decisionTreeRecord = (DecisionTreeRecord)this.mRecords.get((Object)element.getId());
        if (decisionTreeRecord != null) {
            NodeRecord nodeRecord = Actions.findNodeRecord(decisionTreeRecord);
            if (nodeRecord != null) {
                mappings.put((Object)element.getPosition().getLine(), (Object)nodeRecord);
            }
            for (XmlAttribute xmlAttribute : element.getAttributes()) {
                AttributeRecord attributeRecord = Actions.findAttributeRecord(decisionTreeRecord, xmlAttribute);
                if (attributeRecord == null) continue;
                mappings.put((Object)xmlAttribute.getPosition().getLine(), (Object)attributeRecord);
            }
        }
        for (XmlElement xmlElement : element.getMergeableElements()) {
            this.parse(xmlElement, mappings);
        }
    }

    public String blame(XmlDocument xmlDocument) throws IOException, SAXException, ParserConfigurationException {
        String line;
        ImmutableMultimap<Integer, Record> resultingSourceMapping = this.getResultingSourceMapping(xmlDocument);
        LineReader lineReader = new LineReader((Readable)new StringReader(xmlDocument.prettyPrint()));
        StringBuilder actualMappings = new StringBuilder();
        int count = 1;
        while ((line = lineReader.readLine()) != null) {
            actualMappings.append(count).append(line).append("\n");
            if (resultingSourceMapping.containsKey((Object)count)) {
                for (Record record : resultingSourceMapping.get((Object)count)) {
                    actualMappings.append(count).append("-->").append(record.getActionLocation().toString()).append("\n");
                }
            }
            ++count;
        }
        return actualMappings.toString();
    }

    @Nullable
    private static NodeRecord findNodeRecord(DecisionTreeRecord decisionTreeRecord) {
        for (NodeRecord nodeRecord : decisionTreeRecord.getNodeRecords()) {
            if (nodeRecord.getActionType() != ActionType.ADDED) continue;
            return nodeRecord;
        }
        return null;
    }

    @Nullable
    private static AttributeRecord findAttributeRecord(DecisionTreeRecord decisionTreeRecord, XmlAttribute xmlAttribute) {
        for (AttributeRecord attributeRecord : decisionTreeRecord.getAttributeRecords(xmlAttribute.getName())) {
            if (attributeRecord.getActionType() != ActionType.ADDED) continue;
            return attributeRecord;
        }
        return null;
    }

    static class DecisionTreeRecord {
        private final List<NodeRecord> mNodeRecords = new ArrayList<NodeRecord>();
        final Map<XmlNode.NodeName, List<AttributeRecord>> mAttributeRecords = new HashMap<XmlNode.NodeName, List<AttributeRecord>>();

        ImmutableList<NodeRecord> getNodeRecords() {
            return ImmutableList.copyOf(this.mNodeRecords);
        }

        ImmutableMap<XmlNode.NodeName, List<AttributeRecord>> getAttributesRecords() {
            return ImmutableMap.copyOf(this.mAttributeRecords);
        }

        DecisionTreeRecord() {
        }

        DecisionTreeRecord(Element elementAction) {
            Preconditions.checkArgument((boolean)elementAction.getNodeName().equals("element-actions"));
            NodeList childNodes = elementAction.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeName().equals("node-records")) {
                    NodeList nodeRecords = child.getChildNodes();
                    for (int j = 0; j < nodeRecords.getLength(); ++j) {
                        if (nodeRecords.item(j).getNodeType() != 1) continue;
                        NodeRecord nodeRecord = new NodeRecord((Element)nodeRecords.item(j));
                        this.mNodeRecords.add(nodeRecord);
                    }
                    continue;
                }
                if (!child.getNodeName().equals("attribute-records")) continue;
                Element id = Actions.getFirstChildElement((Element)child);
                XmlNode.NodeName nodeName = Strings.isNullOrEmpty((String)id.getAttribute("name")) ? XmlNode.fromNSName(id.getAttribute("namespace-uri"), id.getAttribute("prefix"), id.getAttribute("local-name")) : XmlNode.fromXmlName(id.getAttribute("name"));
                Element record = id;
                ImmutableList.Builder attributeRecords = ImmutableList.builder();
                while ((record = Actions.getNextSiblingElement(record)) != null) {
                    AttributeRecord attributeRecord = new AttributeRecord(record);
                    attributeRecords.add((Object)attributeRecord);
                }
                this.mAttributeRecords.put(nodeName, (List<AttributeRecord>)attributeRecords.build());
            }
        }

        void addNodeRecord(NodeRecord nodeRecord) {
            this.mNodeRecords.add(nodeRecord);
        }

        ImmutableList<AttributeRecord> getAttributeRecords(XmlNode.NodeName attributeName) {
            List<AttributeRecord> attributeRecords = this.mAttributeRecords.get(attributeName);
            return attributeRecords == null ? ImmutableList.of() : ImmutableList.copyOf(attributeRecords);
        }

        public void toXml(Element elementAction) {
            Document document = elementAction.getOwnerDocument();
            Element nodeRecords = document.createElement("node-records");
            elementAction.appendChild(nodeRecords);
            for (NodeRecord nodeRecord : this.mNodeRecords) {
                Element xmlNode = nodeRecord.toXml(document);
                nodeRecords.appendChild(xmlNode);
            }
            for (Map.Entry entry : this.mAttributeRecords.entrySet()) {
                Element attributeRecords = document.createElement("attribute-records");
                elementAction.appendChild(attributeRecords);
                Element id = document.createElement("id");
                ((XmlNode.NodeName)entry.getKey()).persistTo(id);
                attributeRecords.appendChild(id);
                for (AttributeRecord attributeRecord : (List)entry.getValue()) {
                    Element xmlAttributeRecord = attributeRecord.toXml(document);
                    attributeRecords.appendChild(xmlAttributeRecord);
                }
            }
        }
    }

    public static final class ActionLocation {
        private final XmlLoader.SourceLocation mSourceLocation;
        private final PositionXmlParser.Position mPosition;

        public ActionLocation(@NonNull XmlLoader.SourceLocation sourceLocation, @NonNull PositionXmlParser.Position position) {
            this.mSourceLocation = (XmlLoader.SourceLocation)Preconditions.checkNotNull((Object)sourceLocation);
            this.mPosition = (PositionXmlParser.Position)Preconditions.checkNotNull((Object)position);
        }

        ActionLocation(Element xml) {
            Element location = Actions.getFirstChildElement(xml);
            this.mSourceLocation = XmlLoader.locationFromXml(location);
            this.mPosition = PositionImpl.fromXml(Actions.getNextSiblingElement(location));
        }

        public PositionXmlParser.Position getPosition() {
            return this.mPosition;
        }

        public XmlLoader.SourceLocation getSourceLocation() {
            return this.mSourceLocation;
        }

        public String toString() {
            return this.mSourceLocation.print(true) + ":" + this.mPosition.getLine() + ":" + this.mPosition.getColumn();
        }

        public Node toXml(Element location) {
            location.appendChild(this.mSourceLocation.toXml(location.getOwnerDocument()));
            location.appendChild(PositionImpl.toXml(this.mPosition, location.getOwnerDocument()));
            return location;
        }
    }

    public static class AttributeRecord
    extends Record {
        private final AttributeOperationType mOperationType;

        AttributeRecord(@NonNull ActionType actionType, @NonNull ActionLocation actionLocation, @NonNull XmlNode.NodeKey targetId, @Nullable String reason, @Nullable AttributeOperationType operationType) {
            super(actionType, actionLocation, targetId, reason);
            this.mOperationType = operationType;
        }

        AttributeRecord(@NonNull Element xml) {
            super(xml);
            this.mOperationType = AttributeOperationType.valueOf(xml.getAttribute("opType"));
        }

        @Nullable
        public AttributeOperationType getOperationType() {
            return this.mOperationType;
        }

        @Override
        protected void addAttributes(Element element) {
            if (this.mOperationType != null) {
                element.setAttribute("opType", this.mOperationType.toString());
            }
        }

        public String toString() {
            return "Id=" + this.mTargetId + " actionType=" + (Object)((Object)this.getActionType()) + " location=" + this.getActionLocation() + " opType=" + (Object)((Object)this.getOperationType());
        }
    }

    public static class NodeRecord
    extends Record {
        private final NodeOperationType mNodeOperationType;

        NodeRecord(@NonNull ActionType actionType, @NonNull ActionLocation actionLocation, @NonNull XmlNode.NodeKey targetId, @Nullable String reason, @NonNull NodeOperationType nodeOperationType) {
            super(actionType, actionLocation, targetId, reason);
            this.mNodeOperationType = (NodeOperationType)Preconditions.checkNotNull((Object)nodeOperationType);
        }

        NodeRecord(@NonNull Element xml) {
            super(xml);
            this.mNodeOperationType = NodeOperationType.valueOf(xml.getAttribute("opType"));
        }

        @Override
        protected void addAttributes(Element element) {
            element.setAttribute("opType", this.mNodeOperationType.toString());
        }

        public String toString() {
            return "Id=" + this.mTargetId.toString() + " actionType=" + (Object)((Object)this.getActionType()) + " location=" + this.getActionLocation() + " opType=" + this.mNodeOperationType;
        }
    }

    public static abstract class Record {
        @NonNull
        protected final ActionType mActionType;
        @NonNull
        protected final ActionLocation mActionLocation;
        @NonNull
        protected final XmlNode.NodeKey mTargetId;
        @Nullable
        protected final String mReason;

        private Record(@NonNull ActionType actionType, @NonNull ActionLocation actionLocation, @NonNull XmlNode.NodeKey targetId, @Nullable String reason) {
            this.mActionType = (ActionType)((Object)Preconditions.checkNotNull((Object)((Object)actionType)));
            this.mActionLocation = (ActionLocation)Preconditions.checkNotNull((Object)actionLocation);
            this.mTargetId = (XmlNode.NodeKey)Preconditions.checkNotNull((Object)targetId);
            this.mReason = reason;
        }

        private Record(@NonNull Element xml) {
            this.mActionType = ActionType.valueOf(xml.getAttribute("action-type"));
            this.mActionLocation = new ActionLocation(Actions.getFirstChildElement(xml));
            this.mTargetId = new XmlNode.NodeKey(xml.getAttribute("target-id"));
            String reason = xml.getAttribute("reason");
            this.mReason = Strings.isNullOrEmpty((String)reason) ? null : reason;
        }

        public ActionType getActionType() {
            return this.mActionType;
        }

        public ActionLocation getActionLocation() {
            return this.mActionLocation;
        }

        public XmlNode.NodeKey getTargetId() {
            return this.mTargetId;
        }

        public void print(StringBuilder stringBuilder) {
            stringBuilder.append((Object)this.mActionType).append(" from ").append(this.mActionLocation);
            if (this.mReason != null) {
                stringBuilder.append(" reason: ").append(this.mReason);
            }
        }

        public Element toXml(Document document) {
            Element record = document.createElement("record");
            record.setAttribute("action-type", this.mActionType.toString());
            record.setAttribute("target-id", this.mTargetId.toString());
            if (this.mReason != null) {
                record.setAttribute("reason", this.mReason);
            }
            this.addAttributes(record);
            Element location = document.createElement("location");
            record.appendChild(this.mActionLocation.toXml(location));
            record.appendChild(location);
            return record;
        }

        protected abstract void addAttributes(Element var1);
    }

    static enum ActionType {
        ADDED,
        INJECTED,
        MERGED,
        REJECTED,
        IMPLIED;

    }
}

