/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.AjJpsCompiler;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;

public class AjCompilerMessageHandler
extends MessageHandler {
    private static final Pattern PROGRESS = Pattern.compile("compiling (.+)");
    private static final Pattern WOVEN_CLASS = Pattern.compile("woven class (.+) \\(from (.+)\\)");
    private final CompileContext myContext;
    @Nullable
    private final ModuleLevelBuilder.OutputConsumer myOutputConsumer;
    @NotNull
    private final ModuleBuildTarget myTarget;
    private boolean myHasErrors;

    public AjCompilerMessageHandler(@NotNull CompileContext context, @Nullable ModuleLevelBuilder.OutputConsumer outputConsumer, @NotNull ModuleBuildTarget target) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/aspectj/build/AjCompilerMessageHandler", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/aspectj/build/AjCompilerMessageHandler", "<init>"));
        }
        this.myHasErrors = false;
        this.myContext = context;
        this.myOutputConsumer = outputConsumer;
        this.myTarget = target;
    }

    public boolean hasErrors() {
        return this.myHasErrors;
    }

    public boolean handleMessage(IMessage iMessage) {
        IMessage.Kind kind = iMessage.getKind();
        String text = iMessage.getMessage();
        ISourceLocation source = iMessage.getSourceLocation();
        if (AjJpsCompiler.LOG.isDebugEnabled()) {
            AjJpsCompiler.LOG.debug(kind + ": '" + text + "' @" + source);
        }
        if (IMessage.Kind.COMPARATOR.compare(kind, IMessage.ERROR) >= 0) {
            this.myHasErrors = true;
        }
        WeaveMessage message = null;
        if (kind == IMessage.INFO) {
            Matcher woven;
            Matcher matcher = PROGRESS.matcher(text);
            if (matcher.matches()) {
                String path = matcher.group(1);
                message = new ProgressMessage(AjJpsBundle.message("aj.progress.compiling", PathUtilRt.getFileName((String)path)));
            } else if (this.myOutputConsumer != null && (woven = WOVEN_CLASS.matcher(text)).matches()) {
                String className = woven.group(1);
                String sourcePath = woven.group(2);
                File outputFile = new File(this.myTarget.getOutputDir(), className.replace('.', File.separatorChar) + ".class");
                try {
                    this.myOutputConsumer.registerOutputFile((BuildTarget)this.myTarget, outputFile, Collections.singletonList(sourcePath));
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
            }
        } else if (kind == IMessage.WEAVEINFO) {
            message = new WeaveMessage(text);
        } else if (kind == IMessage.WARNING || kind == IMessage.ERROR) {
            BuildMessage.Kind jpsKind;
            BuildMessage.Kind kind2 = jpsKind = kind == IMessage.ERROR ? BuildMessage.Kind.ERROR : BuildMessage.Kind.WARNING;
            if (source != null && source != ISourceLocation.EMPTY) {
                int line = source.getLine();
                int column = source.getColumn();
                message = new CompilerMessage("ajc", jpsKind, text, source.getSourceFile().getPath(), -1L, -1L, -1L, (long)line, (long)column);
            } else {
                message = new CompilerMessage("ajc", jpsKind, text);
            }
        } else if (kind == IMessage.FAIL || kind == IMessage.ABORT) {
            message = new CompilerMessage("ajc", BuildMessage.Kind.ERROR, AjJpsBundle.message("aj.internal", text));
        }
        if (message != null) {
            this.myContext.processMessage((BuildMessage)message);
        }
        return super.handleMessage(iMessage);
    }

    public static class WeaveMessage
    extends CompilerMessage {
        public WeaveMessage(String messageText) {
            super("ajc", BuildMessage.Kind.INFO, messageText);
        }
    }
}

