/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import aQute.bnd.osgi.Analyzer;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.jps.build.FakeAnalyzer;

public class LocalPackageCollector {
    private static final String LOCAL_PACKAGES = "{local-packages}";

    public static void addLocalPackages(File outputDirectory, Map<String, String> currentManifest) {
        FakeAnalyzer fakeAnalyzer = new FakeAnalyzer(currentManifest);
        LocalPackageCollector.addLocalPackages(outputDirectory, fakeAnalyzer);
    }

    private static void addLocalPackages(File outputDirectory, Analyzer analyzer) {
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        if (outputDirectory != null && outputDirectory.isDirectory()) {
            String[] paths;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(outputDirectory);
            scanner.setIncludes(new String[]{"**/*.class"});
            scanner.addDefaultExcludes();
            scanner.scan();
            for (String path : paths = scanner.getIncludedFiles()) {
                packages.add(LocalPackageCollector.getPackageName(path));
            }
        }
        StringBuilder exportedPackages = new StringBuilder();
        StringBuilder privatePackages = new StringBuilder();
        boolean noPrivatePackages = "!*".equals(analyzer.getProperty("Private-Package"));
        Iterator i$ = packages.iterator();
        while (i$.hasNext()) {
            String aPackage;
            String pkg = aPackage = (String)i$.next();
            if (privatePackages.length() > 0) {
                privatePackages.append(';');
            }
            privatePackages.append(pkg);
            if (!noPrivatePackages && (".".equals(pkg) || pkg.contains(".internal") || pkg.contains(".impl"))) continue;
            if (exportedPackages.length() > 0) {
                exportedPackages.append(';');
            }
            exportedPackages.append(pkg);
        }
        if (analyzer.getProperty("Export-Package") == null) {
            if (analyzer.getProperty("-exportcontents") == null) {
                analyzer.setProperty("Export-Package", exportedPackages + ";-split-package:=merge-first");
            } else {
                analyzer.setProperty("Export-Package", "");
            }
        } else {
            String exported = analyzer.getProperty("Export-Package");
            if (exported.contains(LOCAL_PACKAGES)) {
                String newExported = StringUtil.replace((String)exported, (String)LOCAL_PACKAGES, (String)exportedPackages.toString());
                analyzer.setProperty("Export-Package", newExported);
            }
        }
        String internal = analyzer.getProperty("Private-Package");
        if (internal == null) {
            if (privatePackages.length() > 0) {
                analyzer.setProperty("Private-Package", privatePackages + ";-split-package:=merge-first");
            } else {
                analyzer.setProperty("Private-Package", "!*");
            }
        } else if (internal.contains(LOCAL_PACKAGES)) {
            String newInternal = StringUtil.replace((String)internal, (String)LOCAL_PACKAGES, (String)privatePackages.toString());
            analyzer.setProperty("Private-Package", newInternal);
        }
    }

    @NotNull
    private static String getPackageName(@NotNull String filename) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "org/jetbrains/osgi/jps/build/LocalPackageCollector", "getPackageName"));
        }
        int n = filename.lastIndexOf(File.separatorChar);
        String string = n < 0 ? "." : filename.substring(0, n).replace(File.separatorChar, '.');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/LocalPackageCollector", "getPackageName"));
        }
        return string;
    }
}

