/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjBuilderBase;
import com.intellij.lang.aspectj.build.AjCompilerMessageHandler;
import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsModuleSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.IUnwovenClassFile;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.WeavingAdaptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;

public class AjJpsWeaver {
    private static final Logger LOG = Logger.getInstance(AjJpsWeaver.class);
    private final CompileContext myContext;
    private final ModuleChunk myChunk;
    private final ModuleLevelBuilder.OutputConsumer myConsumer;
    private final ModuleBuildTarget myTarget;
    private final AjCompilerSettings myCompilerSettings;
    private final AjModuleSettings myModuleSettings;

    public AjJpsWeaver(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull ModuleLevelBuilder.OutputConsumer consumer, @NotNull ModuleBuildTarget target, @NotNull AjCompilerSettings settings) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/aspectj/build/AjJpsWeaver", "<init>"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/intellij/lang/aspectj/build/AjJpsWeaver", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/aspectj/build/AjJpsWeaver", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/aspectj/build/AjJpsWeaver", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/aspectj/build/AjJpsWeaver", "<init>"));
        }
        this.myContext = context;
        this.myChunk = chunk;
        this.myConsumer = consumer;
        this.myTarget = target;
        this.myCompilerSettings = settings;
        this.myModuleSettings = AjJpsModuleSettings.getSettings(target.getModule());
    }

    public ModuleLevelBuilder.ExitCode build() throws ProjectBuildException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting weaver for target: " + this.myTarget);
        }
        this.myContext.processMessage((BuildMessage)new ProgressMessage(AjJpsBundle.message("aj.progress.weaving", new Object[0])));
        AjCompilerMessageHandler mh = new AjCompilerMessageHandler(this.myContext, null, this.myTarget);
        mh.dontIgnore(IMessage.INFO);
        if (ParametersListUtil.parse((String)this.myCompilerSettings.cmdLineParams).contains("-showWeaveInfo")) {
            mh.dontIgnore(IMessage.WEAVEINFO);
        }
        String targetDir = AjBuilderBase.getTargetDir(this.myTarget);
        Couple<List<String>> paths = AjBuilderBase.getPaths(this.myChunk, this.myTarget, this.myCompilerSettings, this.myModuleSettings);
        ((List)paths.second).add(targetDir);
        MyWeavingAdaptor weaver = new MyWeavingAdaptor(paths, targetDir, mh);
        weaver.weaveClasses(this.myConsumer, this.myTarget);
        mh.clearMessages();
        return mh.hasErrors() ? ModuleLevelBuilder.ExitCode.ABORT : ModuleLevelBuilder.ExitCode.OK;
    }

    private static class MyWeavingAdaptor
    extends WeavingAdaptor {
        private static final GeneratedClassHandler dummyClassHandler = (GeneratedClassHandler)Proxy.newProxyInstance(AjJpsWeaver.class.getClassLoader(), new Class[]{GeneratedClassHandler.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
        private final String myTargetDir;
        private final Collection<CompiledClass> myGeneratedClasses;

        public MyWeavingAdaptor(Couple<List<String>> paths, String targetDir, AjCompilerMessageHandler mh) {
            super(dummyClassHandler, MyWeavingAdaptor.toUrls((List)paths.first), MyWeavingAdaptor.toUrls((List)paths.second));
            this.myTargetDir = targetDir;
            this.myGeneratedClasses = ContainerUtil.newArrayList();
            this.setMessageHandler((IMessageHandler)mh);
        }

        private static URL[] toUrls(List<String> paths) {
            try {
                ArrayList urls = ContainerUtil.newArrayListWithCapacity((int)paths.size());
                String prefix = SystemInfo.isWindows ? "file:///" : "file://";
                for (String path : paths) {
                    urls.add(new URL(prefix + path));
                }
                return urls.toArray(new URL[urls.size()]);
            }
            catch (MalformedURLException e) {
                throw new AjBuilderBase.AjBuildException(e.getMessage());
            }
        }

        public void weaveClasses(ModuleLevelBuilder.OutputConsumer consumer, ModuleBuildTarget target) throws IOException {
            Map compiledClasses = consumer.getCompiledClasses();
            for (CompiledClass compiledClass : compiledClasses.values()) {
                this.weaveClass(compiledClass, compiledClasses);
            }
            for (CompiledClass generatedClass : this.myGeneratedClasses) {
                generatedClass.save();
                consumer.registerCompiledClass((BuildTarget)target, generatedClass);
            }
        }

        private void weaveClass(CompiledClass compiledClass, Map<String, CompiledClass> compiledClasses) throws IOException {
            HashSet prevClasses = ContainerUtil.newHashSet(this.generatedClasses.keySet());
            byte[] original = compiledClass.getContent().getBuffer();
            byte[] woven = this.weaveClass(compiledClass.getClassName(), original);
            if (woven != original) {
                compiledClass.setContent(new BinaryContent(woven));
            }
            for (Map.Entry entry : this.generatedClasses.entrySet()) {
                String generatedClassName = (String)entry.getKey();
                if (prevClasses.contains(generatedClassName) || compiledClasses.containsKey(generatedClassName)) continue;
                File file = new File(this.myTargetDir, ((String)entry.getKey()).replace('.', File.separatorChar) + ".class");
                BinaryContent content = new BinaryContent(((IUnwovenClassFile)entry.getValue()).getBytes());
                CompiledClass generatedClass = new CompiledClass(file, compiledClass.getSourceFile(), generatedClassName, content);
                this.myGeneratedClasses.add(generatedClass);
            }
        }
    }
}

