/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build.config;

import com.intellij.lang.aspectj.build.config.AjPathEntries;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjCompilerSettings {
    public static final String COMPONENT_NAME = "AjcSettings";
    public static final String COMPONENT_FILE = "compiler.xml";
    public String ajcPath = "";
    public String heapSize = "";
    public boolean debugInfo = true;
    public String cmdLineParams = "";
    public boolean explicitAspectPath = false;
    @AbstractCollection(surroundWithTag=false, elementTypes={AjPathEntries.AppLibraryEntry.class, AjPathEntries.ProjectLibraryEntry.class, AjPathEntries.ModuleEntry.class})
    public List<AjPathEntries.Entry> aspectPath = ContainerUtilRt.newArrayList();
    public boolean delegateToJavac = false;
    public boolean aptOptionsEnabled = false;

    public static void addFilteredCompilerOptions(@NotNull Collection<String> options, @NotNull AjCompilerSettings settings) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/aspectj/build/config/AjCompilerSettings", "addFilteredCompilerOptions"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/aspectj/build/config/AjCompilerSettings", "addFilteredCompilerOptions"));
        }
        List params = ParametersListUtil.parse((String)settings.cmdLineParams);
        Iterator iterator = params.iterator();
        while (iterator.hasNext()) {
            String option = (String)iterator.next();
            if ("-target".equals(option)) {
                iterator.next();
                continue;
            }
            if (option.isEmpty() || "-g".equals(option) || "-verbose".equals(option)) continue;
            options.add(option);
        }
        if (settings.debugInfo) {
            options.add("-g");
        }
    }

    public void setOption(@NotNull @Language(value="RegExp") String pattern, @Nullable String option) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/lang/aspectj/build/config/AjCompilerSettings", "setOption"));
        }
        List params = ParametersListUtil.parse((String)this.cmdLineParams);
        boolean done = false;
        ListIterator<String> iterator = params.listIterator();
        while (iterator.hasNext()) {
            String param = (String)iterator.next();
            if (!param.matches(pattern)) continue;
            if (option != null) {
                iterator.set(option);
            } else {
                iterator.remove();
            }
            done = true;
            break;
        }
        if (!done && option != null) {
            params.add(option);
        }
        this.cmdLineParams = ParametersListUtil.join((List)params);
    }
}

