/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSCache;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.storage.TimestampStorage;
import org.jetbrains.jps.incremental.storage.Timestamps;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;

public class FSOperations {
    public static final GlobalContextKey<Set<File>> ALL_OUTPUTS_KEY = GlobalContextKey.create("_all_project_output_dirs_");

    public static boolean isMarkedDirty(CompileContext context, File file) throws IOException {
        JavaSourceRootDescriptor rd = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
        if (rd != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            return pd.fsState.isMarkedForRecompilation(context, rd, file);
        }
        return false;
    }

    public static void markDirty(CompileContext context, File file) throws IOException {
        JavaSourceRootDescriptor rd = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
        if (rd != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            pd.fsState.markDirty(context, file, rd, pd.timestamps.getStorage(), false);
        }
    }

    public static void markDirtyIfNotDeleted(CompileContext context, File file) throws IOException {
        JavaSourceRootDescriptor rd = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
        if (rd != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            pd.fsState.markDirtyIfNotDeleted(context, file, rd, pd.timestamps.getStorage());
        }
    }

    public static void markDeleted(CompileContext context, File file) throws IOException {
        JavaSourceRootDescriptor rd = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
        if (rd != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            pd.fsState.registerDeleted(rd.target, file, pd.timestamps.getStorage());
        }
    }

    public static void markDirty(CompileContext context, ModuleChunk chunk, @Nullable FileFilter filter) throws IOException {
        ProjectDescriptor pd = context.getProjectDescriptor();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            FSOperations.markDirtyFiles(context, target, pd.timestamps.getStorage(), true, null, filter);
        }
    }

    public static void markDirtyRecursively(CompileContext context, ModuleChunk chunk) throws IOException {
        Set<JpsModule> modules = chunk.getModules();
        Set<ModuleBuildTarget> targets = chunk.getTargets();
        HashSet<ModuleBuildTarget> dirtyTargets = new HashSet<ModuleBuildTarget>(targets);
        JpsJavaClasspathKind classpathKind = JpsJavaClasspathKind.compile((boolean)chunk.containsTests());
        boolean found = false;
        block0: for (BuildTargetChunk targetChunk : context.getProjectDescriptor().getBuildTargetIndex().getSortedTargetChunks(context)) {
            if (!found) {
                if (!((Object)targetChunk.getTargets()).equals(chunk.getTargets())) continue;
                found = true;
                continue;
            }
            for (BuildTarget<?> target : targetChunk.getTargets()) {
                Set<JpsModule> deps;
                if (!(target instanceof ModuleBuildTarget) || !Utils.intersects(deps = FSOperations.getDependentModulesRecursively(((ModuleBuildTarget)target).getModule(), classpathKind), modules)) continue;
                for (BuildTarget<?> buildTarget : targetChunk.getTargets()) {
                    if (!(buildTarget instanceof ModuleBuildTarget)) continue;
                    dirtyTargets.add((ModuleBuildTarget)buildTarget);
                }
                continue block0;
            }
        }
        TimestampStorage timestamps = context.getProjectDescriptor().timestamps.getStorage();
        for (ModuleBuildTarget target : dirtyTargets) {
            FSOperations.markDirtyFiles(context, target, timestamps, true, null, null);
        }
        if (JavaBuilderUtil.isCompileJavaIncrementally(context)) {
            for (ModuleBuildTarget target : targets) {
                context.markNonIncremental(target);
            }
        }
    }

    private static Set<JpsModule> getDependentModulesRecursively(JpsModule module, JpsJavaClasspathKind kind) {
        return JpsJavaExtensionService.dependencies((JpsModule)module).includedIn(kind).recursivelyExportedOnly().getModules();
    }

    public static void processFilesToRecompile(CompileContext context, ModuleChunk chunk, FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) throws IOException {
        for (ModuleBuildTarget target : chunk.getTargets()) {
            FSOperations.processFilesToRecompile(context, target, processor);
        }
    }

    public static void processFilesToRecompile(CompileContext context, @NotNull ModuleBuildTarget target, FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/incremental/FSOperations", "processFilesToRecompile"));
        }
        context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
    }

    static void markDirtyFiles(CompileContext context, BuildTarget<?> target, Timestamps timestamps, boolean forceMarkDirty, @Nullable THashSet<File> currentFiles, @Nullable FileFilter filter) throws IOException {
        for (BuildRootDescriptor rd : context.getProjectDescriptor().getBuildRootIndex().getTargetRoots(target, context)) {
            if (!rd.getRootFile().exists() || rd instanceof JavaSourceRootDescriptor && ((JavaSourceRootDescriptor)rd).isTemp) continue;
            if (filter == null) {
                context.getProjectDescriptor().fsState.clearRecompile(rd);
            }
            FSCache fsCache = rd.canUseFileCache() ? context.getProjectDescriptor().getFSCache() : FSCache.NO_CACHE;
            FSOperations.traverseRecursively(context, rd, rd.getRootFile(), timestamps, forceMarkDirty, currentFiles, filter, fsCache);
        }
    }

    private static void traverseRecursively(CompileContext context, BuildRootDescriptor rd, File file, @NotNull Timestamps tsStorage, boolean forceDirty, @Nullable Set<File> currentFiles, @Nullable FileFilter filter, @NotNull FSCache fsCache) throws IOException {
        if (tsStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tsStorage", "org/jetbrains/jps/incremental/FSOperations", "traverseRecursively"));
        }
        if (fsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fsCache", "org/jetbrains/jps/incremental/FSOperations", "traverseRecursively"));
        }
        BuildRootIndex rootIndex = context.getProjectDescriptor().getBuildRootIndex();
        File[] children = fsCache.getChildren(file);
        if (children != null) {
            if (children.length > 0 && rootIndex.isDirectoryAccepted(file, rd)) {
                for (File child : children) {
                    FSOperations.traverseRecursively(context, rd, child, tsStorage, forceDirty, currentFiles, filter, fsCache);
                }
            }
        } else if (rootIndex.isFileAccepted(file, rd) && (filter == null || filter.accept(file))) {
            boolean markDirty = forceDirty;
            if (!markDirty) {
                boolean bl = markDirty = tsStorage.getStamp(file, rd.getTarget()) != FileSystemUtil.lastModified((File)file);
            }
            if (markDirty) {
                Timestamps marker = context.isProjectRebuild() ? null : tsStorage;
                context.getProjectDescriptor().fsState.markDirty(context, file, rd, marker, false);
            }
            if (currentFiles != null) {
                currentFiles.add(file);
            }
        }
    }

    public static void pruneEmptyDirs(CompileContext context, @Nullable Set<File> dirsToDelete) {
        if (dirsToDelete == null || dirsToDelete.isEmpty()) {
            return;
        }
        Set doNotDelete = (Set)ALL_OUTPUTS_KEY.get(context);
        if (doNotDelete == null) {
            doNotDelete = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (BuildTarget<?> target : context.getProjectDescriptor().getBuildTargetIndex().getAllTargets()) {
                doNotDelete.addAll(target.getOutputRoots(context));
            }
            ALL_OUTPUTS_KEY.set(context, doNotDelete);
        }
        Set additionalDirs = null;
        Set<File> toDelete = dirsToDelete;
        while (toDelete != null) {
            for (File file : toDelete) {
                File parentFile;
                boolean deleted = !doNotDelete.contains(file) && file.delete();
                if (!deleted || (parentFile = file.getParentFile()) == null) continue;
                if (additionalDirs == null) {
                    additionalDirs = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                }
                additionalDirs.add(parentFile);
            }
            toDelete = additionalDirs;
            additionalDirs = null;
        }
    }
}

