/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Version {
    public final int major;
    public final int minor;
    public final int bugfix;

    public Version(int major, int minor, int bugfix) {
        this.bugfix = bugfix;
        this.minor = minor;
        this.major = major;
    }

    public boolean is(@Nullable Integer major) {
        return this.is(major, null);
    }

    public boolean is(@Nullable Integer major, @Nullable Integer minor) {
        return this.is(major, minor, null);
    }

    public boolean is(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        return this.compareTo(major, minor, bugfix) == 0;
    }

    public boolean isOrGreaterThan(@Nullable Integer major) {
        return this.isOrGreaterThan(major, null);
    }

    public boolean isOrGreaterThan(@Nullable Integer major, @Nullable Integer minor) {
        return this.isOrGreaterThan(major, minor, null);
    }

    public boolean isOrGreaterThan(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        return this.compareTo(major, minor, bugfix) >= 0;
    }

    public boolean lessThan(@Nullable Integer major) {
        return this.lessThan(major, null);
    }

    public boolean lessThan(@Nullable Integer major, @Nullable Integer minor) {
        return this.lessThan(major, minor, null);
    }

    public boolean lessThan(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        return this.compareTo(major, minor, bugfix) < 0;
    }

    public int compareTo(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/Version", "compareTo"));
        }
        return this.compareTo(version.major, version.minor, version.bugfix);
    }

    public int compareTo(@Nullable Integer major) {
        return this.compareTo(major, null);
    }

    public int compareTo(@Nullable Integer major, @Nullable Integer minor) {
        return this.compareTo(major, minor, null);
    }

    public int compareTo(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        int result = Version.doCompare(this.major, major);
        if (result != 0) {
            return result;
        }
        result = Version.doCompare(this.minor, minor);
        if (result != 0) {
            return result;
        }
        return Version.doCompare(this.bugfix, bugfix);
    }

    private static int doCompare(Integer l, Integer r) {
        if (l == null || r == null) {
            return 0;
        }
        return l - r;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.bugfix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.bugfix != version.bugfix) {
            return false;
        }
        if (this.major != version.major) {
            return false;
        }
        return this.minor == version.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.bugfix;
        return result;
    }
}

