/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.runConfigurations;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.hash.HashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfigurationType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsRunConfigurationPropertiesSerializer;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsUnknownRunConfigurationType;

public class JpsRunConfigurationSerializer {
    public static void loadRunConfigurations(@NotNull JpsProject project, @Nullable Element runManagerTag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/runConfigurations/JpsRunConfigurationSerializer", "loadRunConfigurations"));
        }
        HashMap serializers = new HashMap();
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsRunConfigurationPropertiesSerializer<?> jpsRunConfigurationPropertiesSerializer : extension.getRunConfigurationPropertiesSerializers()) {
                serializers.put(jpsRunConfigurationPropertiesSerializer.getTypeId(), jpsRunConfigurationPropertiesSerializer);
            }
        }
        for (Element configurationTag : JDOMUtil.getChildren((Element)runManagerTag, (String)"configuration")) {
            if (Boolean.parseBoolean(configurationTag.getAttributeValue("default"))) continue;
            String typeId = configurationTag.getAttributeValue("type");
            JpsRunConfigurationPropertiesSerializer jpsRunConfigurationPropertiesSerializer = (JpsRunConfigurationPropertiesSerializer)serializers.get(typeId);
            String name = configurationTag.getAttributeValue("name");
            if (jpsRunConfigurationPropertiesSerializer != null) {
                JpsRunConfigurationSerializer.loadRunConfiguration(name, configurationTag, jpsRunConfigurationPropertiesSerializer, project);
                continue;
            }
            project.addRunConfiguration(name, new JpsUnknownRunConfigurationType(typeId), JpsElementFactory.getInstance().createDummyElement());
        }
    }

    private static <P extends JpsElement> void loadRunConfiguration(String name, Element configurationTag, JpsRunConfigurationPropertiesSerializer<P> serializer, JpsProject project) {
        P properties = serializer.loadProperties(configurationTag);
        project.addRunConfiguration(name, (JpsRunConfigurationType)serializer.getType(), properties);
    }
}

