/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.BuilderService;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.groovy.GreclipseBuilder;
import org.jetbrains.jps.incremental.groovy.GreclipseMain;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;

public class GroovyBuilderService
extends BuilderService {
    @Nullable
    private static final ClassLoader ourGreclipseLoader = GroovyBuilderService.createGreclipseLoader();

    @Nullable
    private static ClassLoader createGreclipseLoader() {
        String jar = System.getProperty("groovy.eclipse.batch.jar");
        if (jar == null) {
            return null;
        }
        try {
            URL[] urls = new URL[]{new File(jar).toURI().toURL(), new File((String)ObjectUtils.assertNotNull((Object)PathManager.getJarPathForClass(GreclipseMain.class))).toURI().toURL()};
            URLClassLoader loader = new URLClassLoader(urls, null);
            Class.forName("org.eclipse.jdt.internal.compiler.batch.Main", false, loader);
            return loader;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public List<? extends ModuleLevelBuilder> createModuleLevelBuilders() {
        if (ourGreclipseLoader != null) {
            List<GreclipseBuilder> list = Arrays.asList(new GreclipseBuilder(ourGreclipseLoader));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyBuilderService", "createModuleLevelBuilders"));
            }
            return list;
        }
        List<GroovyBuilder> list = Arrays.asList(new GroovyBuilder(true), new GroovyBuilder(false));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyBuilderService", "createModuleLevelBuilders"));
        }
        return list;
    }
}

