/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.tools.AndroidApkBuilder;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.android.AndroidApkBuilderConfigState;
import org.jetbrains.jps.android.AndroidApkBuilderConfigStateStorage;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPackagingStateStorage;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidDexBuildTarget;
import org.jetbrains.jps.android.builder.AndroidPackagingBuildTarget;
import org.jetbrains.jps.android.builder.AndroidResourcePackagingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidPackagingBuilder
extends AndroidTargetBuilder<BuildRootDescriptor, AndroidPackagingBuildTarget> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidPackagingBuilder");
    private static final String BUILDER_NAME = "Android Packager";

    public AndroidPackagingBuilder() {
        super(Collections.singletonList(AndroidPackagingBuildTarget.MyTargetType.INSTANCE));
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidPackagingBuilder", "getPresentableName"));
        }
        return BUILDER_NAME;
    }

    @Override
    protected void buildTarget(@NotNull AndroidPackagingBuildTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, AndroidPackagingBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/AndroidPackagingBuilder", "buildTarget"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/jps/android/AndroidPackagingBuilder", "buildTarget"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/android/AndroidPackagingBuilder", "buildTarget"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidPackagingBuilder", "buildTarget"));
        }
        if (AndroidJpsUtil.isLightBuild(context)) {
            return;
        }
        boolean hasDirtyFiles = holder.hasDirtyFiles() || holder.hasRemovedFiles();
        try {
            if (!AndroidPackagingBuilder.doPackaging(target, context, target.getModule(), hasDirtyFiles, outputConsumer)) {
                throw new StopBuildException();
            }
        }
        catch (ProjectBuildException e) {
            throw e;
        }
        catch (Exception e) {
            AndroidJpsUtil.handleException(context, e, BUILDER_NAME, LOG);
        }
    }

    private static boolean doPackaging(@NotNull BuildTarget<?> target, @NotNull CompileContext context, @NotNull JpsModule module, boolean hasDirtyFiles, @NotNull BuildOutputConsumer outputConsumer) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/AndroidPackagingBuilder", "doPackaging"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidPackagingBuilder", "doPackaging"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/AndroidPackagingBuilder", "doPackaging"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/android/AndroidPackagingBuilder", "doPackaging"));
        }
        boolean release = AndroidJpsUtil.isReleaseBuild(context);
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        boolean success = true;
        AndroidApkBuilderConfigStateStorage.Provider builderStateStoragetProvider = new AndroidApkBuilderConfigStateStorage.Provider("apk_builder_config");
        AndroidApkBuilderConfigStateStorage apkBuilderConfigStateStorage = (AndroidApkBuilderConfigStateStorage)dataManager.getStorage(target, (StorageProvider)builderStateStoragetProvider);
        AndroidPackagingStateStorage packagingStateStorage = (AndroidPackagingStateStorage)dataManager.getStorage(target, (StorageProvider)AndroidPackagingStateStorage.Provider.INSTANCE);
        try {
            if (!AndroidPackagingBuilder.doPackagingForModule(context, module, apkBuilderConfigStateStorage, packagingStateStorage, release, hasDirtyFiles, outputConsumer)) {
                success = false;
            }
        }
        catch (IOException e) {
            AndroidJpsUtil.reportExceptionError(context, null, e, BUILDER_NAME);
            success = false;
        }
        return success;
    }

    private static boolean doPackagingForModule(@NotNull CompileContext context, @NotNull JpsModule module, @NotNull AndroidApkBuilderConfigStateStorage apkBuilderConfigStateStorage, @NotNull AndroidPackagingStateStorage packagingStateStorage, boolean release, boolean hasDirtyFiles, @NotNull BuildOutputConsumer outputConsumer) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidPackagingBuilder", "doPackagingForModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/AndroidPackagingBuilder", "doPackagingForModule"));
        }
        if (apkBuilderConfigStateStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkBuilderConfigStateStorage", "org/jetbrains/jps/android/AndroidPackagingBuilder", "doPackagingForModule"));
        }
        if (packagingStateStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagingStateStorage", "org/jetbrains/jps/android/AndroidPackagingBuilder", "doPackagingForModule"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/android/AndroidPackagingBuilder", "doPackagingForModule"));
        }
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        if (extension == null || extension.isLibrary()) {
            return true;
        }
        Object[] resourceRoots = AndroidJpsUtil.toPaths(AndroidJpsUtil.getJavaOutputRootsForModuleAndDependencies(module));
        Arrays.sort(resourceRoots);
        File moduleOutputDir = ProjectPaths.getModuleOutputDir((JpsModule)module, (boolean)false);
        if (moduleOutputDir == null) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.output.dir.not.specified", module.getName())));
            return false;
        }
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(module, context, BUILDER_NAME);
        if (platform == null) {
            return false;
        }
        HashSet externalJarsSet = new HashSet();
        for (String jarPath : AndroidJpsUtil.getExternalLibraries(context, module, platform)) {
            if (!new File(jarPath).exists()) continue;
            externalJarsSet.add(jarPath);
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        File resPackage = AndroidResourcePackagingBuildTarget.getOutputFile(dataPaths, module);
        File classesDexFile = AndroidDexBuildTarget.getOutputFile(dataPaths, module);
        String sdkPath = platform.getSdk().getHomePath();
        String outputPath = AndroidJpsUtil.getApkPath(extension, moduleOutputDir);
        if (outputPath == null) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.cannot.compute.output.apk", module.getName())));
            return false;
        }
        String customKeyStorePath = FileUtil.toSystemDependentName((String)extension.getCustomDebugKeyStorePath());
        String[] nativeLibDirs = AndroidPackagingBuildTarget.collectNativeLibsFolders(extension, true);
        String resPackagePath = resPackage.getPath();
        String classesDexFilePath = classesDexFile.getPath();
        Object[] externalJars = ArrayUtil.toStringArray((Collection)externalJarsSet);
        Arrays.sort(externalJars);
        List<AndroidNativeLibData> additionalNativeLibs = extension.getAdditionalNativeLibs();
        AndroidApkBuilderConfigState currentApkBuilderConfigState = new AndroidApkBuilderConfigState(outputPath, customKeyStorePath, additionalNativeLibs);
        if (!hasDirtyFiles) {
            AndroidApkBuilderConfigState savedApkBuilderConfigState = (AndroidApkBuilderConfigState)apkBuilderConfigStateStorage.getState(module.getName());
            AndroidPackagingStateStorage.MyState packagingState = packagingStateStorage.read();
            if (currentApkBuilderConfigState.equalsTo(savedApkBuilderConfigState) && packagingState != null && packagingState.isRelease() == release) {
                return true;
            }
        }
        context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.packaging", AndroidJpsUtil.getApkName(module))));
        Map<AndroidCompilerMessageKind, List<String>> messages = AndroidApkBuilder.execute(resPackagePath, classesDexFilePath, (String[])resourceRoots, (String[])externalJars, nativeLibDirs, additionalNativeLibs, outputPath, release, sdkPath, platform.getTarget(), customKeyStorePath, new MyExcludedSourcesFilter(context.getProjectDescriptor().getProject()));
        if (messages.get((Object)AndroidCompilerMessageKind.ERROR).size() == 0) {
            final ArrayList<String> srcFiles = new ArrayList<String>();
            srcFiles.add(resPackagePath);
            srcFiles.add(classesDexFilePath);
            for (Object resourceRoot : resourceRoots) {
                FileUtil.processFilesRecursively((File)new File((String)resourceRoot), (Processor)new Processor<File>(){

                    public boolean process(File file) {
                        if (file.isFile() && AndroidApkBuilder.checkFileForPackaging(file)) {
                            srcFiles.add(file.getPath());
                        }
                        return true;
                    }
                });
            }
            Collections.addAll(srcFiles, externalJars);
            for (String nativeLibDir : nativeLibDirs) {
                FileUtil.processFilesRecursively((File)new File(nativeLibDir), (Processor)new Processor<File>(){

                    public boolean process(File file) {
                        if (file.isFile()) {
                            srcFiles.add(file.getPath());
                        }
                        return true;
                    }
                });
            }
            outputConsumer.registerOutputFile(new File(outputPath), srcFiles);
        }
        AndroidJpsUtil.addMessages(context, messages, BUILDER_NAME, module.getName());
        boolean success = messages.get((Object)AndroidCompilerMessageKind.ERROR).isEmpty();
        apkBuilderConfigStateStorage.update(module.getName(), success ? currentApkBuilderConfigState : null);
        packagingStateStorage.saveState(new AndroidPackagingStateStorage.MyState(release));
        return success;
    }

    private static class MyExcludedSourcesFilter
    implements Condition<File> {
        private final JpsCompilerExcludes myExcludes;

        public MyExcludedSourcesFilter(@NotNull JpsProject project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/android/AndroidPackagingBuilder$MyExcludedSourcesFilter", "<init>"));
            }
            this.myExcludes = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project).getCompilerExcludes();
        }

        public boolean value(File file) {
            return !this.myExcludes.isExcluded(file);
        }
    }
}

