/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.google.common.base.Strings;
import java.util.Locale;

public class SdkVersionInfo {
    public static final int HIGHEST_KNOWN_API = 21;
    public static final int HIGHEST_KNOWN_STABLE_API = 21;
    public static final int LOWEST_ACTIVE_API = 8;

    @Nullable
    public static String getAndroidName(int api) {
        switch (api) {
            case 1: {
                return "API 1: Android 1.0";
            }
            case 2: {
                return "API 2: Android 1.1";
            }
            case 3: {
                return "API 3: Android 1.5 (Cupcake)";
            }
            case 4: {
                return "API 4: Android 1.6 (Donut)";
            }
            case 5: {
                return "API 5: Android 2.0 (Eclair)";
            }
            case 6: {
                return "API 6: Android 2.0.1 (Eclair)";
            }
            case 7: {
                return "API 7: Android 2.1 (Eclair)";
            }
            case 8: {
                return "API 8: Android 2.2 (Froyo)";
            }
            case 9: {
                return "API 9: Android 2.3 (Gingerbread)";
            }
            case 10: {
                return "API 10: Android 2.3.3 (Gingerbread)";
            }
            case 11: {
                return "API 11: Android 3.0 (Honeycomb)";
            }
            case 12: {
                return "API 12: Android 3.1 (Honeycomb)";
            }
            case 13: {
                return "API 13: Android 3.2 (Honeycomb)";
            }
            case 14: {
                return "API 14: Android 4.0 (IceCreamSandwich)";
            }
            case 15: {
                return "API 15: Android 4.0.3 (IceCreamSandwich)";
            }
            case 16: {
                return "API 16: Android 4.1 (Jelly Bean)";
            }
            case 17: {
                return "API 17: Android 4.2 (Jelly Bean)";
            }
            case 18: {
                return "API 18: Android 4.3 (Jelly Bean)";
            }
            case 19: {
                return "API 19: Android 4.4 (KitKat)";
            }
            case 20: {
                return "API 20: Android 4.4 (KitKat Wear)";
            }
            case 21: {
                return "API 21: Android 5.0 (Lollipop)";
            }
        }
        return null;
    }

    public static String getCodeName(int api) {
        int end;
        int start;
        String s = SdkVersionInfo.getAndroidName(api);
        if (s != null && (start = s.indexOf(40)) != -1 && (end = s.indexOf(41, ++start)) != -1) {
            return s.substring(start, end);
        }
        return null;
    }

    @Nullable
    public static String getBuildCode(int api) {
        switch (api) {
            case 1: {
                return "BASE";
            }
            case 2: {
                return "BASE_1_1";
            }
            case 3: {
                return "CUPCAKE";
            }
            case 4: {
                return "DONUT";
            }
            case 5: {
                return "ECLAIR";
            }
            case 6: {
                return "ECLAIR_0_1";
            }
            case 7: {
                return "ECLAIR_MR1";
            }
            case 8: {
                return "FROYO";
            }
            case 9: {
                return "GINGERBREAD";
            }
            case 10: {
                return "GINGERBREAD_MR1";
            }
            case 11: {
                return "HONEYCOMB";
            }
            case 12: {
                return "HONEYCOMB_MR1";
            }
            case 13: {
                return "HONEYCOMB_MR2";
            }
            case 14: {
                return "ICE_CREAM_SANDWICH";
            }
            case 15: {
                return "ICE_CREAM_SANDWICH_MR1";
            }
            case 16: {
                return "JELLY_BEAN";
            }
            case 17: {
                return "JELLY_BEAN_MR1";
            }
            case 18: {
                return "JELLY_BEAN_MR2";
            }
            case 19: {
                return "KITKAT";
            }
            case 20: {
                return "KITKAT_WATCH";
            }
            case 21: {
                return "LOLLIPOP";
            }
        }
        return null;
    }

    public static int getApiByBuildCode(String buildCode, boolean recognizeUnknowns) {
        for (int api = 1; api <= 21; ++api) {
            String code = SdkVersionInfo.getBuildCode(api);
            if (code == null || !code.equalsIgnoreCase(buildCode)) continue;
            return api;
        }
        if (buildCode.equalsIgnoreCase("L")) {
            return 21;
        }
        return recognizeUnknowns ? 22 : -1;
    }

    public static int getApiByPreviewName(String previewName, boolean recognizeUnknowns) {
        String codeName = SdkVersionInfo.camelCaseToUnderlines(previewName).toUpperCase(Locale.US);
        return SdkVersionInfo.getApiByBuildCode(codeName, recognizeUnknowns);
    }

    public static String camelCaseToUnderlines(String string) {
        if (string.isEmpty()) {
            return string;
        }
        StringBuilder sb = new StringBuilder(2 * string.length());
        int n = string.length();
        boolean lastWasUpperCase = Character.isUpperCase(string.charAt(0));
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase && !lastWasUpperCase) {
                sb.append('_');
            }
            lastWasUpperCase = isUpperCase;
            c = Character.toLowerCase(c);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlinesToCamelCase(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        boolean upcaseNext = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                upcaseNext = true;
                continue;
            }
            if (upcaseNext) {
                c = Character.toUpperCase(c);
            }
            upcaseNext = false;
            sb.append(c);
        }
        return sb.toString();
    }

    @Nullable
    public static AndroidVersion getVersion(@Nullable String apiOrPreviewName, @Nullable IAndroidTarget[] targets) {
        int api;
        if (Strings.isNullOrEmpty((String)apiOrPreviewName)) {
            return null;
        }
        if (Character.isDigit(apiOrPreviewName.charAt(0))) {
            try {
                int api2 = Integer.parseInt(apiOrPreviewName);
                if (api2 >= 1) {
                    return new AndroidVersion(api2, null);
                }
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (targets != null) {
            for (int i = targets.length - 1; i >= 0; --i) {
                AndroidVersion version;
                IAndroidTarget target = targets[i];
                if (!target.isPlatform() || !(version = target.getVersion()).isPreview() || !apiOrPreviewName.equalsIgnoreCase(version.getCodename())) continue;
                return new AndroidVersion(version.getApiLevel(), version.getCodename());
            }
        }
        if ((api = SdkVersionInfo.getApiByPreviewName(apiOrPreviewName, false)) != -1) {
            return new AndroidVersion(api - 1, apiOrPreviewName);
        }
        return new AndroidVersion(21, apiOrPreviewName);
    }
}

