/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class HeavyProcessLatch {
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final AtomicInteger myHeavyProcessCounter = new AtomicInteger();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);

    private HeavyProcessLatch() {
    }

    public void processStarted() {
        this.myHeavyProcessCounter.incrementAndGet();
        this.myEventDispatcher.getMulticaster().processStarted();
    }

    public void processFinished() {
        this.myHeavyProcessCounter.decrementAndGet();
        this.myEventDispatcher.getMulticaster().processFinished();
    }

    public boolean isRunning() {
        return this.myHeavyProcessCounter.get() != 0;
    }

    public void addListener(@NotNull Disposable parentDisposable, @NotNull HeavyProcessListener listener) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/io/storage/HeavyProcessLatch", "addListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/io/storage/HeavyProcessLatch", "addListener"));
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    public static interface HeavyProcessListener
    extends EventListener {
        public void processStarted();

        public void processFinished();
    }
}

