/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.socksx.SocksMessage;
import io.netty.handler.codec.socksx.SocksProtocolVersion;
import io.netty.handler.codec.socksx.v5.Socks5Request;
import io.netty.handler.codec.socksx.v5.Socks5Response;

@ChannelHandler.Sharable
public final class Socks5MessageEncoder
extends MessageToByteEncoder<SocksMessage> {
    public static final Socks5MessageEncoder INSTANCE = new Socks5MessageEncoder();

    private Socks5MessageEncoder() {
    }

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && ((SocksMessage)msg).protocolVersion() == SocksProtocolVersion.SOCKS5;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, SocksMessage msg, ByteBuf out) throws Exception {
        if (msg instanceof Socks5Response) {
            ((Socks5Response)msg).encodeAsByteBuf(out);
        } else if (msg instanceof Socks5Request) {
            ((Socks5Request)msg).encodeAsByteBuf(out);
        } else {
            throw new Error();
        }
    }
}

