/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.groovy.EclipseOutputParser;
import org.jetbrains.jps.incremental.groovy.GreclipseMain;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovycOSProcessHandler;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.module.JpsModule;

public class GreclipseBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.groovy.GreclipseBuilder");
    private static final Key<Boolean> COMPILER_VERSION_INFO = Key.create((String)"_greclipse_compiler_info_");
    private final ClassLoader myGreclipseLoader;

    protected GreclipseBuilder(@NotNull ClassLoader greclipseLoader) {
        if (greclipseLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "greclipseLoader", "org/jetbrains/jps/incremental/groovy/GreclipseBuilder", "<init>"));
        }
        super(BuilderCategory.TRANSLATOR);
        this.myGreclipseLoader = greclipseLoader;
    }

    public List<String> getCompilableFileExtensions() {
        return Arrays.asList("groovy", "java");
    }

    public void buildStarted(CompileContext context) {
        JavaBuilder.IS_ENABLED.set((UserDataHolder)context, (Object)Boolean.FALSE);
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        try {
            Boolean notified;
            List<File> toCompile = GroovyBuilder.collectChangedFiles(context, dirtyFilesHolder, false, true);
            if (toCompile.isEmpty()) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            Map<ModuleBuildTarget, String> outputDirs = GroovyBuilder.getCanonicalModuleOutputs(context, chunk, (Builder)this);
            if (outputDirs == null) {
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            JpsJavaExtensionService javaExt = JpsJavaExtensionService.getInstance();
            JpsJavaCompilerConfiguration compilerConfig = javaExt.getCompilerConfiguration(context.getProjectDescriptor().getProject());
            assert (compilerConfig != null);
            Set modules = chunk.getModules();
            ProcessorConfigProfile profile = null;
            if (modules.size() == 1) {
                profile = compilerConfig.getAnnotationProcessingProfile((JpsModule)modules.iterator().next());
            } else {
                String message = JavaBuilder.validateCycle((ModuleChunk)chunk, (JpsJavaExtensionService)javaExt, (JpsJavaCompilerConfiguration)compilerConfig, (Set)modules);
                if (message != null) {
                    context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, message));
                    return ModuleLevelBuilder.ExitCode.ABORT;
                }
            }
            String mainOutputDir = outputDirs.get(chunk.representativeTarget());
            List<String> args = GreclipseBuilder.createCommandLine(context, chunk, toCompile, mainOutputDir, profile);
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.debug("Compiling with args: " + args);
            }
            if ((notified = (Boolean)COMPILER_VERSION_INFO.get((UserDataHolder)context)) != Boolean.TRUE) {
                context.processMessage((BuildMessage)new CompilerMessage("", BuildMessage.Kind.INFO, "Using Groovy-Eclipse to compile Java & Groovy sources"));
                COMPILER_VERSION_INFO.set((UserDataHolder)context, (Object)Boolean.TRUE);
            }
            context.processMessage((BuildMessage)new ProgressMessage("Compiling java & groovy [" + chunk.getPresentableShortName() + "]"));
            StringWriter out = new StringWriter();
            StringWriter err = new StringWriter();
            HashMap outputMap = ContainerUtil.newHashMap();
            boolean success = this.performCompilation(args, out, err, outputMap, context, chunk);
            ArrayList items = ContainerUtil.newArrayList();
            for (String src : outputMap.keySet()) {
                for (String classFile : (List)outputMap.get(src)) {
                    items.add(new GroovycOSProcessHandler.OutputItem(FileUtil.toSystemIndependentName((String)(mainOutputDir + classFile)), FileUtil.toSystemIndependentName((String)src)));
                }
            }
            Map<ModuleBuildTarget, Collection<GroovycOSProcessHandler.OutputItem>> successfullyCompiled = GroovyBuilder.processCompiledFiles(context, chunk, outputDirs, mainOutputDir, items);
            EclipseOutputParser parser = new EclipseOutputParser(this.getPresentableName(), chunk);
            List messages = ContainerUtil.concat(parser.parseMessages(out.toString()), parser.parseMessages(err.toString()));
            boolean hasError = false;
            for (CompilerMessage message : messages) {
                if (message.getKind() == BuildMessage.Kind.ERROR) {
                    hasError = true;
                }
                context.processMessage((BuildMessage)message);
            }
            if (!success && !hasError) {
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, "Compilation failed"));
            }
            GroovyBuilder.updateDependencies(context, toCompile, successfullyCompiled, outputConsumer, (Builder)this);
            return ModuleLevelBuilder.ExitCode.OK;
        }
        catch (Exception e) {
            throw new ProjectBuildException((Throwable)e);
        }
    }

    private boolean performCompilation(List<String> args, StringWriter out, StringWriter err, Map<String, List<String>> outputs, CompileContext context, ModuleChunk chunk) {
        try {
            Class<?> mainClass = Class.forName(GreclipseMain.class.getName(), true, this.myGreclipseLoader);
            Constructor<?> constructor = mainClass.getConstructor(PrintWriter.class, PrintWriter.class, Map.class, Map.class);
            Method compileMethod = mainClass.getMethod("compile", String[].class);
            HashMap customDefaultOptions = ContainerUtil.newHashMap();
            customDefaultOptions.put("org.eclipse.jdt.core.compiler.groovy.groovyClassLoaderPath", GreclipseBuilder.getClasspathString(chunk));
            customDefaultOptions.put("org.eclipse.jdt.core.compiler.groovy.groovyProjectName", chunk.getPresentableShortName());
            Object main = constructor.newInstance(new PrintWriter(out), new PrintWriter(err), customDefaultOptions, outputs);
            return (Boolean)compileMethod.invoke(main, new Object[]{ArrayUtil.toStringArray(args)});
        }
        catch (Exception e) {
            context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), (Throwable)e));
            return false;
        }
    }

    private static List<String> createCommandLine(CompileContext context, ModuleChunk chunk, List<File> srcFiles, String mainOutputDir, ProcessorConfigProfile profile) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-cp");
        args.add(GreclipseBuilder.getClasspathString(chunk));
        JavaBuilder.addCompilationOptions(args, (CompileContext)context, (ModuleChunk)chunk, (ProcessorConfigProfile)profile);
        args.add("-d");
        args.add(mainOutputDir);
        for (File file : srcFiles) {
            args.add(file.getPath());
        }
        return args;
    }

    private static String getClasspathString(ModuleChunk chunk) {
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        for (File file : ProjectPaths.getCompilationClasspathFiles((ModuleChunk)chunk, (boolean)chunk.containsTests(), (boolean)false, (boolean)false)) {
            if (!file.exists()) continue;
            cp.add(FileUtil.toCanonicalPath((String)file.getPath()));
        }
        return StringUtil.join(cp, (String)File.pathSeparator);
    }

    @NotNull
    public String getPresentableName() {
        if ("Groovy-Eclipse" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GreclipseBuilder", "getPresentableName"));
        }
        return "Groovy-Eclipse";
    }
}

